/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.util.Enumeration;
import java.util.Hashtable;
import zeus.concepts.Address;
import zeus.concepts.AddressBook;
import zeus.concepts.FIPA_AID_Address;

public class FIPA_AddressBook
extends AddressBook {
    private Hashtable FIPA_Addresses = new Hashtable();

    public boolean add(FIPA_AID_Address fIPA_AID_Address) {
        this.FIPA_Addresses.put(fIPA_AID_Address.getAlias(), fIPA_AID_Address);
        return true;
    }

    public FIPA_AID_Address lookupFIPA(String string) {
        Enumeration enumeration = this.FIPA_Addresses.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equals(string)) continue;
            return (FIPA_AID_Address)this.FIPA_Addresses.get(string2);
        }
        return null;
    }

    public FIPA_AID_Address lookupAlias(String string) {
        Enumeration enumeration = this.FIPA_Addresses.elements();
        while (enumeration.hasMoreElements()) {
            try {
                FIPA_AID_Address fIPA_AID_Address = (FIPA_AID_Address)enumeration.nextElement();
                String string2 = fIPA_AID_Address.getAlias();
                if (!string2.equals(string)) continue;
                return fIPA_AID_Address;
            }
            catch (ClassCastException classCastException) {
            }
        }
        return null;
    }

    public FIPA_AID_Address checkAddress(Address address) {
        String string = FIPA_AddressBook.makeAlias(address);
        FIPA_AID_Address fIPA_AID_Address = this.lookupFIPA(string);
        if (fIPA_AID_Address != null) {
            return fIPA_AID_Address;
        }
        try {
            return (FIPA_AID_Address)address;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Probably class cast problem in checkAddress");
            System.out.println("You may have tried to check to see if a Zeus format");
            System.out.println("address is a FIPA_AID_Address - sorry, this causes an Exception ");
            return null;
        }
    }

    public static String makeAlias(Address address) {
        String string = address.getHost();
        string.replace(':', 'X');
        string.replace('/', 'X');
        return address.getName() + string;
    }
}

