/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import FIPA.AgentID;
import FIPA.DateTime;
import FIPA.Envelope;
import FIPA.FipaMessage;
import FIPA.Property;
import FIPA.ReceivedObject;
import java.util.Enumeration;
import java.util.Vector;
import javax.agent.Identifier;
import zeus.concepts.Address;
import zeus.concepts.FIPA_AID_Address;
import zeus.concepts.FIPA_Received;
import zeus.concepts.Performative;
import zeus.util.FIPA_Date;

public class FIPAPerformative
extends Performative {
    FIPA_AID_Address sender = null;
    Vector received = new Vector();
    protected String encrypted = "NO";

    public FIPAPerformative(String string) {
        this.type = string;
    }

    public FIPAPerformative(Performative performative) {
        Enumeration enumeration;
        String string = performative.getType();
        if (string != null) {
            this.setType(string);
        }
        if ((string = performative.getSender()) != null) {
            this.setSender(string);
        }
        if ((enumeration = performative.getReceivers()) != null) {
            this.setReceivers(enumeration);
        }
        if ((string = performative.getReplyWith()) != null) {
            this.setReplyWith(string);
        }
        if ((string = performative.getInReplyTo()) != null) {
            this.setInReplyTo(string);
        }
        if ((string = performative.getReplyBy()) != null) {
            this.setReplyBy(string);
        }
        if ((string = performative.getOntology()) != null) {
            this.setOntology(string);
        }
        if ((string = performative.getLanguage()) != null) {
            this.setLanguage(string);
        }
        if ((string = performative.getContent()) != null) {
            this.setContent(string);
        }
        if ((string = performative.getProtocol()) != null) {
            this.setProtocol(string);
        }
        if ((string = performative.getConversationId()) != null) {
            this.setConversationId(string);
        }
    }

    public Enumeration getFIPAReceivers() {
        return this.receivers.elements();
    }

    public Enumeration getReceivers() {
        Enumeration enumeration = this.receivers.elements();
        Vector<String> vector = new Vector<String>();
        String string = null;
        Address address = null;
        while (enumeration.hasMoreElements()) {
            address = (Address)enumeration.nextElement();
            string = address.getName();
            vector.addElement(string);
        }
        return vector.elements();
    }

    public Performative performative() {
        return new Performative(this);
    }

    public String getSender_As_FIPA_String() {
        return this.sender.toFIPAString();
    }

    public FIPA_AID_Address getSender_As_FIPA_AID() {
        return this.sender;
    }

    public void setReceived(FIPA_Received fIPA_Received) {
        this.received.addElement(fIPA_Received);
    }

    public String receivedToXML() {
        if (this.received.isEmpty()) {
            FIPA_Received fIPA_Received = new FIPA_Received();
            Enumeration enumeration = this.getFIPAReceivers();
            FIPA_AID_Address fIPA_AID_Address = (FIPA_AID_Address)enumeration.nextElement();
            String string = (String)fIPA_AID_Address.getAddresses().firstElement();
            fIPA_Received.setReceivedBy(string);
            fIPA_Received.setReceivedDate(FIPA_Date.getDate());
            return fIPA_Received.toXML();
        }
        String string = new String();
        Enumeration enumeration = this.received.elements();
        while (enumeration.hasMoreElements()) {
            string = string + ((FIPA_Received)enumeration.nextElement()).toXML();
        }
        return string;
    }

    public void appendContent(String string) {
        if (this.content == null) {
            this.content = new String();
        }
        if (this.content.equals("null")) {
            this.content = new String();
        }
        if (string != null && !string.equals("null")) {
            this.content = this.content + string;
        }
    }

    public void setSender(FIPA_AID_Address fIPA_AID_Address) {
        this.sender = fIPA_AID_Address;
    }

    public String toFIPAString() {
        String string = "(" + this.type.toUpperCase() + "\n";
        if (this.sender != null) {
            string = string + " :sender ( " + this.getSender_As_FIPA_String() + " )\n";
        }
        if (this.receivers != null && !this.receivers.isEmpty()) {
            string = string + " :receiver (set ";
            Enumeration enumeration = this.getFIPAReceivers();
            while (enumeration.hasMoreElements()) {
                FIPA_AID_Address fIPA_AID_Address = (FIPA_AID_Address)enumeration.nextElement();
                String string2 = "(" + fIPA_AID_Address.toFIPAString() + ")";
                string = string + string2;
            }
            string = string + " )\n";
        }
        if (this.replyWith != null) {
            string = string + " :reply-with " + this.replyWith + "\n";
        }
        if (this.inReplyTo != null) {
            string = string + " :in-reply-to " + this.inReplyTo + "\n";
        }
        if (this.replyBy != null) {
            string = string + " :reply-by " + this.replyBy + "\n";
        }
        if (this.ontology != null) {
            string = string + " :ontology " + this.ontology + "\n";
        }
        if (this.language != null) {
            string = string + " :language " + this.language + "\n";
        }
        if (this.content != null) {
            string = string + " :content \"" + this.content + "\"\n";
        }
        if (this.protocol != null) {
            string = string + " :protocol " + this.protocol + "\n";
        }
        if (this.conversationId != null) {
            string = string + " :conversation-id " + this.conversationId + "\n";
        }
        if (this.replyTo != null) {
            string = string + " :reply-to " + this.replyTo + "\n";
        }
        string = string + ")\n";
        return string;
    }

    public AgentID[] getReceiversAgentID() {
        int n = this.receivers.size();
        AgentID[] agentIDArray = new AgentID[n];
        Enumeration enumeration = this.receivers.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            agentIDArray[n2] = ((FIPA_AID_Address)enumeration.nextElement()).getAgentID();
            ++n2;
        }
        return agentIDArray;
    }

    public AgentID[] getSenderAgentID() {
        AgentID[] agentIDArray = new AgentID[]{this.sender.getAgentID()};
        return agentIDArray;
    }

    public String getEncryptionScheme() {
        return this.encrypted;
    }

    public void setEncryptionDescriptor(String string) {
        this.encrypted = string;
    }

    public FIPA_AID_Address getFIPAReceiver() {
        Enumeration enumeration = this.receivers.elements();
        return (FIPA_AID_Address)enumeration.nextElement();
    }

    public javax.agent.Envelope jasEnvelope(FIPA_AID_Address fIPA_AID_Address, String string) {
        Identifier identifier = null;
        Identifier identifier2 = null;
        javax.agent.Envelope envelope = new javax.agent.Envelope(identifier, identifier2, this);
        return envelope;
    }

    public String getSenderXML() {
        return this.sender.toXML();
    }

    public String getReceiversXML() {
        Enumeration enumeration = this.receivers.elements();
        String string = new String();
        while (enumeration.hasMoreElements()) {
            FIPA_AID_Address fIPA_AID_Address = (FIPA_AID_Address)enumeration.nextElement();
            string = string + fIPA_AID_Address.toXML();
        }
        return string;
    }

    public String get_is_EncryptedXML() {
        String string = new String("<encrypted>");
        string = this.getEncryptionScheme().equals("NO") ? string + "no encryption" : string + this.getEncryptionScheme();
        string = string + "</encrypted>";
        return string;
    }

    public FipaMessage FipaMessage() {
        Envelope envelope = new Envelope();
        try {
            envelope.to = this.getReceiversAgentID();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            envelope.from = this.getSenderAgentID();
        }
        catch (NullPointerException nullPointerException) {
            envelope.from = new AgentID[0];
        }
        try {
            envelope.comments = new String("Zeus Agent Building Environment v1.1");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        envelope.payloadLength = -1;
        envelope.payloadEncoding = new String("String");
        envelope.aclRepresentation = new String("fipa-string-std");
        envelope.date = new DateTime[0];
        envelope.encrypted = new String[1];
        envelope.encrypted[0] = this.getEncryptionScheme();
        envelope.intendedReceiver = this.getReceiversAgentID();
        envelope.received = new ReceivedObject[0];
        envelope.transportBehaviour = new Property[0][0];
        envelope.userDefinedProperties = new Property[0];
        Envelope[] envelopeArray = new Envelope[]{envelope};
        FipaMessage fipaMessage = new FipaMessage(envelopeArray, this.toFIPAString().getBytes());
        return fipaMessage;
    }
}

