/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.util.List;
import java.util.Vector;
import zeus.concepts.Acquaintance;
import zeus.concepts.Fact;
import zeus.concepts.ProtocolInfo;
import zeus.concepts.Restriction;
import zeus.util.Assert;
import zeus.util.Misc;
import zeus.util.SystemProps;

public class AgentDescription {
    protected String name = SystemProps.getProperty("agent.default.name");
    protected String xClass = SystemProps.getProperty("agent.default.class");
    protected int planner_width = SystemProps.getInt("agent.default.planner.processors");
    protected int planner_length = SystemProps.getInt("agent.default.planner.length");
    protected int doublebook_fraction = SystemProps.getInt("agent.default.planner.doublebooking");
    protected Vector tasks = new Vector();
    protected Vector initialFacts = new Vector();
    protected Vector protocols = new Vector();
    protected Vector acquaintances = new Vector();
    protected List restrictions = new Vector();

    public AgentDescription() {
    }

    public AgentDescription(AgentDescription agentDescription) {
        this.name = agentDescription.getName();
        this.xClass = agentDescription.getAgentClass();
        this.planner_width = agentDescription.getPlannerWidth();
        this.planner_length = agentDescription.getPlannerLength();
        this.doublebook_fraction = agentDescription.getDoublebookFraction();
        this.setTasks(agentDescription.getTasks());
        this.setInitialFacts(agentDescription.getInitialFacts());
        this.setProtocols(agentDescription.getProtocols());
        this.setAcquaintances(agentDescription.getAcquaintances());
        this.setRestrictions(agentDescription.getRestrictions());
    }

    public void setName(String string) {
        Assert.notNull(string);
        this.name = string;
    }

    public void setAgentClass(String string) {
        Assert.notNull(string);
        this.xClass = string;
    }

    public void setPlannerWidth(int n) {
        Assert.notFalse(n >= SystemProps.getInt("planner.processors.min") && n <= SystemProps.getInt("planner.processors.max"));
        this.planner_width = n;
    }

    public void setPlannerLength(int n) {
        Assert.notFalse(n >= SystemProps.getInt("planner.length.min") && n <= SystemProps.getInt("planner.length.max"));
        this.planner_length = n;
    }

    public void setDoublebookFraction(int n) {
        Assert.notFalse(n >= SystemProps.getInt("planner.doublebooking.min") && n <= SystemProps.getInt("planner.doublebooking.max"));
        this.doublebook_fraction = n;
    }

    public void setTasks(Vector vector) {
        this.tasks.removeAllElements();
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.tasks.addElement(vector.elementAt(i));
        }
    }

    public void setTasks(String[] stringArray) {
        this.tasks.removeAllElements();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.tasks.addElement(stringArray[i]);
        }
    }

    public boolean removeTask(String string) {
        return this.tasks.removeElement(string);
    }

    public boolean containsTask(String string) {
        return this.tasks.contains(string);
    }

    public void setInitialFacts(Vector vector) {
        this.initialFacts.removeAllElements();
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.initialFacts.addElement(new Fact((Fact)vector.elementAt(i)));
        }
    }

    public void setInitialFacts(Fact[] factArray) {
        this.initialFacts.removeAllElements();
        if (factArray == null) {
            return;
        }
        for (int i = 0; i < factArray.length; ++i) {
            this.initialFacts.addElement(new Fact(factArray[i]));
        }
    }

    public void setProtocols(Vector vector) {
        this.protocols.removeAllElements();
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.protocols.addElement(vector.elementAt(i));
        }
    }

    public void setProtocols(ProtocolInfo[] protocolInfoArray) {
        this.protocols.removeAllElements();
        if (protocolInfoArray == null) {
            return;
        }
        for (int i = 0; i < protocolInfoArray.length; ++i) {
            this.protocols.addElement(protocolInfoArray[i]);
        }
    }

    public void setAcquaintances(Vector vector) {
        this.acquaintances.removeAllElements();
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.acquaintances.addElement(new Acquaintance((Acquaintance)vector.elementAt(i)));
        }
    }

    public void setAcquaintances(Acquaintance[] acquaintanceArray) {
        this.acquaintances.removeAllElements();
        if (acquaintanceArray == null) {
            return;
        }
        for (int i = 0; i < acquaintanceArray.length; ++i) {
            this.acquaintances.addElement(new Acquaintance(acquaintanceArray[i]));
        }
    }

    public void setRestrictions(List list) {
        if (list != null) {
            this.restrictions = list;
        }
    }

    public List getRestrictions() {
        return this.restrictions;
    }

    public String getName() {
        return this.name;
    }

    public String getAgentClass() {
        return this.xClass;
    }

    public int getPlannerWidth() {
        return this.planner_width;
    }

    public int getPlannerLength() {
        return this.planner_length;
    }

    public int getDoublebookFraction() {
        return this.doublebook_fraction;
    }

    public String[] getTasks() {
        String[] stringArray = new String[this.tasks.size()];
        for (int i = 0; i < this.tasks.size(); ++i) {
            stringArray[i] = (String)this.tasks.elementAt(i);
        }
        return stringArray;
    }

    public ProtocolInfo[] getProtocols() {
        ProtocolInfo[] protocolInfoArray = new ProtocolInfo[this.protocols.size()];
        for (int i = 0; i < this.protocols.size(); ++i) {
            protocolInfoArray[i] = (ProtocolInfo)this.protocols.elementAt(i);
        }
        return protocolInfoArray;
    }

    public Fact[] getInitialFacts() {
        Fact[] factArray = new Fact[this.initialFacts.size()];
        for (int i = 0; i < this.initialFacts.size(); ++i) {
            factArray[i] = new Fact((Fact)this.initialFacts.elementAt(i));
        }
        return factArray;
    }

    public Acquaintance[] getAcquaintances() {
        Acquaintance[] acquaintanceArray = new Acquaintance[this.acquaintances.size()];
        for (int i = 0; i < this.acquaintances.size(); ++i) {
            acquaintanceArray[i] = new Acquaintance((Acquaintance)this.acquaintances.elementAt(i));
        }
        return acquaintanceArray;
    }

    public String toString() {
        int n;
        String string = "(:name " + this.name + " ";
        if (this.xClass != null && !this.xClass.trim().equals("")) {
            string = string + ":class " + this.xClass + " ";
        }
        string = string + ":planner_width " + this.planner_width + " ";
        string = string + ":planner_length " + this.planner_length + " ";
        string = string + ":doublebook_fraction " + this.doublebook_fraction + " ";
        if (!this.tasks.isEmpty()) {
            string = string + ":tasks (";
            for (n = 0; n < this.tasks.size(); ++n) {
                string = string + (String)this.tasks.elementAt(n) + " ";
            }
            string = string.trim() + ") ";
        }
        if (!this.initialFacts.isEmpty()) {
            string = string + ":initial_facts (";
            for (n = 0; n < this.initialFacts.size(); ++n) {
                string = string + ((Fact)this.initialFacts.elementAt(n)).toString();
            }
            string = string + ") ";
        }
        if (!this.protocols.isEmpty()) {
            string = string + ":protocols (";
            for (n = 0; n < this.protocols.size(); ++n) {
                string = string + this.protocols.elementAt(n) + " ";
            }
            string = string.trim() + ") ";
        }
        if (!this.acquaintances.isEmpty()) {
            string = string + ":acquaintances (";
            for (n = 0; n < this.acquaintances.size(); ++n) {
                string = string + ((Acquaintance)this.acquaintances.elementAt(n)).toString();
            }
            string = string + ") ";
        }
        if (!this.restrictions.isEmpty()) {
            string = string + ":restrictions (";
            for (n = 0; n < this.restrictions.size(); ++n) {
                string = string + ((Restriction)this.restrictions.get(n)).toString();
            }
            string = string + ") ";
        }
        return string.trim() + ")";
    }

    public String pprint() {
        return this.pprint(0);
    }

    public String pprint(int n) {
        int n2;
        String string;
        String string2;
        String string3 = Misc.spaces(n);
        String string4 = "\n" + string3 + " ";
        String string5 = "(:name " + this.name + string4;
        if (this.xClass != null && !this.xClass.trim().equals("")) {
            string5 = string5 + ":class " + this.xClass + string4;
        }
        string5 = string5 + ":planner_width " + this.planner_width + string4;
        string5 = string5 + ":planner_length " + this.planner_length + string4;
        string5 = string5 + ":doublebook_fraction " + this.doublebook_fraction + string4;
        if (!this.tasks.isEmpty()) {
            string2 = ":tasks ";
            string = Misc.spaces(1 + n + string2.length());
            string5 = string5 + string2 + "(";
            for (n2 = 0; n2 < this.tasks.size(); ++n2) {
                string5 = string5 + (String)this.tasks.elementAt(n2) + "\n" + string + " ";
            }
            string5 = string5.trim() + "\n" + string + ")" + string4;
        }
        if (!this.initialFacts.isEmpty()) {
            string2 = ":initial_facts ";
            string = Misc.spaces(1 + n + string2.length());
            string5 = string5 + string2 + "(";
            for (n2 = 0; n2 < this.initialFacts.size(); ++n2) {
                string5 = string5 + ((Fact)this.initialFacts.elementAt(n2)).pprint(1 + string.length()) + "\n" + string + " ";
            }
            string5 = string5.trim() + "\n" + string + ")" + string4;
        }
        if (!this.protocols.isEmpty()) {
            string2 = ":protocols ";
            string = Misc.spaces(1 + n + string2.length());
            string5 = string5 + string2 + "(";
            for (n2 = 0; n2 < this.protocols.size(); ++n2) {
                string5 = string5 + ((ProtocolInfo)this.protocols.elementAt(n2)).pprint(1 + string.length()) + "\n" + string + " ";
            }
            string5 = string5.trim() + "\n" + string + ")" + string4;
        }
        if (!this.acquaintances.isEmpty()) {
            string2 = ":acquaintances ";
            string = Misc.spaces(1 + n + string2.length());
            string5 = string5 + string2 + "(";
            for (n2 = 0; n2 < this.acquaintances.size(); ++n2) {
                string5 = string5 + ((Acquaintance)this.acquaintances.elementAt(n2)).pprint(1 + string.length()) + "\n" + string + " ";
            }
            string5 = string5.trim() + "\n" + string + ")" + string4;
        }
        if (!this.restrictions.isEmpty()) {
            string2 = ":restrictions ";
            string = Misc.spaces(1 + n + string2.length());
            string5 = string5 + string2 + "(";
            for (n2 = 0; n2 < this.restrictions.size(); ++n2) {
                string5 = string5 + ((Restriction)this.restrictions.get(n2)).pprint(1 + string.length()) + "\n" + string + " ";
            }
            string5 = string5.trim() + "\n" + string + ")" + string4;
        }
        return string3 + string5.trim() + "\n" + string3 + ")";
    }
}

