/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.util.List;
import java.util.Vector;
import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.concepts.Restriction;
import zeus.util.Assert;
import zeus.util.GenSym;
import zeus.util.Misc;
import zeus.util.SystemProps;

public abstract class AbstractTask {
    public static final int PRIMITIVE = 0;
    public static final int SUMMARY = 1;
    public static final int BEHAVIOUR = 2;
    public static final int SCRIPT = 3;
    private List restrictions;
    static String[] TaskTypes = new String[]{"Primitive", "Summary", "Rulebase", "PlanScript"};
    protected String name = SystemProps.getProperty("task.default.name");
    protected int type = 0;
    private String textInfo = "";
    private String phoneInfo = "";
    private String faxInfo = "";
    private String emailInfo = "";
    private String physicalInfo = "";
    private String geoInfo = "";

    public AbstractTask() {
        this.restrictions = new Vector();
    }

    public static int getType(String string) {
        return Misc.whichPosition(string, TaskTypes);
    }

    public static String getTypeName(int n) {
        return TaskTypes[n];
    }

    public void setName(String string) {
        Assert.notNull(string);
        Assert.notFalse(!string.equals(""));
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        return TaskTypes[this.type];
    }

    public boolean isPrimitive() {
        return this.type == 0;
    }

    public boolean isSummary() {
        return this.type == 1;
    }

    public boolean isBehaviour() {
        return this.type == 2;
    }

    public boolean isScript() {
        return this.type == 3;
    }

    public AbstractTask duplicate(String string, GenSym genSym) {
        DuplicationTable duplicationTable = new DuplicationTable(string, genSym);
        return this.duplicate(duplicationTable);
    }

    public String pprint() {
        return this.pprint(0);
    }

    public abstract AbstractTask duplicate(DuplicationTable var1);

    public abstract boolean isValid();

    public abstract String pprint(int var1);

    public abstract boolean resolve(Bindings var1);

    public void setTextInfo(String string) {
        this.textInfo = string;
    }

    public String getTextInfo() {
        return this.textInfo;
    }

    public void setPhoneInfo(String string) {
        this.phoneInfo = string;
    }

    public String getPhoneInfo() {
        return this.phoneInfo;
    }

    public void setFaxInfo(String string) {
        this.faxInfo = string;
    }

    public String getFaxInfo() {
        return this.faxInfo;
    }

    public void setEmailInfo(String string) {
        this.emailInfo = string;
    }

    public String getEmailInfo() {
        return this.emailInfo;
    }

    public void setPhysicalInfo(String string) {
        this.physicalInfo = string;
    }

    public String getPhysicalInfo() {
        return this.physicalInfo;
    }

    public void setGeoInfo(String string) {
        this.geoInfo = string;
    }

    public String getGeoInfo() {
        return this.geoInfo;
    }

    public void addRestriction(String string, String string2, String string3) {
        this.restrictions.add(new Restriction(this.getName(), string, string2, string3));
    }

    public List getRestrictions() {
        return this.restrictions;
    }
}

