/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.concepts.Fact;
import zeus.util.GenSym;
import zeus.util.Misc;

public class AbilitySpec {
    protected Fact fact;
    protected int time;
    protected double cost;
    protected String name = "noname";

    public AbilitySpec() {
    }

    public AbilitySpec(String string, Fact fact, int n, double d) {
        this.fact = new Fact(fact);
        this.time = n;
        this.cost = d;
        this.name = string;
    }

    public AbilitySpec(Fact fact, int n, double d) {
        this.fact = new Fact(fact);
        this.time = n;
        this.cost = d;
    }

    public AbilitySpec(AbilitySpec abilitySpec) {
        this.fact = new Fact(abilitySpec.getFact());
        this.time = abilitySpec.getTime();
        this.cost = abilitySpec.getCost();
    }

    public AbilitySpec duplicate(String string, GenSym genSym) {
        DuplicationTable duplicationTable = new DuplicationTable(string, genSym);
        return this.duplicate(duplicationTable);
    }

    public AbilitySpec duplicate(DuplicationTable duplicationTable) {
        return new AbilitySpec(this.name, this.fact.duplicate(duplicationTable), this.time, this.cost);
    }

    public String getType() {
        return this.fact.getType();
    }

    public String getId() {
        return this.fact.getId();
    }

    public Fact getFact() {
        return this.fact;
    }

    public int getTime() {
        return this.time;
    }

    public double getCost() {
        return this.cost;
    }

    public String getName() {
        return this.name;
    }

    public void setTime(int n) {
        this.time = n;
    }

    public void setCost(double d) {
        this.cost = d;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean resolve(Bindings bindings) {
        return this.fact.resolve(bindings);
    }

    public boolean equals(AbilitySpec abilitySpec) {
        return this.fact.equals(abilitySpec.getFact()) && this.time == abilitySpec.getTime() && Math.abs(this.cost - abilitySpec.getCost()) < 1.0E-12;
    }

    public String toString() {
        String string = "(:fact " + this.fact + " " + ":time " + this.time + " " + ":cost " + this.cost + " ";
        string = this.name != null ? string + ":name " + this.name + ")" : string + ":name NULL)";
        return string;
    }

    public String pprint() {
        return this.pprint(0);
    }

    public String pprint(int n) {
        String string = Misc.spaces(n);
        String string2 = "\n" + string + " ";
        String string3 = "(:fact ";
        String string4 = string3 + this.fact.pprint(n + string3.length()) + string2 + ":time " + this.time + string2 + ":cost " + this.cost + string2 + ":name NULL" + string2;
        return string4.trim() + "\n" + string + ")";
    }
}

