/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import zeus.concepts.AbilitySpec;
import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.util.GenSym;

public class AbilityDbItem {
    protected String agent;
    protected AbilitySpec ability;

    public AbilityDbItem() {
    }

    public AbilityDbItem(String string, AbilitySpec abilitySpec) {
        this.agent = string;
        this.ability = new AbilitySpec(abilitySpec);
    }

    public AbilityDbItem(AbilityDbItem abilityDbItem) {
        this.agent = abilityDbItem.getAgent();
        this.ability = new AbilitySpec(abilityDbItem.getAbility());
    }

    public AbilityDbItem duplicate(String string, GenSym genSym) {
        DuplicationTable duplicationTable = new DuplicationTable(string, genSym);
        return this.duplicate(duplicationTable);
    }

    public AbilityDbItem duplicate(DuplicationTable duplicationTable) {
        return new AbilityDbItem(this.agent, this.ability.duplicate(duplicationTable));
    }

    public String getAgent() {
        return this.agent;
    }

    public AbilitySpec getAbility() {
        return this.ability;
    }

    public String getType() {
        return this.ability.getType();
    }

    public boolean resolve(Bindings bindings) {
        return this.ability.resolve(bindings);
    }

    public boolean equals(AbilityDbItem abilityDbItem) {
        return this.agent.equals(abilityDbItem.getAgent()) && this.ability.equals(abilityDbItem.getAbility());
    }

    public String toString() {
        return "(:agent " + this.agent + " " + ":ability " + this.ability.toString() + ")";
    }
}

