/*
 * Decompiled with CFR 0.152.
 */
package zeus.agentviewer.task;

import javax.swing.table.AbstractTableModel;
import zeus.concepts.Fact;

public class TaskConditionsTableModel
extends AbstractTableModel {
    static final int TYPE = 0;
    static final int INSTANCE = 1;
    static final int MODIFIERS = 2;
    protected static final String[] columnNames = new String[]{"Fact Type", "Instance", "Modifiers"};
    private Fact[] data = null;

    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public Object getValueAt(int n, int n2) {
        Fact fact = this.data[n];
        switch (n2) {
            case 0: {
                return fact.getType();
            }
            case 1: {
                return fact.getId();
            }
            case 2: {
                String string = "";
                int n3 = fact.getModifiers();
                if (Fact.isNegative(n3)) {
                    string = string + "NOT ";
                }
                if (Fact.isReadOnly(n3)) {
                    string = string + "READ_ONLY";
                }
                if (Fact.isLocal(n3)) {
                    string = string + "LOCAL";
                }
                if (Fact.isReplaced(n3)) {
                    string = string + "REPLACED";
                }
                if (Fact.isSideEffect(n3)) {
                    string = string + "SIDE_EFFECT";
                }
                return string;
            }
        }
        return null;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public void setFacts(Fact[] factArray) {
        this.data = factArray;
        this.fireTableDataChanged();
    }

    public Fact getFact(int n) {
        return this.data[n];
    }
}

