/*
 * Decompiled with CFR 0.152.
 */
package zeus.agentviewer.resources;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import zeus.agentviewer.InternalFramesPanel;
import zeus.agentviewer.ZeusInternalFrame;
import zeus.agentviewer.resources.FactAttributesTableModel;
import zeus.agentviewer.resources.ResourceTableModel;
import zeus.util.SystemProps;

public class ResourceTableUI
extends ZeusInternalFrame
implements ListSelectionListener,
ActionListener,
ChangeListener {
    String fsep = System.getProperty("file.separator");
    String IMAGEPATH = SystemProps.getProperty("gif.dir") + "agentviewer" + this.fsep;
    private JPanel contentPane;
    private JTable table;
    private JTextArea bottomPane;
    private JScrollPane topPane;
    final int IMGw = 20;
    final int IMGh = 20;
    final int TOP_PANE_MIN_HEIGHT = 120;
    final int TOP_PANE_MIN_WIDTH = 500;
    final int BOTTOM_PANE_MIN_WIDTH = 500;
    final int BOTTOM_PANE_MIN_HEIGHT = 100;
    private static int NUMBER_DISPLAYED = 0;
    private InternalFramesPanel deskTop;
    ResourceTableModel resourceBuffer;
    private FactAttributesTableModel attributesTableModel;
    JTable attributesTable;

    public ResourceTableUI(InternalFramesPanel internalFramesPanel, ResourceTableModel resourceTableModel) {
        super(" ", true, true, true, true);
        this.setTitle("Resource Database:" + ++NUMBER_DISPLAYED);
        ImageIcon imageIcon = new ImageIcon(this.IMAGEPATH + "resourcedb.gif");
        this.setFrameIcon(imageIcon);
        this.deskTop = internalFramesPanel;
        this.resourceBuffer = resourceTableModel;
        this.attributesTableModel = new FactAttributesTableModel(resourceTableModel);
        this.buildUI();
        internalFramesPanel.addInternalFrame(this);
        this.setVisible(true);
    }

    Icon getIcon(String string, int n, int n2) {
        String string2 = new String(this.IMAGEPATH + string);
        Image image = Toolkit.getDefaultToolkit().getImage(string2);
        image = image.getScaledInstance(n, n2, 4);
        ImageIcon imageIcon = new ImageIcon(image);
        return imageIcon;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.bottomPane.setText("  ");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        String string = actionEvent.getActionCommand();
        if (string.equals("delResBtn") && (n = this.table.getSelectedRow()) == -1) {
            JOptionPane.showMessageDialog(this, " Select resource", "Resource not selected", 0);
            return;
        }
    }

    JToolBar getToolBar() {
        JToolBar jToolBar = new JToolBar();
        JButton jButton = new JButton(this.getIcon("delete.gif", 20, 20));
        jButton.setToolTipText("Delete resource");
        jButton.addActionListener(this);
        jButton.setActionCommand("delResBtn");
        jToolBar.add(jButton);
        jToolBar.setFloatable(false);
        return jToolBar;
    }

    private TitledBorder makeBorder(String string) {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 12));
        titledBorder.setTitleColor(Color.black);
        return titledBorder;
    }

    private void buildUI() {
        this.table = new JTable(this.resourceBuffer);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 120));
        this.topPane = new JScrollPane(this.table);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getSelectionModel().setSelectionMode(0);
        this.bottomPane = new JTextArea();
        this.bottomPane.setEditable(false);
        this.bottomPane.setLineWrap(true);
        this.bottomPane.setWrapStyleWord(true);
        this.bottomPane.setPreferredSize(new Dimension(500, 100));
        JScrollPane jScrollPane = new JScrollPane(this.bottomPane);
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(Color.black, Color.gray));
        this.attributesTable = new JTable(this.attributesTableModel);
        this.attributesTable.setColumnSelectionAllowed(false);
        this.attributesTable = new JTable(this.attributesTableModel);
        this.attributesTable.setPreferredScrollableViewportSize(new Dimension(500, 100));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(this.makeBorder("Attributes"));
        jPanel.add("Center", new JScrollPane(this.attributesTable));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add("North", this.topPane);
        jPanel2.add("Center", jPanel);
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add("Center", jPanel2);
        this.pack();
    }

    void displayAttributes() {
        int n = this.table.getSelectedRow();
        if (n >= 0 && n < this.resourceBuffer.getRowCount()) {
            this.attributesTableModel.setFact(this.resourceBuffer.getAttributesOf(n));
            this.reSize();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n;
        if (listSelectionEvent.getSource() == this.table.getSelectionModel() && (n = this.table.getSelectedRow()) >= 0 && n < this.resourceBuffer.getRowCount()) {
            this.displayAttributes();
        }
    }

    void reSize() {
        this.setSize(this.getWidth() + 1, this.getHeight());
        this.setSize(this.getWidth() - 1, this.getHeight());
    }
}

