/*
 * Decompiled with CFR 0.152.
 */
package zeus.agentviewer.plansch;

import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.DefaultTableModel;
import zeus.actors.AgentContext;
import zeus.actors.ExecutionMonitor;
import zeus.actors.PlanRecord;
import zeus.actors.Planner;
import zeus.actors.event.ClockEvent;
import zeus.actors.event.ClockMonitor;
import zeus.actors.event.PlanStepEvent;
import zeus.actors.event.PlanStepMonitor;

public class PlanSchModel
extends DefaultTableModel
implements PlanStepMonitor,
ClockMonitor {
    static final int DEFAULT_SIZE = 10;
    private PlanRecord[][] data;
    private PlanRecord[][] newData = null;
    private int length;
    private int width;
    private int from;
    private int now;
    private ExecutionMonitor em;
    private Planner planner;
    protected EventListenerList changeListeners = new EventListenerList();
    private JTable table;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public PlanSchModel(AgentContext agentContext) {
        this.em = agentContext.ExecutionMonitor();
        this.planner = agentContext.Planner();
        this.length = this.planner.getPlannerLength();
        this.width = this.planner.getPlannerWidth();
        this.now = (int)agentContext.now();
        this.data = new PlanRecord[this.width][this.length];
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.length; ++j) {
                this.data[i][j] = null;
            }
        }
        this.planner.addPlanStepMonitor(this, 7L);
        this.em.addClockMonitor(this, 1L);
        this.from = this.now;
        this.fireTableStructureChanged();
    }

    public int getRowCount() {
        return this.width;
    }

    public int getColumnCount() {
        return 10;
    }

    public Object getValueAt(int n, int n2) {
        if (n > this.width) {
            return null;
        }
        if (n2 + this.from - this.now > this.length) {
            return null;
        }
        return this.data[n][n2 + this.from - this.now];
    }

    public String getColumnName(int n) {
        int n2 = n + this.from;
        return "+" + Integer.toString(n);
    }

    public synchronized void createPlanRecord(PlanRecord planRecord) {
        int n = planRecord.getStartTime() - this.now;
        int n2 = planRecord.getEndTime() - this.now;
        int n3 = planRecord.getProc();
        if (n < 0 || n2 < 0) {
            return;
        }
        for (int i = n; i < n2; ++i) {
            this.data[n3][i] = planRecord;
        }
        this.fireTableDataChanged();
    }

    public synchronized void stateChangedPlanRecord(PlanRecord planRecord) {
        int n;
        int n2 = planRecord.getStartTime() - this.now;
        int n3 = planRecord.getEndTime() - this.now;
        int n4 = planRecord.getProc();
        if (n2 < 0) {
            return;
        }
        for (n = 0; n < this.width; ++n) {
            for (int i = 0; i < this.length; ++i) {
                if (this.data[n][i] != planRecord) continue;
                this.data[n][i] = null;
            }
        }
        for (n = n2; n < n3; ++n) {
            this.data[n4][n] = planRecord;
        }
        this.fireTableDataChanged();
    }

    protected void setTable(JTable jTable) {
        this.table = jTable;
    }

    public synchronized void removePlanRecord(PlanRecord planRecord) {
        int n = planRecord.getProc();
        int n2 = planRecord.getStartTime() - this.now;
        int n3 = planRecord.getEndTime() - this.now;
        if (n2 < 0) {
            return;
        }
        for (int i = n2; i < n3; ++i) {
            this.data[n][i] = null;
        }
        this.fireTableDataChanged();
    }

    public synchronized void clockTicked(int n) {
        if (this.newData == null) {
            this.newData = new PlanRecord[this.width][this.length];
        }
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.length - 1; ++j) {
                this.newData[i][j] = this.data[i][j + 1];
            }
            this.newData[i][this.length - 1] = null;
        }
        this.data = this.newData;
        this.now = n;
        if (n > this.from) {
            this.from = n;
        }
        this.fireTableDataChanged();
    }

    public void setFrom(int n) {
        if (n < this.now) {
            this.reSetFrom();
        } else {
            this.from = n;
        }
        this.fireTableStructureChanged();
    }

    public int getFrom() {
        return this.from;
    }

    public void reSetFrom() {
        this.from = this.now;
        this.fireTableStructureChanged();
    }

    public Object[] getListeners() {
        Object[] objectArray = this.listenerList.getListenerList();
        return objectArray;
    }

    public void clockTickEvent(ClockEvent clockEvent) {
        this.clockTicked(clockEvent.getValue());
        this.fireChanged();
    }

    public void planStepCreatedEvent(PlanStepEvent planStepEvent) {
        this.createPlanRecord(planStepEvent.getPlanRecord());
        this.fireChanged();
    }

    public void planStepDisposedEvent(PlanStepEvent planStepEvent) {
        this.removePlanRecord(planStepEvent.getPlanRecord());
        this.fireChanged();
    }

    public void planStepStateChangedEvent(PlanStepEvent planStepEvent) {
        this.stateChangedPlanRecord(planStepEvent.getPlanRecord());
        this.fireChanged();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = PlanSchModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = PlanSchModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    protected void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.changeListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? PlanSchModel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ChangeListener changeListener = (ChangeListener)objectArray[i + 1];
            changeListener.stateChanged(changeEvent);
        }
    }

    public void removeZeusEventMonitors() {
        this.planner.removePlanStepMonitor(this, 7L);
        this.em.removeClockMonitor(this, 1L);
    }

    public int getProcessors() {
        return this.width;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

