/*
 * Decompiled with CFR 0.152.
 */
package zeus.agentviewer.msghandler;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import zeus.agentviewer.InternalFramesPanel;
import zeus.agentviewer.ZeusInternalFrame;
import zeus.agentviewer.msghandler.MsgHandlerTableModel;
import zeus.concepts.Performative;
import zeus.util.SystemProps;
import zeus.util.Time;

public class MsgHandlerTableUI
extends ZeusInternalFrame
implements ListSelectionListener {
    private JPanel contentPane;
    private JTable table;
    private JTextArea bottomPane;
    private JScrollPane topPane;
    private JSplitPane splitPane;
    final int TOP_PANE_MIN_HEIGHT = 120;
    final int TOP_PANE_MIN_WIDTH = 500;
    final int BOTTOM_PANE_MIN_WIDTH = 500;
    final int BOTTOM_PANE_MIN_HEIGHT = 100;
    private static int NUMBER_DISPLAYED = 0;
    private InternalFramesPanel deskTop;
    MsgHandlerTableModel msgHandlerBuffer;
    JTextArea replyWithTF;
    JTextArea inReplyToTF;
    JTextArea sendTimeTF;
    JTextArea ontologyTF;
    JTextArea languageTF;
    JTextArea contentTF;
    JTextArea receiveTimeTF;
    JTextArea numberSoFar;

    public MsgHandlerTableUI(InternalFramesPanel internalFramesPanel, MsgHandlerTableModel msgHandlerTableModel) {
        super(" ", true, true, true, true);
        this.setTitle("Message Handler:" + ++NUMBER_DISPLAYED);
        String string = System.getProperty("file.separator");
        String string2 = SystemProps.getProperty("gif.dir") + "agentviewer" + string;
        ImageIcon imageIcon = new ImageIcon(string2 + "handler.gif");
        this.setFrameIcon(imageIcon);
        this.deskTop = internalFramesPanel;
        this.msgHandlerBuffer = msgHandlerTableModel;
        this.buildUI();
        internalFramesPanel.addInternalFrame(this);
        this.setVisible(true);
    }

    private void buildUI() {
        this.table = new JTable(this.msgHandlerBuffer);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 120));
        this.topPane = new JScrollPane(this.table);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.setShowGrid(false);
        this.bottomPane = new JTextArea();
        this.bottomPane.setEditable(false);
        this.bottomPane.setLineWrap(true);
        this.bottomPane.setWrapStyleWord(true);
        this.bottomPane.setPreferredSize(new Dimension(500, 100));
        JScrollPane jScrollPane = new JScrollPane(this.getBottomPanel());
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(Color.black, Color.gray));
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        this.contentPane.add(this.topPane);
        this.contentPane.add(jScrollPane);
        this.pack();
    }

    private TitledBorder makeBorder(String string) {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 12));
        titledBorder.setTitleColor(Color.black);
        return titledBorder;
    }

    JPanel getBottomPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel("Reply With ");
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.replyWithTF = new JTextArea();
        this.replyWithTF.setEditable(false);
        this.replyWithTF.setLineWrap(true);
        this.replyWithTF.setWrapStyleWord(true);
        this.replyWithTF.setBorder(BorderFactory.createEtchedBorder(Color.lightGray, Color.gray));
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JScrollPane jScrollPane = new JScrollPane(this.replyWithTF);
        jScrollPane.setPreferredSize(new Dimension(10, 35));
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        jLabel = new JLabel("In Reply To ");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.inReplyToTF = new JTextArea();
        this.inReplyToTF.setEditable(false);
        this.inReplyToTF.setLineWrap(true);
        this.inReplyToTF.setWrapStyleWord(true);
        this.inReplyToTF.setBorder(BorderFactory.createEtchedBorder(Color.lightGray, Color.gray));
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jScrollPane = new JScrollPane(this.inReplyToTF);
        jScrollPane.setPreferredSize(new Dimension(10, 35));
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        jLabel = new JLabel("Content ");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.contentTF = new JTextArea();
        this.contentTF.setEditable(false);
        this.contentTF.setLineWrap(true);
        this.contentTF.setWrapStyleWord(true);
        this.contentTF.setBorder(BorderFactory.createEtchedBorder(Color.lightGray, Color.gray));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jScrollPane = new JScrollPane(this.contentTF);
        jScrollPane.setPreferredSize(new Dimension(10, 70));
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        jLabel = new JLabel("Sent ");
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.sendTimeTF = new JTextArea();
        this.sendTimeTF.setEditable(false);
        this.sendTimeTF.setLineWrap(true);
        this.sendTimeTF.setWrapStyleWord(true);
        this.sendTimeTF.setBorder(BorderFactory.createEtchedBorder(Color.lightGray, Color.gray));
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jScrollPane = new JScrollPane(this.sendTimeTF);
        jScrollPane.setPreferredSize(new Dimension(10, 35));
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        jLabel = new JLabel("Recieved ");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.receiveTimeTF = new JTextArea();
        this.receiveTimeTF.setEditable(false);
        this.receiveTimeTF.setLineWrap(true);
        this.receiveTimeTF.setWrapStyleWord(true);
        this.receiveTimeTF.setBorder(BorderFactory.createEtchedBorder(Color.lightGray, Color.gray));
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jScrollPane = new JScrollPane(this.receiveTimeTF);
        jScrollPane.setPreferredSize(new Dimension(10, 35));
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        jLabel = new JLabel("Ontology ");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.ontologyTF = new JTextArea();
        this.ontologyTF.setEditable(false);
        this.ontologyTF.setLineWrap(true);
        this.ontologyTF.setWrapStyleWord(true);
        this.ontologyTF.setBorder(BorderFactory.createEtchedBorder(Color.lightGray, Color.gray));
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jScrollPane = new JScrollPane(this.ontologyTF);
        jScrollPane.setPreferredSize(new Dimension(10, 35));
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jLabel = new JLabel("Language ");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.languageTF = new JTextArea();
        this.languageTF.setEditable(false);
        this.languageTF.setLineWrap(true);
        this.languageTF.setWrapStyleWord(true);
        this.languageTF.setBorder(BorderFactory.createEtchedBorder(Color.lightGray, Color.gray));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jScrollPane = new JScrollPane(this.languageTF);
        jScrollPane.setPreferredSize(new Dimension(10, 35));
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        return jPanel;
    }

    void setMailFields(int n) {
        Performative performative = this.msgHandlerBuffer.getMessage(n);
        this.replyWithTF.setText(performative.getReplyWith());
        this.inReplyToTF.setText(performative.getInReplyTo());
        this.contentTF.setText(performative.getContent());
        Time time = performative.getSendTime();
        if (time != null) {
            this.sendTimeTF.setText(((Object)time).toString());
        } else {
            this.sendTimeTF.setText(null);
        }
        time = performative.getReceiveTime();
        if (time != null) {
            this.receiveTimeTF.setText(((Object)time).toString());
        } else {
            this.receiveTimeTF.setText(null);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n;
        if (listSelectionEvent.getSource() == this.table.getSelectionModel() && (n = this.table.getSelectedRow()) >= 0 && n < this.msgHandlerBuffer.getRowCount()) {
            this.setMailFields(n);
            this.validate();
        }
    }

    void reSize() {
        this.setSize(this.getWidth() + 1, this.getHeight());
        this.setSize(this.getWidth() - 1, this.getHeight());
    }
}

