/*
 * Decompiled with CFR 0.152.
 */
package zeus.agentviewer.msghandler;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import zeus.actors.AgentContext;
import zeus.actors.event.MessageHandlerEvent;
import zeus.actors.event.MessageHandlerMonitor;
import zeus.concepts.Performative;

public class MsgHandlerTableModel
extends AbstractTableModel
implements MessageHandlerMonitor {
    static final int SENDER = 0;
    static final int TYPE = 1;
    static final int OBJECT = 2;
    static final int METHOD = 3;
    protected int messageCount = 0;
    private int BUFFER_CAPACITY = 50;
    private int REMOVE_INDEX = 0;
    private String[] header = new String[]{"Sender", "Type", "Object", "Method"};
    private Vector data;
    private AgentContext context;

    public MsgHandlerTableModel(AgentContext agentContext) {
        this.context = agentContext;
        this.data = new Vector();
        agentContext.MsgHandler().addMessageHandlerMonitor(this, 4L);
    }

    public int getNumberMessages() {
        return this.messageCount;
    }

    public int getRowCount() {
        return this.data.size();
    }

    public int getColumnCount() {
        return this.header.length;
    }

    public Object getValueAt(int n, int n2) {
        MessageHandlerEvent messageHandlerEvent = (MessageHandlerEvent)this.data.elementAt(n);
        switch (n2) {
            case 0: {
                return messageHandlerEvent.getSender();
            }
            case 1: {
                return messageHandlerEvent.getMessageType();
            }
            case 2: {
                return messageHandlerEvent.getDestination();
            }
            case 3: {
                return messageHandlerEvent.getMethod();
            }
        }
        return null;
    }

    Performative getMessage(int n) {
        return ((MessageHandlerEvent)this.data.elementAt(n)).getMessage();
    }

    public String getColumnName(int n) {
        return this.header[n];
    }

    public void messageRuleFailedEvent(MessageHandlerEvent messageHandlerEvent) {
    }

    public void messageRuleAddedEvent(MessageHandlerEvent messageHandlerEvent) {
    }

    public void messageRuleDeletedEvent(MessageHandlerEvent messageHandlerEvent) {
    }

    public void messageRuleFiredEvent(MessageHandlerEvent messageHandlerEvent) {
        if (this.data.contains(messageHandlerEvent)) {
            return;
        }
        if (this.data.size() > this.BUFFER_CAPACITY) {
            this.data.removeElementAt(this.REMOVE_INDEX);
        }
        this.data.addElement(messageHandlerEvent);
        ++this.messageCount;
        this.fireTableDataChanged();
    }

    public void removeZeusEventMonitors() {
        this.context.MsgHandler().removeMessageHandlerMonitor(this, 4L);
    }
}

