/*
 * Decompiled with CFR 0.152.
 */
package zeus.agentviewer.engine;

import zeus.actors.event.NodeEvent;
import zeus.actors.rtn.Node;
import zeus.gui.graph.GraphNode;
import zeus.util.OrderedHashtable;

public class GraphsModel {
    private OrderedHashtable data = new OrderedHashtable();

    public GraphNode addToGraph(NodeEvent nodeEvent) {
        Node node = nodeEvent.getNode();
        GraphNode graphNode = new GraphNode(node);
        String string = nodeEvent.getNodeName();
        String[] stringArray = nodeEvent.getParentNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.data.containsKey(stringArray[i])) continue;
            GraphNode graphNode2 = (GraphNode)this.data.get(stringArray[i]);
            graphNode2.addChild(graphNode);
            graphNode.addParent(graphNode2);
        }
        this.data.put(string, graphNode);
        return graphNode;
    }

    public GraphNode changeNode(NodeEvent nodeEvent) {
        GraphNode graphNode = null;
        if (this.data.containsKey(nodeEvent.getNodeName())) {
            graphNode = (GraphNode)this.data.get(nodeEvent.getNodeName());
            graphNode.setUserObject(nodeEvent.getNode());
        }
        return graphNode;
    }

    public void addRoot(String string, GraphNode graphNode) {
        this.data.put(string, graphNode);
    }

    public void removeAll() {
        this.data.clear();
    }

    public void removeNode(NodeEvent nodeEvent) {
        this.data.remove(nodeEvent.getNodeName());
    }

    public void removeNode(GraphNode graphNode) {
        Node node = (Node)graphNode.getUserObject();
        this.data.remove(node.getDescription());
    }

    public GraphNode getRoot(String string) {
        GraphNode graphNode = null;
        GraphNode graphNode2 = (GraphNode)this.data.get(string);
        GraphNode[] graphNodeArray = graphNode2.getParents();
        if (graphNodeArray.length == 0) {
            return graphNode2;
        }
        while (graphNodeArray.length != 0) {
            graphNode = graphNodeArray[0];
            graphNodeArray = graphNodeArray[0].getParents();
        }
        return graphNode;
    }
}

