/*
 * Decompiled with CFR 0.152.
 */
package zeus.agentviewer.engine;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import zeus.agentviewer.InternalFramesPanel;
import zeus.agentviewer.ZeusInternalFrame;
import zeus.agentviewer.engine.EngineGraphModel;
import zeus.agentviewer.engine.EngineNodeRenderer;
import zeus.agentviewer.engine.EngineTableModel;
import zeus.agentviewer.engine.TreeNodeRenderer;
import zeus.gui.graph.Graph;
import zeus.gui.help.HelpWindow;
import zeus.util.SystemProps;

public class EngineUI
extends ZeusInternalFrame
implements ListSelectionListener {
    private JPanel contentPane;
    private JTable table;
    private JScrollPane tablePanel;
    final int TOP_PANE_MIN_HEIGHT = 120;
    final int TOP_PANE_MIN_WIDTH = 500;
    final int BOTTOM_PANE_MIN_WIDTH = 50;
    final int BOTTOM_PANE_MIN_HEIGHT = 50;
    private static int NUMBER_DISPLAYED = 0;
    private InternalFramesPanel deskTop;
    EngineTableModel engineBuffer;
    private JScrollPane treeSP;
    Graph graph = null;

    public EngineUI(InternalFramesPanel internalFramesPanel, EngineTableModel engineTableModel) {
        super("Coordination Engine", true, true, true, true);
        this.setTitle("Coordination Engine:" + ++NUMBER_DISPLAYED);
        String string = System.getProperty("file.separator");
        String string2 = SystemProps.getProperty("gif.dir") + "agentviewer" + string;
        ImageIcon imageIcon = new ImageIcon(string2 + "engine.gif");
        this.setFrameIcon(imageIcon);
        this.deskTop = internalFramesPanel;
        this.engineBuffer = engineTableModel;
        this.buildUI();
        internalFramesPanel.addInternalFrame(this);
        this.setVisible(true);
    }

    private JPanel getColorPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 3, 5, 2));
        for (int i = 0; i < EngineNodeRenderer.state_string.length; ++i) {
            KeyLabel keyLabel = new KeyLabel(EngineNodeRenderer.state_string[i], EngineNodeRenderer.color[i]);
            jPanel.add(keyLabel);
        }
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        JLabel jLabel = new JLabel("Key", 2);
        jLabel.setFont(new Font("Courier", 1, 14));
        jLabel.setForeground(Color.black);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        jPanel2.add(jPanel);
        return jPanel2;
    }

    private void buildUI() {
        this.table = new JTable(this.engineBuffer);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 120));
        this.tablePanel = new JScrollPane(this.table);
        this.tablePanel.setPreferredSize(new Dimension(500, 120));
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.setShowGrid(false);
        this.treeSP = new JScrollPane(this.graph);
        this.treeSP.setBackground(Color.white);
        this.treeSP.setPreferredSize(new Dimension(50, 50));
        this.treeSP.setBorder(new BevelBorder(1));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("North", new NodesToolBar());
        jPanel.add("Center", this.treeSP);
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add("North", this.tablePanel);
        this.contentPane.add("Center", jPanel);
        this.contentPane.add("South", this.getColorPanel());
        this.pack();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n;
        if (listSelectionEvent.getSource() == this.table.getSelectionModel() && (n = this.table.getSelectedRow()) >= 0 && n < this.engineBuffer.getRowCount()) {
            if (this.treeSP.getViewport().getComponentCount() > 0) {
                this.treeSP.getViewport().removeAll();
            }
            EngineGraphModel engineGraphModel = this.engineBuffer.getGraph(n);
            this.graph = new Graph(2, engineGraphModel, false, false);
            this.graph.setNodeRenderer(new TreeNodeRenderer());
            this.graph.setBackground(Color.white);
            this.graph.setPreferredSize(new Dimension(2000, 2000));
            this.treeSP.getViewport().add(this.graph);
            this.treeSP.validate();
        }
    }

    void reSize() {
        this.setSize(this.getWidth() - 2, this.getHeight());
        this.setSize(this.getWidth() + 2, this.getHeight());
    }

    protected class NodesToolBar
    extends JToolBar
    implements ActionListener {
        protected HelpWindow helpWin;
        protected JToggleButton helpBtn;
        protected JButton newBtn;
        protected JButton selectBtn;
        protected JButton selectAllBtn;
        protected JButton hideBtn;
        protected JButton showBtn;
        protected JButton collapseBtn;
        protected JButton expandBtn;
        protected JButton deleteBtn;
        protected JButton cutBtn;
        protected JButton copyBtn;
        protected JButton pasteBtn;
        protected JButton recomputeBtn;
        protected JButton redrawBtn;

        public NodesToolBar() {
            this.setBackground(Color.lightGray);
            this.setBorder(new BevelBorder(1));
            this.setFloatable(false);
            String string = System.getProperty("file.separator");
            String string2 = SystemProps.getProperty("gif.dir") + "generator" + string;
            this.recomputeBtn = new JButton(new ImageIcon(string2 + "recompute.gif"));
            this.recomputeBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.recomputeBtn);
            this.recomputeBtn.setToolTipText("Recompute node positions");
            this.recomputeBtn.addActionListener(this);
            this.redrawBtn = new JButton(new ImageIcon(string2 + "redraw.gif"));
            this.redrawBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.redrawBtn);
            this.redrawBtn.setToolTipText("Redraw");
            this.redrawBtn.addActionListener(this);
            this.addSeparator();
            this.selectBtn = new JButton(new ImageIcon(string2 + "select.gif"));
            this.selectBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.selectBtn);
            this.selectBtn.setToolTipText("Select nodes");
            this.selectBtn.addActionListener(this);
            this.selectAllBtn = new JButton(new ImageIcon(string2 + "selectAll.gif"));
            this.selectAllBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.selectAllBtn);
            this.selectAllBtn.setToolTipText("Select all nodes");
            this.selectAllBtn.addActionListener(this);
            this.addSeparator();
            this.collapseBtn = new JButton(new ImageIcon(string2 + "collapse.gif"));
            this.collapseBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.collapseBtn);
            this.collapseBtn.setToolTipText("Collapse nodes");
            this.collapseBtn.addActionListener(this);
            this.expandBtn = new JButton(new ImageIcon(string2 + "expand.gif"));
            this.expandBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.expandBtn);
            this.expandBtn.setToolTipText("Expand nodes");
            this.expandBtn.addActionListener(this);
            this.addSeparator();
            this.hideBtn = new JButton(new ImageIcon(string2 + "hide.gif"));
            this.hideBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.hideBtn);
            this.hideBtn.setToolTipText("Hide nodes");
            this.hideBtn.addActionListener(this);
            this.showBtn = new JButton(new ImageIcon(string2 + "show.gif"));
            this.showBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.showBtn);
            this.showBtn.setToolTipText("Show nodes");
            this.showBtn.addActionListener(this);
            this.addSeparator();
            this.helpBtn = new JToggleButton(new ImageIcon(string2 + "help.gif"));
            this.helpBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.helpBtn);
            this.helpBtn.setToolTipText("Help");
            this.helpBtn.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (EngineUI.this.graph == null) {
                return;
            }
            if (object == this.recomputeBtn) {
                EngineUI.this.graph.recompute();
            } else if (object == this.redrawBtn) {
                EngineUI.this.graph.redraw();
            } else if (object == this.selectBtn) {
                EngineUI.this.graph.select();
            } else if (object == this.selectAllBtn) {
                EngineUI.this.graph.selectAll();
            } else if (object == this.collapseBtn) {
                EngineUI.this.graph.collapse();
            } else if (object == this.expandBtn) {
                EngineUI.this.graph.expand();
            } else if (object == this.hideBtn) {
                EngineUI.this.graph.hide();
            } else if (object == this.showBtn) {
                EngineUI.this.graph.show();
            } else if (object == this.helpBtn) {
                if (this.helpBtn.isSelected()) {
                    this.helpWin = new HelpWindow(SwingUtilities.getRoot(this), this.getLocation(), "generator", "Coordination Engine");
                    this.helpWin.setSource(this.helpBtn);
                } else {
                    this.helpWin.dispose();
                }
            }
        }
    }

    class KeyLabel
    extends JPanel {
        public KeyLabel(String string, Color color) {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            JPanel jPanel = new JPanel();
            jPanel.setPreferredSize(new Dimension(10, 10));
            jPanel.setBackground(color);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.add(jPanel);
            JLabel jLabel = new JLabel(string);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
        }
    }
}

