/*
 * Decompiled with CFR 0.152.
 */
package zeus.agentviewer.engine;

import java.util.Enumeration;
import java.util.Hashtable;
import zeus.actors.rtn.Node;
import zeus.agentviewer.engine.GraphsModel;
import zeus.gui.graph.AbstractGraphModel;
import zeus.gui.graph.GraphNode;

public class EngineGraphModel
extends AbstractGraphModel {
    static final int ADD = 0;
    static final int DELETE = 1;
    static final int CHANGE = 2;
    private int BUFFER_CAPACITY = 50;
    private int REMOVE_INDEX = 0;
    GraphNode root;
    Hashtable allNodes = new Hashtable();

    public EngineGraphModel(GraphNode graphNode) {
        this.root = graphNode;
    }

    public Enumeration nodes() {
        this.addNode(this.root);
        this.getAllNodesOf(this.root);
        return this.allNodes.elements();
    }

    public boolean isLinkVisible(GraphNode graphNode, GraphNode graphNode2) {
        return graphNode2.hasParent(graphNode);
    }

    public void setValue(GraphNode graphNode, Object object) {
    }

    public boolean isNodeEditable(GraphNode graphNode) {
        return false;
    }

    private void getAllNodesOf(GraphNode graphNode) {
        GraphNode[] graphNodeArray = graphNode.getChildren();
        for (int i = 0; i < graphNodeArray.length; ++i) {
            this.addNode(graphNodeArray[i]);
            this.getAllNodesOf(graphNodeArray[i]);
        }
    }

    public GraphNode getRoot() {
        return this.root;
    }

    private void addNode(GraphNode graphNode) {
        Node node = (Node)graphNode.getUserObject();
        this.allNodes.put(node.getDescription(), graphNode);
    }

    public void refresh(int n, GraphNode graphNode) {
        if (n == 2) {
            this.fireGraphNodeStateChanged(graphNode);
        } else {
            this.fireGraphStructureChanged();
        }
    }

    void deleteTree(GraphsModel graphsModel) {
        this.deleteTreeNode(this.root, graphsModel);
    }

    protected void deleteTreeNode(GraphNode graphNode, GraphsModel graphsModel) {
        GraphNode[] graphNodeArray = graphNode.getChildren();
        for (int i = 0; i < graphNodeArray.length; ++i) {
            this.deleteTreeNode(graphNodeArray[i], graphsModel);
        }
        graphsModel.removeNode(graphNode);
    }
}

