/*
 * Decompiled with CFR 0.152.
 */
package zeus.agentviewer.acquaintances;

import javax.swing.table.AbstractTableModel;
import zeus.actors.AgentContext;
import zeus.actors.OrganisationDb;
import zeus.actors.event.RelationEvent;
import zeus.actors.event.RelationMonitor;
import zeus.util.OrderedHashtable;

public class RelationsTableModel
extends AbstractTableModel
implements RelationMonitor {
    private String AGENT = "Agent";
    private String RELATION = "Relation";
    private String[] header = new String[]{this.AGENT, this.RELATION};
    private OrderedHashtable data = new OrderedHashtable();
    private OrganisationDb organisationDb;

    public RelationsTableModel(AgentContext agentContext) {
        this.organisationDb = agentContext.OrganisationDb();
        this.organisationDb.addRelationMonitor(this, 7L, true);
    }

    public int getRowCount() {
        return this.data.size();
    }

    public int getColumnCount() {
        return this.header.length;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void setValueAt(Object object, int n, int n2) {
    }

    public Object getValueAt(int n, int n2) {
        String string = (String)this.data.getKeyAt(n);
        if (this.getColumnName(n2).equals(this.AGENT)) {
            return string;
        }
        if (this.getColumnName(n2).equals(this.RELATION)) {
            return (String)this.data.get(string);
        }
        return new String("Error in AgentRelationTableModel at getValueAt");
    }

    public String getColumnName(int n) {
        return this.header[n];
    }

    public void AddRelation(String string, String string2) {
        this.data.put(string, string2);
        this.fireTableDataChanged();
    }

    public void ModifyRelation(String string, String string2) {
        this.data.put(string, string2);
        this.fireTableDataChanged();
    }

    public void removeRelation(String string) {
        this.data.remove(string);
        this.fireTableDataChanged();
    }

    public String getName(int n) {
        return (String)this.data.getKeyAt(n);
    }

    public void relationAddedEvent(RelationEvent relationEvent) {
        this.AddRelation(relationEvent.getAgent(), relationEvent.getRelation());
    }

    public void relationModifiedEvent(RelationEvent relationEvent) {
        this.ModifyRelation(relationEvent.getAgent(), relationEvent.getRelation());
    }

    public void relationDeletedEvent(RelationEvent relationEvent) {
        this.removeRelation(relationEvent.getAgent());
    }

    public void relationAccessedEvent(RelationEvent relationEvent) {
    }

    public void removeZeusEventMonitors() {
        this.organisationDb.removeRelationMonitor(this, 7L);
    }
}

