/*
 * Decompiled with CFR 0.152.
 */
package zeus.agentviewer.acquaintances;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import zeus.agentviewer.InternalFramesPanel;
import zeus.agentviewer.ZeusInternalFrame;
import zeus.agentviewer.acquaintances.AbilitiesTableModel;
import zeus.agentviewer.acquaintances.AttributesTableModel;
import zeus.agentviewer.acquaintances.RelationsTableModel;
import zeus.util.SystemProps;

public class AcquaintanceUI
extends ZeusInternalFrame
implements ListSelectionListener {
    String fsep = System.getProperty("file.separator");
    String IMAGEPATH = SystemProps.getProperty("gif.dir") + "agentviewer" + this.fsep;
    private JPanel contentPane;
    private JTable relationsTable;
    private JTable abilitiesTable;
    private JTable attributesTable;
    private AbilitiesTableModel abilitiesTableModel;
    private RelationsTableModel relationsTableModel;
    private AttributesTableModel attributesTableModel;
    private JScrollPane relationsSP;
    private JScrollPane abilitiesSP;
    private JScrollPane attributesSP;
    final int IMGw = 20;
    final int IMGh = 20;
    final int TABLE_HEIGHT = 10;
    final int TABLE_WIDTH = 200;
    final int FIRST_ROW = 0;
    private static int NUMBER_DISPLAYED = 0;
    private InternalFramesPanel deskTop;
    private TitledBorder border;

    public AcquaintanceUI(InternalFramesPanel internalFramesPanel, RelationsTableModel relationsTableModel, AbilitiesTableModel abilitiesTableModel, AttributesTableModel attributesTableModel) {
        super(" ", true, true, true, true);
        this.setTitle("Aquaintance Database: " + ++NUMBER_DISPLAYED);
        ImageIcon imageIcon = new ImageIcon(this.IMAGEPATH + "acquaintdb.gif");
        this.setFrameIcon(imageIcon);
        this.deskTop = internalFramesPanel;
        this.relationsTableModel = relationsTableModel;
        this.abilitiesTableModel = abilitiesTableModel;
        this.attributesTableModel = attributesTableModel;
        this.buildUI();
        internalFramesPanel.addInternalFrame(this);
        this.setVisible(true);
    }

    private TitledBorder makeBorder(String string) {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 12));
        titledBorder.setTitleColor(Color.blue);
        return titledBorder;
    }

    Icon getIcon(String string, int n, int n2) {
        String string2 = new String(this.IMAGEPATH + string);
        Image image = Toolkit.getDefaultToolkit().getImage(string2);
        image = image.getScaledInstance(n, n2, 4);
        ImageIcon imageIcon = new ImageIcon(image);
        return imageIcon;
    }

    private void buildUI() {
        this.relationsTable = new JTable(this.relationsTableModel);
        this.relationsTable.setColumnSelectionAllowed(false);
        this.relationsTable.setPreferredScrollableViewportSize(new Dimension(200, 10));
        this.relationsSP = new JScrollPane(this.relationsTable);
        this.relationsTable.setBackground(Color.white);
        this.relationsTable.getSelectionModel().addListSelectionListener(this);
        this.relationsTable.getSelectionModel().setSelectionMode(0);
        this.abilitiesTable = new JTable(this.abilitiesTableModel);
        this.abilitiesTable.setColumnSelectionAllowed(false);
        this.abilitiesTable.setPreferredScrollableViewportSize(new Dimension(200, 20));
        this.abilitiesSP = new JScrollPane(this.abilitiesTable);
        this.abilitiesTable.setBackground(Color.white);
        this.abilitiesTable.getSelectionModel().addListSelectionListener(this);
        this.abilitiesTable.getSelectionModel().setSelectionMode(0);
        this.attributesTable = new JTable(this.attributesTableModel);
        this.attributesTable.setColumnSelectionAllowed(false);
        this.attributesTable = new JTable(this.attributesTableModel);
        this.attributesTable.setPreferredScrollableViewportSize(new Dimension(200, 30));
        this.attributesSP = new JScrollPane(this.attributesTable);
        this.attributesTable.setBackground(Color.white);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 1, 10, 15));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(this.makeBorder("Known Relations"));
        jPanel2.add("Center", this.relationsSP);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(this.makeBorder("Agent's Abilities"));
        jPanel3.add("Center", this.abilitiesSP);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(this.makeBorder("Fact Attributes"));
        jPanel4.add("Center", this.attributesSP);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add("Center", jPanel);
        this.pack();
    }

    void displayAbilities() {
        int n = this.relationsTable.getSelectedRow();
        if (n >= 0 && n < this.relationsTableModel.getRowCount()) {
            String string = this.relationsTableModel.getName(n);
            if (!this.abilitiesTableModel.hasAbilities(string)) {
                this.attributesTableModel.setFact(null);
                return;
            }
            this.abilitiesTableModel.setAbilitiesof(string);
            this.attributesTableModel.setFact(this.abilitiesTableModel.getAttributesof(0));
            this.reSize();
        }
    }

    void displayAttributes() {
        int n = this.abilitiesTable.getSelectedRow();
        if (n >= 0 && n < this.abilitiesTableModel.getRowCount()) {
            this.attributesTableModel.setFact(this.abilitiesTableModel.getAttributesof(n));
            this.reSize();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.relationsTable.getSelectionModel()) {
            this.displayAbilities();
        } else if (listSelectionEvent.getSource() == this.abilitiesTable.getSelectionModel()) {
            this.displayAttributes();
        }
    }

    void reSize() {
        this.setSize(this.getWidth() + 1, this.getHeight());
        this.setSize(this.getWidth() - 1, this.getHeight());
    }
}

