/*
 * Decompiled with CFR 0.152.
 */
package zeus.agentviewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import zeus.actors.AgentContext;
import zeus.agentviewer.AgentViewer;
import zeus.gui.fields.RealNumberField;
import zeus.util.SystemProps;

class ControlOptionsDialog
extends JDialog
implements ActionListener {
    AgentContext context;
    JPanel contentPane;
    RealNumberField registration_timeout;
    RealNumberField facilitator_timeout;
    RealNumberField address_timeout;
    RealNumberField accept_timeout;
    RealNumberField addressbook_refresh;
    RealNumberField facilitator_refresh;
    RealNumberField replan_period;
    JPanel centerPanel;
    JPanel leftPanel;
    JPanel rightPanel;
    JCheckBox share_plan;
    JCheckBox execute_earliest;
    JLabel label;
    JButton okBtn;
    JButton applyBtn;
    JButton cancelBtn;

    public ControlOptionsDialog(AgentViewer agentViewer, AgentContext agentContext) {
        super((Frame)agentViewer, "Set Agent's Context");
        this.context = agentContext;
        this.leftPanel = new JPanel(new GridLayout(9, 2));
        this.leftPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.leftPanel.add(new JLabel("Share plan "));
        this.share_plan = new JCheckBox();
        this.share_plan.setSelected(SystemProps.getState("share.plan"));
        this.leftPanel.add(this.share_plan);
        this.leftPanel.add(new JLabel("Execute earliest"));
        this.execute_earliest = new JCheckBox();
        this.execute_earliest.setSelected(SystemProps.getState("execute.earliest"));
        this.leftPanel.add(this.execute_earliest);
        this.leftPanel.add(new JLabel("Registration timeout"));
        this.registration_timeout = new RealNumberField(0.0, 10.0);
        this.registration_timeout.setValue(agentContext.getRegistrationTimeout());
        this.leftPanel.add(this.registration_timeout);
        this.leftPanel.add(new JLabel("Broker timeout"));
        this.facilitator_timeout = new RealNumberField(0.0, 10.0);
        this.facilitator_timeout.setValue(agentContext.getFacilitatorTimeout());
        this.leftPanel.add(this.facilitator_timeout);
        this.leftPanel.add(new JLabel("Address timeout"));
        this.address_timeout = new RealNumberField(0.0, 10.0);
        this.address_timeout.setValue(agentContext.getAddressTimeout());
        this.leftPanel.add(this.address_timeout);
        this.leftPanel.add(new JLabel("Accept timeout"));
        this.accept_timeout = new RealNumberField(0.0, 10.0);
        this.accept_timeout.setValue(agentContext.getAcceptTimeout());
        this.leftPanel.add(this.accept_timeout);
        this.leftPanel.add(new JLabel("Addressbook refresh "));
        this.addressbook_refresh = new RealNumberField(0.0, 10.0);
        this.addressbook_refresh.setValue(agentContext.getAddressBookRefresh());
        this.leftPanel.add(this.addressbook_refresh);
        this.leftPanel.add(new JLabel("Broker refresh"));
        this.facilitator_refresh = new RealNumberField(0.0, 10.0);
        this.facilitator_refresh.setValue(agentContext.getFacilitatorRefresh());
        this.leftPanel.add(this.facilitator_refresh);
        this.leftPanel.add(new JLabel("Replan period"));
        this.replan_period = new RealNumberField(0.0, 10.0);
        this.replan_period.setValue(agentContext.getReplanPeriod());
        this.leftPanel.add(this.replan_period);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel.add("North", new JSeparator(0));
        jPanel.add("Center", jPanel2);
        this.okBtn = new JButton("OK");
        this.okBtn.addActionListener(this);
        this.okBtn.setForeground(Color.black);
        this.okBtn.setFont(new Font("Helvetica", 1, 14));
        jPanel2.add(this.okBtn);
        jPanel2.add(Box.createRigidArea(new Dimension(20, 10)));
        this.applyBtn = new JButton("Apply");
        this.applyBtn.addActionListener(this);
        this.applyBtn.setForeground(Color.black);
        this.applyBtn.setFont(new Font("Helvetica", 1, 14));
        jPanel2.add(this.applyBtn);
        jPanel2.add(Box.createRigidArea(new Dimension(20, 10)));
        this.cancelBtn = new JButton("Cancel");
        this.cancelBtn.setForeground(Color.black);
        this.cancelBtn.setFont(new Font("Helvetica", 1, 14));
        this.cancelBtn.addActionListener(this);
        jPanel2.add(this.cancelBtn);
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add("Center", this.leftPanel);
        this.contentPane.add("South", jPanel);
        this.pack();
        this.setVisible(true);
        this.setModal(true);
    }

    void applySettings() {
        this.context.setSharePlan(this.share_plan.isSelected());
        this.context.setExecuteEarliest(this.execute_earliest.isSelected());
        Double d = this.registration_timeout.getValue(this.context.getRegistrationTimeout());
        this.context.setRegistrationTimeout(d);
        d = this.facilitator_timeout.getValue(this.context.getFacilitatorTimeout());
        this.context.setFacilitatorTimeout(d);
        d = this.address_timeout.getValue(this.context.getAddressTimeout());
        this.context.setAddressTimeout(d);
        d = this.accept_timeout.getValue(this.context.getAcceptTimeout());
        this.context.setAcceptTimeout(d);
        d = this.addressbook_refresh.getValue(this.context.getAddressBookRefresh());
        this.context.setAddressBookRefresh(d);
        d = this.facilitator_refresh.getValue(this.context.getFacilitatorRefresh());
        this.context.setFacilitatorRefresh(d);
        d = this.replan_period.getValue(this.context.getReplanPeriod());
        this.context.setReplanPeriod(d);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.applyBtn) {
            this.applySettings();
            return;
        }
        if (object == this.okBtn) {
            this.applySettings();
            this.dispose();
        } else if (object == this.cancelBtn) {
            this.dispose();
        }
    }
}

