/*
 * Decompiled with CFR 0.152.
 */
package zeus.agentviewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import zeus.actors.AgentContext;
import zeus.actors.MailBox;
import zeus.agents.ZeusAgentUI;
import zeus.agentviewer.AgentButton;
import zeus.agentviewer.ControlOptionsDialog;
import zeus.agentviewer.GoalDialog;
import zeus.agentviewer.InternalFramesPanel;
import zeus.agentviewer.acquaintances.AbilitiesTableModel;
import zeus.agentviewer.acquaintances.AcquaintanceUI;
import zeus.agentviewer.acquaintances.AttributesTableModel;
import zeus.agentviewer.acquaintances.RelationsTableModel;
import zeus.agentviewer.engine.EngineTableModel;
import zeus.agentviewer.engine.EngineUI;
import zeus.agentviewer.mail.MailInTableModel;
import zeus.agentviewer.mail.MailInTableUI;
import zeus.agentviewer.mail.MailOutTableModel;
import zeus.agentviewer.mail.MailOutTableUI;
import zeus.agentviewer.msghandler.MsgHandlerTableModel;
import zeus.agentviewer.msghandler.MsgHandlerTableUI;
import zeus.agentviewer.plansch.PlanSchModel;
import zeus.agentviewer.plansch.PlanSchTableUI;
import zeus.agentviewer.protocol.AttributesModel;
import zeus.agentviewer.protocol.ProtocolModel;
import zeus.agentviewer.protocol.ProtocolUI;
import zeus.agentviewer.protocol.StrategyModel;
import zeus.agentviewer.resources.ResourceTableModel;
import zeus.agentviewer.resources.ResourceTableUI;
import zeus.agentviewer.rete.ReteEngineDataModel;
import zeus.agentviewer.rete.ReteEngineUI;
import zeus.agentviewer.task.ConditionsAttributeTableModel;
import zeus.agentviewer.task.ConstraintsModel;
import zeus.agentviewer.task.OrderingModel;
import zeus.agentviewer.task.TaskConditionsTableModel;
import zeus.agentviewer.task.TaskTableModel;
import zeus.agentviewer.task.TaskTableUI;
import zeus.gui.help.HelpWindow;
import zeus.ontology.OntologyEditor;
import zeus.util.Assert;
import zeus.util.SystemProps;

public class AgentViewer
extends JFrame
implements ActionListener,
ComponentListener,
ZeusAgentUI {
    JPanel contentPane;
    public JPanel topPanel;
    InternalFramesPanel bottomPanel;
    String fsep = System.getProperty("file.separator");
    String IMAGEPATH = SystemProps.getProperty("gif.dir") + "agentviewer" + this.fsep;
    final int ICONh = 40;
    final int ICONw = 40;
    final int HEADERw = 200;
    final int HEADERh = 43;
    final int WIDTH = 600;
    final int HEIGHT = 400;
    int startWidth = 600;
    int startHeight = 300;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenu goalMenu;
    private JMenu viewMenu;
    private JMenu dbMenu;
    private JMenuItem goal;
    private JMenuItem options;
    private JMenuItem exit;
    private JMenuItem about;
    private JMenuItem aboutZeus;
    private JMenuItem tile;
    private JMenuItem cascade;
    private JMenuItem newTask;
    private JMenuItem newResource;
    private JMenuItem newAcquaintance;
    private JMenuItem nativeLF;
    private JMenuItem metalLF;
    private JToolBar toolBar;
    protected AgentButton mailInBtn;
    protected AgentButton mailOutBtn;
    protected AgentButton msgHandlerBtn;
    protected AgentButton reteEngineBtn;
    protected AgentButton coordEngineBtn;
    protected AgentButton acqDbBtn;
    protected AgentButton planSchBtn;
    protected AgentButton taskPlanDbBtn;
    protected AgentButton resDbBtn;
    protected AgentButton ontDbBtn;
    protected AgentButton protocolBtn;
    AgentContext context = null;
    Thread agentViewerThread;
    MailInTableModel mailInBuffer;
    MailOutTableModel mailOutBuffer;
    MsgHandlerTableModel msgHandlerBuffer;
    ResourceTableModel resourceBuffer;
    RelationsTableModel relationsBuffer;
    AbilitiesTableModel abilitiesBuffer;
    AttributesTableModel attributesBuffer;
    TaskTableModel taskBuffer;
    TaskConditionsTableModel preCondBuffer;
    ConditionsAttributeTableModel preAttrBuffer;
    TaskConditionsTableModel effectBuffer;
    ConditionsAttributeTableModel effectsAttrBuffer;
    ConstraintsModel constraintsBuffer;
    OrderingModel orderingBuffer;
    PlanSchModel planSchBuffer;
    EngineTableModel engineBuffer;
    ReteEngineDataModel reteEngineBuffer;
    ProtocolModel protocolBuffer;
    StrategyModel strategyBuffer;
    AttributesModel pAttributesBuffer;

    public AgentViewer() {
        super("Agent Viewer");
        this.getMetalUI();
        ImageIcon imageIcon = new ImageIcon(this.IMAGEPATH + "viewer.gif");
        this.setIconImage(imageIcon.getImage());
        this.createMenus();
        this.setJMenuBar(this.menuBar);
        this.setContentPane();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AgentViewer.this.exitBtnFn();
                System.exit(0);
            }
        });
        this.addComponentListener(this);
        this.setSize(new Dimension(this.startWidth, this.startHeight));
        this.setVisible(true);
    }

    void setMailInBox() {
        this.mailInBuffer = new MailInTableModel(this.context);
    }

    void setMailOutBox() {
        this.mailOutBuffer = new MailOutTableModel(this.context);
    }

    void setMsgHandlerBox() {
        this.msgHandlerBuffer = new MsgHandlerTableModel(this.context);
    }

    void setResourceBuffer() {
        this.resourceBuffer = new ResourceTableModel(this.context);
    }

    void setAcquaintanceBuffers() {
        this.relationsBuffer = new RelationsTableModel(this.context);
        this.abilitiesBuffer = new AbilitiesTableModel(this.context);
        this.attributesBuffer = new AttributesTableModel(this.abilitiesBuffer);
    }

    void setTaskBuffers() {
        this.taskBuffer = new TaskTableModel(this.context);
        this.preCondBuffer = new TaskConditionsTableModel();
        this.preAttrBuffer = new ConditionsAttributeTableModel();
        this.effectBuffer = new TaskConditionsTableModel();
        this.effectsAttrBuffer = new ConditionsAttributeTableModel();
        this.constraintsBuffer = new ConstraintsModel();
        this.orderingBuffer = new OrderingModel();
    }

    void setPlanSchBuffer() {
        this.planSchBuffer = new PlanSchModel(this.context);
    }

    void setEngineBuffer() {
        this.engineBuffer = new EngineTableModel(this.context);
    }

    void setReteEngineBuffer() {
        this.reteEngineBuffer = new ReteEngineDataModel(this.context);
    }

    void setProtocolBuffers() {
        this.protocolBuffer = new ProtocolModel(this.context);
        this.strategyBuffer = new StrategyModel();
        this.pAttributesBuffer = new AttributesModel();
    }

    public void showMsg(String string) {
    }

    public void set(AgentContext agentContext) {
        Assert.notNull(agentContext);
        this.context = agentContext;
        this.setVisible(true);
        this.setTitle(agentContext.whoami());
        this.setMailInBox();
        this.setMailOutBox();
        this.setMsgHandlerBox();
        this.setResourceBuffer();
        this.setAcquaintanceBuffers();
        this.setEngineBuffer();
        this.setProtocolBuffers();
        if (agentContext.Planner() == null) {
            this.planSchBtn.setEnabled(false);
            this.taskPlanDbBtn.setEnabled(false);
        } else {
            this.setTaskBuffers();
            this.setPlanSchBuffer();
        }
        if (agentContext.ReteEngine() == null) {
            this.reteEngineBtn.setEnabled(false);
        } else {
            this.setReteEngineBuffer();
        }
    }

    private void getNativeUI() {
        String string = System.getProperty("path.separator");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception exception) {
            System.out.println("Error getting UI");
        }
    }

    private void getMetalUI() {
        try {
            System.out.println("Metal look & feel chosen");
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception exception) {
            System.out.println("Error getting UI");
        }
    }

    public void showHelp() {
        Point point = this.getLocation();
        HelpWindow helpWindow = new HelpWindow(this, point, "visualiser", "Agent Viewer");
        helpWindow.setSize(new Dimension(600, this.getHeight()));
        helpWindow.setLocation(point.x + 24, point.y + 24);
        helpWindow.validate();
        helpWindow.setSource(this.about);
    }

    public void About() {
        Point point = this.getLocation();
        HelpWindow helpWindow = new HelpWindow(this, point, "visualiser", "About");
        helpWindow.setSize(new Dimension(440, 440));
        helpWindow.setLocation(point.x + 24, point.y + 24);
        helpWindow.setTitle("About ZEUS ...");
        helpWindow.validate();
        helpWindow.setSource(this.aboutZeus);
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.bottomPanel.tileOn()) {
            this.bottomPanel.tile();
        } else {
            this.bottomPanel.cascade();
        }
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    private void setContentPane() {
        this.bottomPanel = new InternalFramesPanel(this);
        this.toolBar = new JToolBar(0);
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        jPanel.add(this.toolBar);
        this.addButtonsToToolBar();
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add("North", this.toolBar);
        this.contentPane.add("Center", this.bottomPanel);
    }

    private void createMenus() {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.options = new JMenuItem("Control Options");
        this.options.addActionListener(this);
        this.fileMenu.add(this.options);
        this.exit = new JMenuItem("Exit");
        this.exit.addActionListener(this);
        this.fileMenu.add(this.exit);
        this.menuBar.add(this.fileMenu);
        this.goalMenu = new JMenu("Goal");
        this.goal = new JMenuItem("New Goal");
        this.goalMenu.add(this.goal);
        this.goal.addActionListener(this);
        this.menuBar.add(this.goalMenu);
        this.dbMenu = new JMenu("Databases");
        this.newAcquaintance = new JMenuItem("Add Acquaintance");
        this.dbMenu.add(this.newAcquaintance);
        this.newAcquaintance.addActionListener(this);
        this.newResource = new JMenuItem("Add Resource");
        this.dbMenu.add(this.newResource);
        this.newResource.addActionListener(this);
        this.newTask = new JMenuItem("Add Task");
        this.dbMenu.add(this.newTask);
        this.newTask.addActionListener(this);
        this.menuBar.add(this.dbMenu);
        this.viewMenu = new JMenu("View");
        this.tile = new JMenuItem("Tile");
        this.tile.addActionListener(this);
        this.viewMenu.add(this.tile);
        this.cascade = new JMenuItem("Cascade");
        this.cascade.addActionListener(this);
        this.viewMenu.add(this.cascade);
        this.viewMenu.addSeparator();
        this.nativeLF = new JMenuItem("Native Look & Feel");
        this.nativeLF.addActionListener(this);
        this.viewMenu.add(this.nativeLF);
        this.metalLF = new JMenuItem("Metal Look & Feel");
        this.metalLF.addActionListener(this);
        this.viewMenu.add(this.metalLF);
        this.menuBar.add(this.viewMenu);
        this.menuBar.add(Box.createHorizontalGlue());
        this.helpMenu = new JMenu("Help");
        this.about = new JMenuItem("Using the Agent Viewer");
        this.about.addActionListener(this);
        this.helpMenu.add(this.about);
        this.aboutZeus = new JMenuItem("About Zeus");
        this.aboutZeus.addActionListener(this);
        this.helpMenu.add(this.aboutZeus);
        this.menuBar.add(this.helpMenu);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.nativeLF) {
            this.getNativeUI();
            return;
        }
        if (object == this.metalLF) {
            try {
                System.out.println("Metal look & feel chosen");
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                SwingUtilities.updateComponentTreeUI(this);
            }
            catch (Exception exception) {
                System.out.println("Error getting UI");
            }
            return;
        }
        if (object == this.about) {
            this.showHelp();
        } else if (object == this.aboutZeus) {
            this.About();
        }
        if (this.context != null) {
            if (object == this.exit) {
                this.exitBtnFn();
            } else if (object == this.tile) {
                this.bottomPanel.tile();
            } else if (object == this.cascade) {
                this.bottomPanel.cascade();
            } else if (object == this.options) {
                new ControlOptionsDialog(this, this.context);
            } else if (object == this.goal) {
                GoalDialog goalDialog = new GoalDialog((Frame)this, true, this.context);
                goalDialog.display();
            } else if (object == this.newAcquaintance) {
                System.out.println("not yet implemented");
            } else if (object == this.newResource) {
                System.out.println("not yet implemented");
            } else if (object == this.newTask) {
                System.out.println("not yet implemented");
            } else if (object == this.mailInBtn) {
                new MailInTableUI(this.bottomPanel, this.mailInBuffer);
            } else if (object == this.mailOutBtn) {
                new MailOutTableUI(this.bottomPanel, this.mailOutBuffer);
            } else if (object == this.msgHandlerBtn) {
                new MsgHandlerTableUI(this.bottomPanel, this.msgHandlerBuffer);
            } else if (object == this.coordEngineBtn) {
                new EngineUI(this.bottomPanel, this.engineBuffer);
            } else if (object == this.reteEngineBtn) {
                new ReteEngineUI(this.bottomPanel, this.reteEngineBuffer);
            } else if (object == this.acqDbBtn) {
                new AcquaintanceUI(this.bottomPanel, this.relationsBuffer, this.abilitiesBuffer, this.attributesBuffer);
            } else if (object == this.planSchBtn) {
                new PlanSchTableUI(this.bottomPanel, this.planSchBuffer);
            } else if (object == this.taskPlanDbBtn) {
                new TaskTableUI(this.bottomPanel, this.taskBuffer, this.preCondBuffer, this.preAttrBuffer, this.effectBuffer, this.effectsAttrBuffer, this.constraintsBuffer, this.orderingBuffer);
            } else if (object == this.resDbBtn) {
                new ResourceTableUI(this.bottomPanel, this.resourceBuffer);
            } else if (object == this.ontDbBtn) {
                OntologyEditor ontologyEditor = new OntologyEditor(this.context.OntologyDb(), true);
            } else if (object == this.protocolBtn) {
                new ProtocolUI(this.bottomPanel, this.protocolBuffer, this.strategyBuffer, this.pAttributesBuffer);
            } else {
                System.out.println("Unrecognised event source");
            }
        } else {
            JOptionPane.showMessageDialog(this, "No associated agent", "Error Message", 0);
        }
    }

    private void exitBtnFn() {
        if (this.context != null) {
            this.mailInBuffer.removeZeusEventMonitors();
            this.mailOutBuffer.removeZeusEventMonitors();
            this.msgHandlerBuffer.removeZeusEventMonitors();
            this.abilitiesBuffer.removeZeusEventMonitors();
            this.relationsBuffer.removeZeusEventMonitors();
            this.resourceBuffer.removeZeusEventMonitors();
            this.engineBuffer.removeZeusEventMonitors();
            this.protocolBuffer.removeZeusEventMonitors();
            if (this.context.Planner() != null) {
                this.taskBuffer.removeZeusEventMonitors();
                this.planSchBuffer.removeZeusEventMonitors();
            }
        }
        MailBox mailBox = this.context.getMailBox();
        mailBox.shutdown();
        try {
            Thread.sleep(25L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }

    Icon getIcon(String string, int n, int n2) {
        String string2 = new String(this.IMAGEPATH + string);
        Image image = Toolkit.getDefaultToolkit().getImage(string2);
        image = image.getScaledInstance(n, n2, 4);
        ImageIcon imageIcon = new ImageIcon(image);
        return imageIcon;
    }

    private TitledBorder makeBorder(String string) {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.black);
        return titledBorder;
    }

    private void addButtonsToToolBar() {
        this.toolBar.setFloatable(false);
        this.toolBar.setAutoscrolls(true);
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(true);
        this.toolBar.add(jToolBar);
        this.mailInBtn = new AgentButton("Incoming Mail", this.getIcon("mailin.gif", 40, 40));
        this.mailInBtn.addActionListener(this);
        jToolBar.add(this.mailInBtn);
        this.mailOutBtn = new AgentButton("Outgoing Mail", this.getIcon("mailout.gif", 40, 40));
        this.mailOutBtn.addActionListener(this);
        jToolBar.add(this.mailOutBtn);
        this.msgHandlerBtn = new AgentButton("Message Handler", this.getIcon("handler.gif", 40, 40));
        this.msgHandlerBtn.addActionListener(this);
        jToolBar.add(this.msgHandlerBtn);
        this.reteEngineBtn = new AgentButton("Rule Engine", this.getIcon("rulebase.gif", 40, 40));
        this.reteEngineBtn.addActionListener(this);
        jToolBar.add(this.reteEngineBtn);
        this.coordEngineBtn = new AgentButton("Coordination Engine", this.getIcon("engine.gif", 40, 40));
        this.coordEngineBtn.addActionListener(this);
        jToolBar.add(this.coordEngineBtn);
        this.planSchBtn = new AgentButton("Planner and Scheduler", this.getIcon("planner.gif", 40, 40));
        this.planSchBtn.addActionListener(this);
        jToolBar.add(this.planSchBtn);
        JToolBar jToolBar2 = new JToolBar(0);
        this.toolBar.add(jToolBar2);
        this.acqDbBtn = new AgentButton("Acquaintance Database", this.getIcon("acquaintdb.gif", 40, 40));
        this.acqDbBtn.addActionListener(this);
        jToolBar2.add(this.acqDbBtn);
        this.ontDbBtn = new AgentButton("Ontology Database", this.getIcon("ontologydb.gif", 40, 40));
        this.ontDbBtn.addActionListener(this);
        jToolBar2.add(this.ontDbBtn);
        this.protocolBtn = new AgentButton("Protocols & Strategies", this.getIcon("protocol.gif", 40, 40));
        this.protocolBtn.addActionListener(this);
        jToolBar2.add(this.protocolBtn);
        this.resDbBtn = new AgentButton("Resource Database", this.getIcon("resourcedb.gif", 40, 40));
        this.resDbBtn.addActionListener(this);
        jToolBar2.add(this.resDbBtn);
        this.taskPlanDbBtn = new AgentButton("Task/Plan Database", this.getIcon("taskdb.gif", 40, 40));
        this.taskPlanDbBtn.addActionListener(this);
        jToolBar2.add(this.taskPlanDbBtn);
    }
}

