/*
 * Decompiled with CFR 0.152.
 */
package zeus.agents;

import java.io.File;
import java.util.Vector;
import zeus.actors.ExecutionMonitor;
import zeus.actors.OrganisationDb;
import zeus.actors.Planner;
import zeus.actors.ProtocolDb;
import zeus.actors.ResourceDb;
import zeus.actors.TaskDb;
import zeus.actors.event.AbilityMonitor;
import zeus.actors.event.ClockMonitor;
import zeus.actors.event.FactMonitor;
import zeus.actors.event.PlanningMonitor;
import zeus.actors.event.ProtocolMonitor;
import zeus.actors.event.RelationMonitor;
import zeus.actors.event.TaskMonitor;
import zeus.actors.rtn.Engine;
import zeus.agents.BasicAgent;
import zeus.concepts.AbilityDbItem;
import zeus.concepts.AbstractTask;
import zeus.concepts.Fact;
import zeus.concepts.Goal;
import zeus.concepts.OntologyDb;
import zeus.concepts.ProtocolInfo;
import zeus.concepts.ReteKB;
import zeus.concepts.Task;
import zeus.rete.ReteEngine;
import zeus.util.SystemProps;

public class ZeusAgent
extends BasicAgent {
    public ZeusAgent(String string, String string2, Vector vector, int n, int n2, boolean bl, boolean bl2) {
        super(SystemProps.getProperty("agent.names.agent"), string, vector);
        OntologyDb ontologyDb = new OntologyDb(this.context.GenSym());
        this.context.set(ontologyDb);
        int n3 = ontologyDb.openFile(new File(string2));
        if ((n3 & 2) != 0) {
            System.err.println("File I/O Error: " + ontologyDb.getError());
        } else if ((n3 & 1) != 0) {
            System.err.println("Warning: " + ontologyDb.getWarning());
        }
        new OrganisationDb(this.context);
        new ResourceDb(this.context);
        new Engine(this.context);
        new ProtocolDb(this.context);
        new Planner(this.context, n, n2);
        new TaskDb(this.context);
        new ExecutionMonitor(this.context);
        if (bl) {
            // empty if block
        }
        if (bl2) {
            ReteEngine reteEngine = new ReteEngine(this.context);
        }
    }

    public ZeusAgent(String string, String string2, Vector vector, int n, int n2) {
        this(string, string2, vector, n, n2, true, true);
    }

    public void addProtocol(Vector vector) {
        this.context.ProtocolDb().addProtocol(vector);
    }

    public void addProtocol(ProtocolInfo protocolInfo) {
        this.context.ProtocolDb().addProtocol(protocolInfo);
    }

    public void addTask(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.addTask((AbstractTask)vector.elementAt(i));
        }
    }

    public void addTask(AbstractTask abstractTask) {
        switch (abstractTask.getType()) {
            case 0: 
            case 1: {
                this.context.TaskDb().add((Task)abstractTask);
                break;
            }
            case 2: {
                this.context.ReteEngine().add((ReteKB)abstractTask);
                break;
            }
        }
    }

    public void addFact(Vector vector) {
        this.context.ResourceDb().add(vector);
    }

    public void addFact(Fact fact) {
        this.context.ResourceDb().add(fact);
    }

    public void addAbility(Vector vector) {
        this.context.OrganisationDb().add(vector);
    }

    public void addAbility(AbilityDbItem abilityDbItem) {
        this.context.OrganisationDb().add(abilityDbItem);
    }

    public void addRelation(Vector vector) {
        this.context.OrganisationDb().addRelation(vector);
    }

    public void addRelation(String string, String string2) {
        this.context.OrganisationDb().addRelation(string, string2);
    }

    public void achieve(Goal goal) {
        this.context.Engine().achieve(goal);
    }

    public void achieve(Goal goal, String string) {
        this.context.Engine().achieve(goal, string);
    }

    public void buy(Goal goal) {
        this.context.Engine().buy(goal);
    }

    public void sell(Goal goal) {
        this.context.Engine().sell(goal);
    }

    public void addRulebase(ReteKB reteKB) {
        this.context.ReteEngine().add(reteKB);
    }

    public void addAbilityMonitor(AbilityMonitor abilityMonitor, long l) {
        this.context.OrganisationDb().addAbilityMonitor(abilityMonitor, l);
    }

    public void removeAbilityMonitor(AbilityMonitor abilityMonitor, long l) {
        this.context.OrganisationDb().removeAbilityMonitor(abilityMonitor, l);
    }

    public void addRelationMonitor(RelationMonitor relationMonitor, long l) {
        this.context.OrganisationDb().addRelationMonitor(relationMonitor, l);
    }

    public void removeRelationMonitor(RelationMonitor relationMonitor, long l) {
        this.context.OrganisationDb().removeRelationMonitor(relationMonitor, l);
    }

    public void addClockMonitor(ClockMonitor clockMonitor, long l) {
        this.context.ExecutionMonitor().addClockMonitor(clockMonitor, l);
    }

    public void removeClockMonitor(ClockMonitor clockMonitor, long l) {
        this.context.ExecutionMonitor().removeClockMonitor(clockMonitor, l);
    }

    public void addPlanningMonitor(PlanningMonitor planningMonitor, long l) {
        this.context.Planner().addPlanningMonitor(planningMonitor, l);
    }

    public void removePlanningMonitor(PlanningMonitor planningMonitor, long l) {
        this.context.Planner().removePlanningMonitor(planningMonitor, l);
    }

    public void addFactMonitor(FactMonitor factMonitor, long l) {
        this.context.ResourceDb().addFactMonitor(factMonitor, l);
    }

    public void removeFactMonitor(FactMonitor factMonitor, long l) {
        this.context.ResourceDb().removeFactMonitor(factMonitor, l);
    }

    public void addTaskMonitor(TaskMonitor taskMonitor, long l) {
        this.context.TaskDb().addTaskMonitor(taskMonitor, l);
    }

    public void removeTaskMonitor(TaskMonitor taskMonitor, long l) {
        this.context.TaskDb().removeTaskMonitor(taskMonitor, l);
    }

    public void addProtocolMonitor(ProtocolMonitor protocolMonitor, long l) {
        this.context.ProtocolDb().addProtocolMonitor(protocolMonitor, l);
    }

    public void removeProtocolMonitor(ProtocolMonitor protocolMonitor, long l) {
        this.context.ProtocolDb().removeProtocolMonitor(protocolMonitor, l);
    }
}

