/*
 * Decompiled with CFR 0.152.
 */
package zeus.agents;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import zeus.actors.AgentContext;
import zeus.actors.OrganisationDb;
import zeus.actors.event.AbilityMonitor;
import zeus.actors.event.RelationMonitor;
import zeus.agents.BasicAgent;
import zeus.agents.BasicAgentUI;
import zeus.agents.ZeusExternal;
import zeus.concepts.Address;
import zeus.concepts.MessageRuleImpl;
import zeus.concepts.OntologyDb;
import zeus.concepts.Performative;
import zeus.concepts.ZeusParser;
import zeus.ontology.service.ServiceDescriptionReceiver;
import zeus.util.Core;
import zeus.util.SystemProps;

public class Facilitator
extends BasicAgent
implements Runnable {
    protected String ABILITY_KEY;
    public static final String SERVICE_KEY = "ACC_DAMLS_KEY";
    protected long timeout;
    protected boolean query_mode = true;

    public Facilitator(String string, String string2, Vector vector) {
        this(string, string2, vector, -1L);
    }

    public Facilitator(String string, String string2, Vector vector, long l) {
        super(SystemProps.getProperty("agent.names.facilitator"), string, vector);
        this.context.set(new OntologyDb(this.context.GenSym()));
        new OrganisationDb(this.context);
        OntologyDb ontologyDb = this.context.OntologyDb();
        int n = ontologyDb.openFile(new File(string2));
        if ((n & 2) != 0) {
            System.err.println("File I/O Error: " + ontologyDb.getError());
            System.exit(0);
        } else if ((n & 1) != 0) {
            System.err.println("Warning: " + ontologyDb.getWarning());
        }
        this.query_mode = l != 0L;
        this.timeout = (long)(60000.0 * SystemProps.getDouble("facilitator.period.default"));
        if (l > 0L) {
            this.timeout = l;
        }
        this.ABILITY_KEY = this.context.newId();
        String string3 = this.context.newId();
        String[] stringArray = new String[]{"type", "inform", "in-reply-to", string3};
        String[] stringArray2 = new String[]{"type", "inform", "in-reply-to", this.ABILITY_KEY, "content", "\\A\\(:fact(.*)\\Z"};
        String[] stringArray3 = new String[]{"type", "inform", "content", "\\A.*:serviceProfile.*", "in-reply-to", this.ABILITY_KEY};
        String[] stringArray4 = new String[]{"type", "inform", "content", "\\A.*:serviceInstance.*", "in-reply-to", this.ABILITY_KEY};
        String[] stringArray5 = new String[]{"type", "inform", "content", "\\A.*:serviceRange.*", "in-reply-to", this.ABILITY_KEY};
        String[] stringArray6 = new String[]{"type", "inform", "content", "\\A.*:processModel.*", "in-reply-to", this.ABILITY_KEY};
        this.context.MsgHandler().addRule(new MessageRuleImpl(this.context.newId("Rule"), stringArray, this, "addressReceived"));
        this.context.MsgHandler().addRule(new MessageRuleImpl(this.context.newId("Rule"), stringArray2, this, "abilityReceived"));
        ServiceDescriptionReceiver serviceDescriptionReceiver = new ServiceDescriptionReceiver(this.context);
        this.context.MsgHandler().addRule(new MessageRuleImpl(this.context.newId("Rule"), stringArray3, serviceDescriptionReceiver, "serviceProfileReceived"));
        this.context.MsgHandler().addRule(new MessageRuleImpl(this.context.newId("Rule"), stringArray4, serviceDescriptionReceiver, "serviceInstanceReceived"));
        this.context.MsgHandler().addRule(new MessageRuleImpl(this.context.newId("Rule"), stringArray5, serviceDescriptionReceiver, "serviceRangeReceived"));
        this.context.MsgHandler().addRule(new MessageRuleImpl(this.context.newId("Rule"), stringArray6, serviceDescriptionReceiver, "processModelReceived"));
        for (int i = 0; i < vector.size(); ++i) {
            Address address = (Address)vector.elementAt(i);
            Performative performative = new Performative("subscribe");
            performative.setReceiver(address.getName());
            performative.setReplyWith(string3);
            performative.setContent("log_address");
            this.context.MailBox().sendMsg(performative);
        }
        if (this.query_mode) {
            new Thread(this).start();
        }
    }

    public void addressReceived(Performative performative) {
        Core.DEBUG(2, "addressReceived: " + performative);
        Vector vector = ZeusParser.addressList(performative.getContent());
        this.context.MailBox().add(vector);
        this.advertise(vector);
        if (this.query_mode) {
            this.dispatchRequests(vector);
        }
    }

    public void abilityReceived(Performative performative) {
        Core.DEBUG(2, "abilityReceived: " + performative);
        Vector vector = ZeusParser.abilitySpecList(this.context.OntologyDb(), performative.getContent());
        String string = performative.getSender();
        this.context.OrganisationDb().add(string, vector);
        performative.setReceiver("df");
        performative.setContent(performative.getContent());
        performative.setInReplyTo("ACC_FIPA_DF_KEY");
        performative.send(this.context);
    }

    protected void dispatchRequests(Vector vector) {
        String string = this.context.whoami();
        String string2 = SystemProps.getProperty("agent.names.agent");
        for (int i = 0; i < vector.size(); ++i) {
            Address address = (Address)vector.elementAt(i);
            if (address.getName().equals(string) || !address.getType().equals(string2)) continue;
            Performative performative = new Performative("query-ref");
            performative.setReceiver(address.getName());
            performative.setReplyWith(this.ABILITY_KEY);
            performative.setContent("your_abilities");
            this.context.MailBox().sendMsg(performative);
        }
    }

    protected void advertise(Vector vector) {
        String string = this.context.whoami();
        String string2 = SystemProps.getProperty("agent.names.agent");
        for (int i = 0; i < vector.size(); ++i) {
            Address address = (Address)vector.elementAt(i);
            if (address.getName().equals(string) || !address.getType().equals(string2)) continue;
            Performative performative = new Performative("inform");
            performative.setReceiver(address.getName());
            performative.setContent("isa_facilitator " + string);
            this.context.MailBox().sendMsg(performative);
        }
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (true) {
            try {
                Thread.sleep(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Vector vector = this.context.MailBox().listAddresses();
            this.dispatchRequests(vector);
            thread.yield();
        }
    }

    public void addAbilityMonitor(AbilityMonitor abilityMonitor, long l) {
        this.context.OrganisationDb().addAbilityMonitor(abilityMonitor, l);
    }

    public void addRelationMonitor(RelationMonitor relationMonitor, long l) {
        this.context.OrganisationDb().addRelationMonitor(relationMonitor, l);
    }

    public void removeAbilityMonitor(AbilityMonitor abilityMonitor, long l) {
        this.context.OrganisationDb().removeAbilityMonitor(abilityMonitor, l);
    }

    public void removeRelationMonitor(RelationMonitor relationMonitor, long l) {
        this.context.OrganisationDb().removeRelationMonitor(relationMonitor, l);
    }

    protected static void version() {
        System.err.println("Facilitator version: " + SystemProps.getProperty("version.id"));
        System.exit(0);
    }

    protected static void usage() {
        System.err.println("Usage: java zeus.agents.Facilitator <name> -o <ontology_file> -s <dns_file>] [-t <period>] [-gui ViewerProg] [-e ExternalProg] [-debug] [-v] [-h]");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        Serializable serializable;
        try {
            serializable = Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Java cannot find java.lang.Object.\n This indicates that the rt.jar file is not in your classpath.\n Ensure that $java_install_dir\\jre\\rt.jar is present in the classpath and then continue");
            classNotFoundException.printStackTrace();
        }
        try {
            serializable = Class.forName("zeus.gui.help.HelpWindow");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Java cannot find a zeus class.\n This indicates that the zeus.jar file is not in your classpath.\n Ensure that zeus_install_dir\\lib\\zeus.jar is present in the classpath and then continue");
            classNotFoundException.printStackTrace();
        }
        serializable = null;
        String string = null;
        String string2 = null;
        long l = 0L;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (stringArray.length < 5) {
            Facilitator.usage();
        } else {
            for (int i = 1; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-s") && ++i < stringArray.length) {
                    string = stringArray[i];
                    continue;
                }
                if (stringArray[i].equals("-t") && ++i < stringArray.length) {
                    string2 = stringArray[i];
                    continue;
                }
                if (stringArray[i].equals("-o") && ++i < stringArray.length) {
                    string5 = stringArray[i];
                    continue;
                }
                if (stringArray[i].equals("-gui") && ++i < stringArray.length) {
                    string3 = stringArray[i];
                    continue;
                }
                if (stringArray[i].equals("-e") && ++i < stringArray.length) {
                    string4 = stringArray[i];
                    continue;
                }
                if (stringArray[i].equals("-debug")) {
                    Core.debug = true;
                    Core.setDebuggerOutputFile(stringArray[0] + ".log");
                    continue;
                }
                if (stringArray[i].equals("-h")) {
                    Facilitator.usage();
                    continue;
                }
                if (stringArray[i].equals("-v")) {
                    Facilitator.version();
                    continue;
                }
                Facilitator.usage();
            }
        }
        if (string5 == null) {
            System.err.println("Ontology Database file must be specified with -o option");
            Facilitator.usage();
        }
        if (string == null) {
            System.err.println("Domain nameserver file must be specified with -s option");
            Facilitator.usage();
        }
        try {
            Object object;
            Class<?> clazz;
            serializable = ZeusParser.addressList(new FileInputStream(string));
            if (serializable == null || ((Vector)serializable).isEmpty()) {
                throw new IOException();
            }
            if (string2 != null) {
                double d = Double.valueOf(string2);
                l = (long)(d * 60000.0);
            }
            Facilitator facilitator = new Facilitator(stringArray[0], string5, (Vector)serializable, l);
            AgentContext agentContext = facilitator.getAgentContext();
            if (string3 != null) {
                clazz = Class.forName(string3);
                object = (BasicAgentUI)clazz.newInstance();
                agentContext.set((BasicAgentUI)object);
                object.set(agentContext);
            }
            if (string4 != null) {
                clazz = Class.forName(string4);
                object = (ZeusExternal)clazz.newInstance();
                agentContext.set((ZeusExternal)object);
                object.exec(agentContext);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
    }
}

