/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors.rtn;

import java.util.Vector;
import zeus.actors.rtn.Engine;
import zeus.actors.rtn.Graph;
import zeus.actors.rtn.Node;
import zeus.util.Core;
import zeus.util.Misc;

public class PGraph
extends Graph {
    protected Vector done_nodes = new Vector();
    protected Vector failed_nodes = new Vector();
    protected Node[] start_nodes = null;
    protected boolean first = true;
    protected int min_done = -1;
    protected int max_fail = 0;

    public PGraph(String string, String[][] stringArray, String string2) {
        super(string, stringArray, string2);
    }

    public PGraph(String string, String[][] stringArray, String string2, int n) {
        super(string, stringArray, string2);
        this.min_done = n;
    }

    protected void start(Engine engine, Object object) {
        int n;
        this.state = 1;
        Object[] objectArray = (Object[])object;
        this.start_nodes = new Node[objectArray.length];
        if (this.min_done != -1) {
            this.max_fail = objectArray.length - this.min_done;
        }
        for (n = 0; n < objectArray.length; ++n) {
            this.start_nodes[n] = this.newNode(engine, this.start_node, this.previous_node);
            if (this.start_nodes[n] != null) continue;
            this.fail(engine, "Start node not found");
            return;
        }
        for (n = 0; n < objectArray.length; ++n) {
            this.start_nodes[n].setInput(engine, objectArray[n]);
            engine.add(this.start_nodes[n]);
        }
    }

    void done(Engine engine, Node node) {
        this.done_nodes.addElement(node);
        Core.DEBUG(3, this.description + " no: " + this.done_nodes.size() + " done");
        if (this.done_nodes.size() + this.failed_nodes.size() == this.start_nodes.length) {
            this.doSucceed(engine);
        }
    }

    protected void doSucceed(Engine engine) {
        this.setState(engine, 2);
        if (this.graph != null) {
            Node node = this.graph.newNode(engine, this.next_node, this.previous_node, this.getTerminalNodes());
            if (node == null) {
                this.fail(engine, "next_node - " + this.next_node + " - not found");
                return;
            }
            Object[] objectArray = new Object[this.done_nodes.size()];
            for (int i = 0; i < this.done_nodes.size(); ++i) {
                objectArray[i] = ((Node)this.done_nodes.elementAt(i)).getOutput();
            }
            node.setInput(engine, objectArray);
            engine.add(node);
        } else if (this.node_wakeup_key != null) {
            engine.wakeup(this.node_wakeup_key);
        }
    }

    void failed(Engine engine, Node node) {
        if (this.state != 3) {
            int n;
            for (n = 0; n < this.start_nodes.length; ++n) {
                if (this.start_nodes[n] != node) continue;
                this.failed_nodes.addElement(node);
                if (this.failed_nodes.size() <= this.max_fail) break;
                this.setState(engine, 3);
                break;
            }
            if (this.state == 3) {
                for (n = 0; n < this.done_nodes.size(); ++n) {
                    ((Node)this.done_nodes.elementAt(n)).fail(engine, true, "Parallel branch failed");
                }
            }
        } else {
            for (int i = 0; i < this.start_nodes.length; ++i) {
                if (this.start_nodes[i] != node) continue;
                this.failed_nodes.addElement(node);
                break;
            }
        }
        if (this.first && this.failed_nodes.size() == this.start_nodes.length) {
            this.first = false;
            this.fail(engine, "Parallel graph failed");
        } else if (this.failed_nodes.size() + this.done_nodes.size() == this.start_nodes.length) {
            this.doSucceed(engine);
        }
    }

    Node newNode(Engine engine, String string, Node node) {
        if (this.state == 3) {
            return null;
        }
        return super.newNode(engine, string, node);
    }

    Vector getTerminalNodes() {
        Vector vector;
        Node node;
        int n;
        Vector vector2 = new Vector();
        Core.DEBUG(3, "PGraph: getTerminalNodes for: " + this.description);
        for (n = 0; n < this.done_nodes.size(); ++n) {
            node = (Node)this.done_nodes.elementAt(n);
            Core.DEBUG(3, "\tConsidering done_node: " + node);
            vector = node.getParentsOfNextNode();
            if (vector != null) {
                vector2 = Misc.union(vector2, vector);
            } else {
                vector2.addElement(node);
            }
            Core.DEBUG(3, "\tCurrent terminals: " + vector2);
        }
        for (n = 0; n < this.failed_nodes.size(); ++n) {
            node = (Node)this.failed_nodes.elementAt(n);
            Core.DEBUG(3, "\tConsidering failed_node: " + node);
            vector = node.getParentsOfNextNode();
            if (vector != null) {
                vector2 = Misc.union(vector2, vector);
            } else {
                vector2.addElement(node);
            }
            Core.DEBUG(3, "\tCurrent terminals: " + vector2);
        }
        Core.DEBUG(3, "\tFinal terminals: " + vector2);
        return vector2;
    }

    boolean allow_backtrack(Node node) {
        for (int i = 0; i < this.start_nodes.length; ++i) {
            if (this.start_nodes[i] != node) continue;
            return false;
        }
        return true;
    }
}

