/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors.rtn;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.actors.rtn.Engine;
import zeus.actors.rtn.Node;
import zeus.util.Core;
import zeus.util.Misc;
import zeus.util.Queue;

class NodeWaitTable
extends Hashtable
implements Runnable {
    protected Queue queue = null;
    protected Engine engine;
    protected Vector dont_add_list = new Vector();
    protected long sleep_until = Long.MAX_VALUE;

    public NodeWaitTable(Engine engine, Queue queue) {
        this.engine = engine;
        this.queue = queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Thread.currentThread().setName("NodeWaitTable");
        while (true) {
            try {
                while (true) {
                    Core.DEBUG(3, "Before Wakeup\n" + this);
                    this.wakeup();
                    long l = this.sleep_period();
                    Core.DEBUG(3, this.engine.getAgentContext().whoami() + " sleeping for " + l);
                    Core.DEBUG(3, "After Wakeup\n" + this);
                    NodeWaitTable nodeWaitTable = this;
                    synchronized (nodeWaitTable) {
                        this.wait(l);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    protected synchronized long sleep_period() {
        long l = Long.MAX_VALUE;
        if (!this.isEmpty()) {
            double d = Double.MAX_VALUE;
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                Vector vector = (Vector)enumeration.nextElement();
                for (int i = 0; i < vector.size(); ++i) {
                    Node node = (Node)vector.elementAt(i);
                    d = Math.min(d, node.getTimeout());
                }
            }
            l = (long)((d -= this.engine.getAgentContext().now()) * (double)this.engine.getAgentContext().getClockStep());
        }
        this.sleep_until = (l = Math.max(l, 0L)) == Long.MAX_VALUE ? l : System.currentTimeMillis() + l;
        return l;
    }

    public synchronized void wakeup() {
        double d = this.engine.getAgentContext().now();
        Core.DEBUG(4, "wakeup>> now == " + String.valueOf(d));
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            Core.DEBUG(4, "in while - keys >= !");
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)this.get(string);
            for (int i = 0; i < vector.size(); ++i) {
                Node node = (Node)vector.elementAt(i);
                Core.DEBUG(4, "Timeout == " + node.getTimeout());
                if (!(d >= node.getTimeout())) continue;
                this.queue.enqueue(node);
                vector.removeElementAt(i);
            }
            if (!vector.isEmpty()) continue;
            this.remove(string);
        }
        this.notifyAll();
    }

    public synchronized void wakeup(String string) {
        Vector vector = (Vector)this.remove(string);
        if (vector == null) {
            this.dont_add_list.addElement(string);
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Node node = (Node)vector.elementAt(i);
            this.queue.enqueue(node);
        }
        vector = null;
        this.notify();
    }

    public synchronized void add(Node node) {
        String string = node.getMsgWaitKey();
        Core.DEBUG(3, "Adding wait_node: " + node.getDescription() + "[" + string + "]");
        if (this.dont_add_list.contains(string)) {
            this.dont_add_list.removeElement(string);
            this.queue.enqueue(node);
            return;
        }
        Vector<Node> vector = (Vector<Node>)this.get(string);
        if (vector == null) {
            vector = new Vector<Node>();
            this.put(string, vector);
        }
        vector.addElement(node);
        double d = node.getTimeout();
        long l = (long)((d -= this.engine.getAgentContext().now()) * (double)this.engine.getAgentContext().getClockStep());
        if (System.currentTimeMillis() + l < this.sleep_until) {
            Core.DEBUG(3, "Will notify... ");
            this.notify();
        } else {
            Core.DEBUG(3, "No notify: sleeping for " + (this.sleep_until - System.currentTimeMillis()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        double d = this.engine.getAgentContext().now();
        String string = "NodeWaitTable: now = " + Misc.decimalPlaces(d, 4) + "\n";
        NodeWaitTable nodeWaitTable = this;
        synchronized (nodeWaitTable) {
            Enumeration enumeration = this.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Vector vector = (Vector)this.get(string2);
                string = string + "\t" + string2 + "\n";
                for (int i = 0; i < vector.size(); ++i) {
                    Node node = (Node)vector.elementAt(i);
                    string = string + "\t\t" + node + "\t" + Misc.decimalPlaces(node.getTimeout(), 4) + "\n";
                }
            }
        }
        return string;
    }
}

