/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors.rtn;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.actors.AgentContext;
import zeus.actors.Planner;
import zeus.actors.event.ArcEvent;
import zeus.actors.event.ArcMonitor;
import zeus.actors.event.ConversationEvent;
import zeus.actors.event.ConversationMonitor;
import zeus.actors.event.GraphEvent;
import zeus.actors.event.GraphMonitor;
import zeus.actors.event.NodeEvent;
import zeus.actors.event.NodeMonitor;
import zeus.actors.graphs.buy;
import zeus.actors.graphs.g0;
import zeus.actors.graphs.g1;
import zeus.actors.graphs.g2;
import zeus.actors.graphs.sell;
import zeus.actors.rtn.Arc;
import zeus.actors.rtn.AuditTable;
import zeus.actors.rtn.Graph;
import zeus.actors.rtn.Node;
import zeus.actors.rtn.NodeWaitTable;
import zeus.actors.rtn.util.DelegationStruct;
import zeus.actors.rtn.util.GraphStruct;
import zeus.concepts.Bindings;
import zeus.concepts.Fact;
import zeus.concepts.Goal;
import zeus.concepts.MessageRuleImpl;
import zeus.concepts.Performative;
import zeus.concepts.PlannerQueryStruct;
import zeus.concepts.ZeusParser;
import zeus.util.Assert;
import zeus.util.Core;
import zeus.util.HSet;
import zeus.util.Misc;
import zeus.util.MsgContentHandler;
import zeus.util.Queue;

public class Engine
extends Thread {
    static final int ARC_CREATE = 0;
    static final int ARC_DISPOSE = 1;
    static final int ARC_FAIL = 2;
    static final int ARC_SUCCEED = 3;
    static final int NODE_CREATE = 0;
    static final int NODE_DISPOSE = 1;
    static final int NODE_STATE_CHANGE = 2;
    static final int GRAPH_CREATE = 0;
    static final int GRAPH_DISPOSE = 1;
    static final int GRAPH_STATE_CHANGE = 2;
    static final int INITATE_CONVERSATION = 0;
    static final int CONTINUE_CONVERSATION = 1;
    public static String[] COORDINATION_MESSAGE_TYPES = new String[]{"accept-proposal", "reject-proposal", "cfp", "propose", "refuse", "cancel", "failure", "result", "payment", "invoice"};
    protected Queue queue = new Queue();
    protected Vector msgQueue = new Vector();
    protected NodeWaitTable msgWaitTable;
    protected boolean running = true;
    protected AuditTable auditTable = null;
    protected AgentContext context = null;
    protected Hashtable itemsForSale = new Hashtable();
    protected Hashtable keyTable = new Hashtable();
    protected HSet[] nodeMonitors = new HSet[3];
    protected HSet[] arcMonitors = new HSet[4];
    protected HSet[] graphMonitors = new HSet[3];
    protected HSet[] conversationMonitors = new HSet[2];

    public Engine() {
    }

    public Engine(AgentContext agentContext) {
        int n;
        Assert.notNull(agentContext);
        this.context = agentContext;
        agentContext.set(this);
        this.auditTable = new AuditTable(this);
        for (n = 0; n < this.graphMonitors.length; ++n) {
            this.graphMonitors[n] = new HSet();
        }
        for (n = 0; n < this.nodeMonitors.length; ++n) {
            this.nodeMonitors[n] = new HSet();
        }
        for (n = 0; n < this.arcMonitors.length; ++n) {
            this.arcMonitors[n] = new HSet();
        }
        for (n = 0; n < this.conversationMonitors.length; ++n) {
            this.conversationMonitors[n] = new HSet();
        }
        this.msgWaitTable = new NodeWaitTable(this, this.queue);
        this.setPriority(4);
        String[] stringArray = new String[]{"type", "cfp", "reply-with", "\\A(\\w)(.*)\\Z", "in-reply-to", ""};
        agentContext.MsgHandler().addRule(new MessageRuleImpl(agentContext.newId("Rule"), stringArray, this, "new_dialogue"));
        this.start();
        Thread thread = new Thread(this.msgWaitTable);
        thread.setPriority(3);
        thread.start();
    }

    public synchronized void callCheckRecords() {
        Planner planner = this.context.getPlanner();
        planner.checkRecords();
    }

    public synchronized void callShuffle() {
        Planner planner = this.context.getPlanner();
        planner.shuffle();
    }

    public AgentContext getAgentContext() {
        return this.context;
    }

    public AuditTable getAuditTable() {
        return this.auditTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.setName("Engine");
        while (this.running) {
            Node node = (Node)this.queue.dequeue();
            Engine engine = this;
            synchronized (engine) {
                node.run(this);
                node = null;
            }
            Engine.yield();
        }
    }

    public void stopProcessing() {
        this.running = false;
    }

    public synchronized void new_dialogue(String string, String string2, String string3, Vector vector) {
        String string4 = Misc.concat(vector);
        Core.DEBUG(1, "start_dialogue:\n\tAgent: " + string2 + "\n\tCommsKey: " + string + "\n\tMsgType: " + string3 + "\n\tContent: " + string4);
        Performative performative = new Performative(string3);
        performative.setReplyWith(string);
        performative.setReceiver(string2);
        performative.setContent(string4);
        this.context.MailBox().sendMsg(performative);
        this.notifyConversationMonitors(string, this.context.whoami(), string2, string3, vector, 0);
    }

    public synchronized void new_dialogue(Performative performative) {
        String string = performative.getReplyWith();
        String string2 = performative.getSender();
        String string3 = performative.getContent();
        Vector vector = ZeusParser.goalList(this.context.OntologyDb(), string3);
        vector = this.dereference(vector);
        this.notifyConversationMonitors(string, string2, this.context.whoami(), performative.getType(), vector, 0);
        this.achieve(string2, string, vector);
    }

    public synchronized void continue_dialogue(String string, String string2, String string3, Vector vector) {
        String string4 = Misc.concat(vector);
        Core.DEBUG(1, "continue_dialogue:\n\tAgent: " + string2 + "\n\tCommsKey: " + string + "\n\tMsgType: " + string3 + "\n\tContent: " + string4);
        Performative performative = new Performative(string3);
        performative.setInReplyTo(string);
        performative.setReceiver(string2);
        performative.setContent(string4);
        this.context.MailBox().sendMsg(performative);
        this.notifyConversationMonitors(string, this.context.whoami(), string2, string3, vector, 1);
    }

    public synchronized void continue_dialogue(String string, String string2, String string3, String string4, String string5, Vector vector) {
        String string6 = Misc.concat(vector);
        Core.DEBUG(1, "continue_dialogue:\n\tAgent: " + string2 + "\n\tCommsKey: " + string + "\n\tMsgType: " + string3 + "\n\tDataType: " + string4 + "\n\tDataKey: " + string5 + "\n\tContent: " + string6);
        Performative performative = new Performative(string3);
        Core.ERROR(string3.equals("inform"), 2, (Object)this);
        performative.setInReplyTo(string);
        performative.setReceiver(string2);
        performative.setContent(string4 + " " + string5 + " " + string6);
        this.context.MailBox().sendMsg(performative);
        this.notifyConversationMonitors(string, this.context.whoami(), string2, string3, string4, string5, vector, 1);
    }

    public synchronized void continue_dialogue(Performative performative) {
        try {
            String string = performative.getSender();
            String string2 = performative.getContent();
            String string3 = performative.getType();
            String string4 = performative.getInReplyTo();
            if (string3.equals("inform")) {
                MsgContentHandler msgContentHandler = new MsgContentHandler(string2);
                String string5 = msgContentHandler.tag();
                String string6 = msgContentHandler.data(0);
                String string7 = msgContentHandler.rest(0);
                Vector vector = ZeusParser.factList(this.context.OntologyDb(), string7);
                vector = this.dereference(vector);
                this.notifyConversationMonitors(string4, string, this.context.whoami(), string3, string5, string6, vector, 1);
                this.add(new DelegationStruct(string, string5, string6, vector));
            } else {
                Vector vector = ZeusParser.goalList(this.context.OntologyDb(), string2);
                vector = this.dereference(vector);
                this.notifyConversationMonitors(string4, string, this.context.whoami(), string3, vector, 1);
                this.add(new DelegationStruct(string, string3, string4, vector));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected final Vector dereference(Vector vector) {
        Vector<Object> vector2 = new Vector<Object>();
        Object e = vector.elementAt(0);
        if (e instanceof Fact) {
            for (int i = 0; i < vector.size(); ++i) {
                Fact fact = (Fact)vector.elementAt(i);
                fact = fact.duplicate("var", this.context.GenSym());
                vector2.addElement(fact);
            }
        } else {
            for (int i = 0; i < vector.size(); ++i) {
                Goal goal = (Goal)vector.elementAt(i);
                goal = goal.duplicate("var", this.context.GenSym());
                vector2.addElement(goal);
            }
        }
        return vector2;
    }

    public void achieve(String string, String string2, Vector vector) {
        Core.ERROR(!string.equals(this.context.whoami()), 2, (Object)this);
        Goal goal = (Goal)vector.elementAt(0);
        Fact fact = goal.getFact();
        DelegationStruct delegationStruct = null;
        String string3 = this.waitingToSell(fact);
        if (string3 != null) {
            this.itemsForSale.remove(string3);
            delegationStruct = new DelegationStruct(string, "cfp", string2, vector);
            this.msgQueue.addElement(delegationStruct);
            Core.DEBUG(2, "Waking seller node with key = " + string3);
            this.keyTable.put(string3, string2);
            this.msgWaitTable.wakeup(string3);
            return;
        }
        GraphStruct graphStruct = new GraphStruct(string, string2, vector);
        g0 g02 = new g0();
        this.notifyGraphMonitors(g02, 0);
        g02.run(this, graphStruct);
    }

    public void achieve(Goal goal) {
        GraphStruct graphStruct = new GraphStruct(this.context.whoami(), goal);
        g0 g02 = new g0();
        this.notifyGraphMonitors(g02, 0);
        g02.run(this, graphStruct);
    }

    public void achieve(Goal goal, String string) {
        Assert.notFalse(goal.whichType());
        DelegationStruct delegationStruct = new DelegationStruct(goal.getDesiredBy(), "enact", string, goal);
        this.auditTable.enact(delegationStruct);
    }

    public void buy(Goal goal) {
        buy buy2 = new buy();
        this.notifyGraphMonitors(buy2, 0);
        GraphStruct graphStruct = new GraphStruct(this.context.whoami(), goal);
        buy2.run(this, graphStruct);
    }

    public void sell(Goal goal) {
        sell sell2 = new sell();
        this.notifyGraphMonitors(sell2, 0);
        GraphStruct graphStruct = new GraphStruct(this.context.whoami(), goal);
        sell2.run(this, graphStruct);
    }

    public void add(Node node) {
        this.queue.enqueue(node);
    }

    public void add(DelegationStruct delegationStruct) {
        Core.DEBUG(2, "Engine: new msg received\n" + delegationStruct);
        if (delegationStruct.msg_type.equals("result")) {
            this.auditTable.goodsReceived(delegationStruct);
        } else if (delegationStruct.msg_type.equals("payment")) {
            this.auditTable.paymentReceived(delegationStruct);
        } else if (delegationStruct.msg_type.equals("invoice")) {
            this.auditTable.invoiceReceived(delegationStruct);
        } else if (delegationStruct.msg_type.equals("failure")) {
            int n = this.auditTable.exception(delegationStruct);
            GraphStruct graphStruct = new GraphStruct();
            graphStruct.goal = delegationStruct.goals;
            graphStruct.internal = new Vector();
            graphStruct.external = Misc.copyVector(graphStruct.goal);
            graphStruct.key = delegationStruct.key;
            graphStruct.agent = this.context.whoami();
            graphStruct.ignore_agents.addElement(delegationStruct.agent);
            double d = Double.MAX_VALUE;
            for (int i = 0; i < graphStruct.goal.size(); ++i) {
                Goal goal = (Goal)graphStruct.goal.elementAt(i);
                d = Math.min(d, goal.getConfirmTime().getTime());
            }
            graphStruct.timeout = (d - this.context.now()) / ((double)graphStruct.goal.size() + 0.5);
            graphStruct.any = new Integer(n);
            g2 g22 = new g2();
            this.notifyGraphMonitors(g22, 0);
            g22.run(this, graphStruct);
        } else if (delegationStruct.msg_type.equals("cancel")) {
            this.auditTable.cancel(delegationStruct);
        } else if (delegationStruct.msg_type.equals("enact")) {
            this.auditTable.enact(delegationStruct);
        } else {
            this.msgQueue.addElement(delegationStruct);
            this.msgWaitTable.wakeup(delegationStruct.key);
        }
    }

    public void addItemForSale(String string, Fact fact) {
        Core.ERROR(this.itemsForSale.put(string, fact) == null, 1, (Object)this);
    }

    public void removeItemForSale(String string) {
        this.itemsForSale.remove(string);
        this.keyTable.remove(string);
    }

    public String getBuyersKey(String string) {
        return (String)this.keyTable.get(string);
    }

    protected String waitingToSell(Fact fact) {
        Enumeration enumeration = this.itemsForSale.keys();
        Bindings bindings = new Bindings(this.context.whoami());
        while (enumeration.hasMoreElements()) {
            bindings.clear();
            String string = (String)enumeration.nextElement();
            Fact fact2 = (Fact)this.itemsForSale.get(string);
            if (!fact2.unifiesWith(fact, bindings)) continue;
            return string;
        }
        return null;
    }

    public synchronized void wakeup(String string) {
        this.msgWaitTable.wakeup(string);
    }

    public synchronized void replan(PlannerQueryStruct plannerQueryStruct, String string) {
        GraphStruct graphStruct = new GraphStruct();
        graphStruct.goal = plannerQueryStruct.goals;
        graphStruct.internal = plannerQueryStruct.internal;
        graphStruct.external = plannerQueryStruct.external;
        graphStruct.agent = this.context.whoami();
        graphStruct.key = string;
        double d = Double.MAX_VALUE;
        for (int i = 0; i < graphStruct.goal.size(); ++i) {
            Goal goal = (Goal)graphStruct.goal.elementAt(i);
            d = Math.min(d, goal.getConfirmTime().getTime());
        }
        graphStruct.timeout = (d - this.context.now()) / ((double)graphStruct.goal.size() + 0.5);
        g1 g12 = new g1();
        this.notifyGraphMonitors(g12, 0);
        g12.run(this, graphStruct);
    }

    public void agentWithAbilityFound(Performative performative) {
        String string = performative.getInReplyTo();
        String string2 = performative.getContent();
        if (this.context.OrganisationDb() != null) {
            Vector vector = ZeusParser.abilityDbItemList(this.context.OntologyDb(), string2);
            this.context.OrganisationDb().add(vector);
            this.msgWaitTable.wakeup(string);
        }
    }

    synchronized void waitForMsg(Node node) {
        this.msgWaitTable.add(node);
    }

    public synchronized DelegationStruct replyReceived(String string) {
        for (int i = 0; i < this.msgQueue.size(); ++i) {
            DelegationStruct delegationStruct = (DelegationStruct)this.msgQueue.elementAt(i);
            if (!delegationStruct.key.equals(string)) continue;
            this.msgQueue.removeElementAt(i--);
            return delegationStruct;
        }
        return null;
    }

    public synchronized DelegationStruct replyReceived(String string, String string2) {
        for (int i = 0; i < this.msgQueue.size(); ++i) {
            DelegationStruct delegationStruct = (DelegationStruct)this.msgQueue.elementAt(i);
            if (!delegationStruct.key.equals(string) || !delegationStruct.msg_type.equals(string2)) continue;
            this.msgQueue.removeElementAt(i--);
            return delegationStruct;
        }
        return null;
    }

    public synchronized void replaceReply(Vector vector) {
        if (vector == null || vector.isEmpty()) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.msgQueue.addElement(vector.elementAt(i));
        }
    }

    public Vector repliesReceived(String string) {
        Vector<DelegationStruct> vector = new Vector<DelegationStruct>();
        for (int i = 0; i < this.msgQueue.size(); ++i) {
            DelegationStruct delegationStruct = (DelegationStruct)this.msgQueue.elementAt(i);
            if (!delegationStruct.key.equals(string)) continue;
            vector.addElement(delegationStruct);
            this.msgQueue.removeElementAt(i--);
        }
        return vector;
    }

    public synchronized Vector repliesReceived(String string, String string2) {
        Vector<DelegationStruct> vector = new Vector<DelegationStruct>();
        for (int i = 0; i < this.msgQueue.size(); ++i) {
            DelegationStruct delegationStruct = (DelegationStruct)this.msgQueue.elementAt(i);
            if (!delegationStruct.key.equals(string) || !delegationStruct.msg_type.equals(string2)) continue;
            vector.addElement(delegationStruct);
            this.msgQueue.removeElementAt(i--);
        }
        return vector;
    }

    public void addConversationMonitor(ConversationMonitor conversationMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.conversationMonitors[0].add(conversationMonitor);
        }
        if ((l & 2L) != 0L) {
            this.conversationMonitors[1].add(conversationMonitor);
        }
    }

    public void removeConversationMonitor(ConversationMonitor conversationMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.conversationMonitors[0].remove(conversationMonitor);
        }
        if ((l & 2L) != 0L) {
            this.conversationMonitors[1].remove(conversationMonitor);
        }
    }

    public void addNodeMonitor(NodeMonitor nodeMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.nodeMonitors[0].add(nodeMonitor);
        }
        if ((l & 4L) != 0L) {
            this.nodeMonitors[2].add(nodeMonitor);
        }
        if ((l & 2L) != 0L) {
            this.nodeMonitors[1].add(nodeMonitor);
        }
    }

    public void removeNodeMonitor(NodeMonitor nodeMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.nodeMonitors[0].remove(nodeMonitor);
        }
        if ((l & 4L) != 0L) {
            this.nodeMonitors[2].remove(nodeMonitor);
        }
        if ((l & 2L) != 0L) {
            this.nodeMonitors[1].remove(nodeMonitor);
        }
    }

    public void addGraphMonitor(GraphMonitor graphMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.graphMonitors[0].add(graphMonitor);
        }
        if ((l & 4L) != 0L) {
            this.graphMonitors[2].add(graphMonitor);
        }
        if ((l & 2L) != 0L) {
            this.graphMonitors[1].add(graphMonitor);
        }
    }

    public void removeGraphMonitor(GraphMonitor graphMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.graphMonitors[0].remove(graphMonitor);
        }
        if ((l & 4L) != 0L) {
            this.graphMonitors[2].remove(graphMonitor);
        }
        if ((l & 2L) != 0L) {
            this.graphMonitors[1].remove(graphMonitor);
        }
    }

    public void addArcMonitor(ArcMonitor arcMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.arcMonitors[0].add(arcMonitor);
        }
        if ((l & 8L) != 0L) {
            this.arcMonitors[3].add(arcMonitor);
        }
        if ((l & 4L) != 0L) {
            this.arcMonitors[2].add(arcMonitor);
        }
        if ((l & 2L) != 0L) {
            this.arcMonitors[1].add(arcMonitor);
        }
    }

    public void removeArcMonitor(ArcMonitor arcMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.arcMonitors[0].remove(arcMonitor);
        }
        if ((l & 8L) != 0L) {
            this.arcMonitors[3].remove(arcMonitor);
        }
        if ((l & 4L) != 0L) {
            this.arcMonitors[2].remove(arcMonitor);
        }
        if ((l & 2L) != 0L) {
            this.arcMonitors[1].remove(arcMonitor);
        }
    }

    void notifyConversationMonitors(String string, String string2, String string3, String string4, Vector vector, int n) {
        if (this.conversationMonitors[n].isEmpty()) {
            return;
        }
        Enumeration enumeration = this.conversationMonitors[n].elements();
        switch (n) {
            case 0: {
                ConversationEvent conversationEvent = new ConversationEvent(this, this, string, string2, string3, string4, vector, 1L);
                while (enumeration.hasMoreElements()) {
                    ConversationMonitor conversationMonitor = (ConversationMonitor)enumeration.nextElement();
                    conversationMonitor.conversationInitiatedEvent(conversationEvent);
                }
                break;
            }
            case 1: {
                ConversationEvent conversationEvent = new ConversationEvent(this, this, string, string2, string3, string4, vector, 2L);
                while (enumeration.hasMoreElements()) {
                    ConversationMonitor conversationMonitor = (ConversationMonitor)enumeration.nextElement();
                    conversationMonitor.conversationContinuedEvent(conversationEvent);
                }
                break;
            }
        }
    }

    void notifyConversationMonitors(String string, String string2, String string3, String string4, String string5, String string6, Vector vector, int n) {
        if (this.conversationMonitors[n].isEmpty()) {
            return;
        }
        Enumeration enumeration = this.conversationMonitors[n].elements();
        switch (n) {
            case 0: {
                ConversationEvent conversationEvent = new ConversationEvent(this, this, string, string2, string3, string4, string5, string6, vector, 1L);
                while (enumeration.hasMoreElements()) {
                    ConversationMonitor conversationMonitor = (ConversationMonitor)enumeration.nextElement();
                    conversationMonitor.conversationInitiatedEvent(conversationEvent);
                }
                break;
            }
            case 1: {
                ConversationEvent conversationEvent = new ConversationEvent(this, this, string, string2, string3, string4, string5, string6, vector, 2L);
                while (enumeration.hasMoreElements()) {
                    ConversationMonitor conversationMonitor = (ConversationMonitor)enumeration.nextElement();
                    conversationMonitor.conversationContinuedEvent(conversationEvent);
                }
                break;
            }
        }
    }

    void notifyNodeMonitors(Node node, int n) {
        if (this.nodeMonitors[n].isEmpty()) {
            return;
        }
        Enumeration enumeration = this.nodeMonitors[n].elements();
        switch (n) {
            case 0: {
                NodeEvent nodeEvent = new NodeEvent(this, node, 1L);
                while (enumeration.hasMoreElements()) {
                    NodeMonitor nodeMonitor = (NodeMonitor)enumeration.nextElement();
                    nodeMonitor.nodeCreatedEvent(nodeEvent);
                }
                break;
            }
            case 1: {
                NodeEvent nodeEvent = new NodeEvent(this, node, 2L);
                while (enumeration.hasMoreElements()) {
                    NodeMonitor nodeMonitor = (NodeMonitor)enumeration.nextElement();
                    nodeMonitor.nodeDisposedEvent(nodeEvent);
                }
                break;
            }
            case 2: {
                NodeEvent nodeEvent = new NodeEvent(this, node, 4L);
                while (enumeration.hasMoreElements()) {
                    NodeMonitor nodeMonitor = (NodeMonitor)enumeration.nextElement();
                    nodeMonitor.nodeStateChangedEvent(nodeEvent);
                }
                break;
            }
        }
    }

    void notifyGraphMonitors(Graph graph, int n) {
        if (this.graphMonitors[n].isEmpty()) {
            return;
        }
        Enumeration enumeration = this.graphMonitors[n].elements();
        switch (n) {
            case 0: {
                GraphEvent graphEvent = new GraphEvent(this, graph, 1L);
                while (enumeration.hasMoreElements()) {
                    GraphMonitor graphMonitor = (GraphMonitor)enumeration.nextElement();
                    graphMonitor.graphCreatedEvent(graphEvent);
                }
                break;
            }
            case 1: {
                GraphEvent graphEvent = new GraphEvent(this, graph, 2L);
                while (enumeration.hasMoreElements()) {
                    GraphMonitor graphMonitor = (GraphMonitor)enumeration.nextElement();
                    graphMonitor.graphDisposedEvent(graphEvent);
                }
                break;
            }
            case 2: {
                GraphEvent graphEvent = new GraphEvent(this, graph, 4L);
                while (enumeration.hasMoreElements()) {
                    GraphMonitor graphMonitor = (GraphMonitor)enumeration.nextElement();
                    graphMonitor.graphStateChangedEvent(graphEvent);
                }
                break;
            }
        }
    }

    void notifyArcMonitors(Arc arc, Node node, int n) {
        if (this.arcMonitors[n].isEmpty()) {
            return;
        }
        Enumeration enumeration = this.arcMonitors[n].elements();
        switch (n) {
            case 0: {
                ArcEvent arcEvent = new ArcEvent(this, arc, node, 1L);
                while (enumeration.hasMoreElements()) {
                    ArcMonitor arcMonitor = (ArcMonitor)enumeration.nextElement();
                    arcMonitor.arcCreatedEvent(arcEvent);
                }
                break;
            }
            case 1: {
                ArcEvent arcEvent = new ArcEvent(this, arc, node, 2L);
                while (enumeration.hasMoreElements()) {
                    ArcMonitor arcMonitor = (ArcMonitor)enumeration.nextElement();
                    arcMonitor.arcDisposedEvent(arcEvent);
                }
                break;
            }
            case 3: {
                ArcEvent arcEvent = new ArcEvent(this, arc, node, 8L);
                while (enumeration.hasMoreElements()) {
                    ArcMonitor arcMonitor = (ArcMonitor)enumeration.nextElement();
                    arcMonitor.arcSucceededEvent(arcEvent);
                }
                break;
            }
            case 2: {
                ArcEvent arcEvent = new ArcEvent(this, arc, node, 4L);
                while (enumeration.hasMoreElements()) {
                    ArcMonitor arcMonitor = (ArcMonitor)enumeration.nextElement();
                    arcMonitor.arcFailedEvent(arcEvent);
                }
                break;
            }
        }
    }
}

