/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors.rtn;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.actors.MsgHandler;
import zeus.actors.Planner;
import zeus.actors.ResourceDb;
import zeus.actors.rtn.Contract;
import zeus.actors.rtn.Engine;
import zeus.actors.rtn.util.DelegationStruct;
import zeus.concepts.Fact;
import zeus.concepts.Goal;
import zeus.concepts.OntologyDb;
import zeus.concepts.RoutingRecord;
import zeus.util.Assert;
import zeus.util.Core;

public class AuditTable {
    public static final int CHILD = 0;
    public static final int ROOT = 1;
    protected static final int GOAL = 0;
    protected static final int KEY = 1;
    protected Hashtable contracts = new Hashtable();
    protected Hashtable auxiliary = new Hashtable();
    protected Hashtable router = new Hashtable();
    protected Engine engine = null;

    AuditTable(Engine engine) {
        Assert.notNull(engine);
        this.engine = engine;
    }

    public void addProducerRecords(Vector vector) {
        Core.DEBUG(2, "AddProducerRecords " + vector);
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.addRoutingRecord((RoutingRecord)vector.elementAt(i));
        }
    }

    public void addConsumerRecords(Vector vector) {
        Core.DEBUG(2, "AddConsumerRecords " + vector);
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.addRoutingRecord((RoutingRecord)vector.elementAt(i));
        }
    }

    protected void addRoutingRecord(RoutingRecord routingRecord) {
        String string;
        RoutingRecord routingRecord2;
        String string2 = this.engine.getAgentContext().whoami();
        if ((routingRecord.producer.equals(string2) || routingRecord.consumer.equals(string2)) && (routingRecord2 = this.router.put(string = routingRecord.consumer_id + "/" + routingRecord.use_ref, routingRecord)) != null) {
            Core.ERROR(routingRecord.equals(routingRecord2), 2001, (Object)this);
        }
    }

    public synchronized void add(Contract contract) {
        Core.DEBUG(2, "AddContract " + contract);
        Contract contract2 = this.contracts.put(contract.goal.getId(), contract);
        Core.ERROR(contract2 == null, 2002, (Object)this);
    }

    public synchronized void add(Goal goal, String string, double d, boolean bl, boolean bl2, String string2, String string3, double d3) {
        this.add(new Contract(goal, string, d, bl, bl2, string2, string3, d3));
    }

    public synchronized void del(Goal goal) {
        Core.DEBUG(2, "Del goal " + goal);
    }

    public synchronized void goodsReceived(DelegationStruct delegationStruct) {
        Core.DEBUG(2, "GoodsReceived\n" + delegationStruct);
        Core.DEBUG(2, this);
        Planner planner = this.engine.getAgentContext().Planner();
        MsgHandler msgHandler = this.engine.getAgentContext().MsgHandler();
        ResourceDb resourceDb = this.engine.getAgentContext().ResourceDb();
        OntologyDb ontologyDb = this.engine.getAgentContext().OntologyDb();
        String string = this.engine.getAgentContext().whoami();
        RoutingRecord routingRecord = null;
        routingRecord = (RoutingRecord)this.router.remove(delegationStruct.key);
        if (routingRecord != null) {
            if (delegationStruct.agent.equals(string)) {
                Core.ERROR(routingRecord.producer.equals(string), 1001, (Object)this);
                this.engine.continue_dialogue(routingRecord.comms_key, routingRecord.consumer, "inform", "result", delegationStruct.key, delegationStruct.goals);
                Contract contract = (Contract)this.contracts.get(routingRecord.producer_id);
                contract.delivered = true;
                Fact fact = ontologyDb.getFact(true, "Money");
                fact.setValue("amount", Double.toString(contract.cost));
                Vector<Fact> vector = new Vector<Fact>();
                vector.addElement(fact);
                this.engine.continue_dialogue(contract.key, contract.owner, "inform", "invoice", routingRecord.producer_id, vector);
            } else {
                Core.ERROR(routingRecord.consumer.equals(string), 1002, (Object)this);
                Contract contract = (Contract)this.contracts.get(routingRecord.producer_id);
                Fact fact = (Fact)delegationStruct.goals.elementAt(0);
                if (fact.isa("Entity")) {
                    double d = contract.cost / (double)fact.getNumber();
                    fact.setValue("unit_cost", Double.toString(d));
                }
                String string2 = routingRecord.consumer_id;
                String string3 = routingRecord.producer_id + "/" + routingRecord.use_ref;
                planner.notifyReceived(fact, string2, string3);
                msgHandler.removeRule(delegationStruct.key);
                if (contract != null) {
                    contract.delivered = true;
                }
            }
        } else {
            this.debug("toString" + delegationStruct.toString());
            this.debug("key " + delegationStruct.key);
            this.debug("contracts " + this.contracts.toString());
            Contract contract = (Contract)this.contracts.get(delegationStruct.key);
            if (delegationStruct.agent.equals(string)) {
                if (contract.owner.equals(string)) {
                    this.contracts.remove(delegationStruct.key);
                    Fact fact = (Fact)delegationStruct.goals.elementAt(0);
                    if (fact.isa("Entity")) {
                        double d = contract.cost / (double)fact.getNumber();
                        fact.setValue("unit_cost", Double.toString(d));
                    }
                    resourceDb.add(delegationStruct.goals);
                } else {
                    this.engine.continue_dialogue(contract.key, contract.owner, "inform", "result", delegationStruct.key, delegationStruct.goals);
                    contract.delivered = true;
                    Fact fact = ontologyDb.getFact(true, "Money");
                    fact.setValue("amount", Double.toString(contract.cost));
                    Vector<Fact> vector = new Vector<Fact>();
                    vector.addElement(fact);
                    this.engine.continue_dialogue(contract.key, contract.owner, "inform", "invoice", delegationStruct.key, vector);
                }
            } else {
                Core.DEBUG(3, contract.toString());
                Core.DEBUG(3, contract.owner);
                Core.ERROR(contract.owner.equals(string), 1075, (Object)this);
                contract.delivered = true;
                Fact fact = (Fact)delegationStruct.goals.elementAt(0);
                if (fact.isa("Entity")) {
                    double d = contract.cost / (double)fact.getNumber();
                    fact.setValue("unit_cost", Double.toString(d));
                }
                resourceDb.add(delegationStruct.goals);
            }
        }
        Core.DEBUG(2, "GoodsReceived - post\n" + this);
    }

    public void invoiceReceived(DelegationStruct delegationStruct) {
        Core.DEBUG(2, "AuditTable invoiceReceived:\n" + delegationStruct);
        Core.DEBUG(2, this);
        ResourceDb resourceDb = this.engine.getAgentContext().ResourceDb();
        MsgHandler msgHandler = this.engine.getAgentContext().MsgHandler();
        String string = this.engine.getAgentContext().whoami();
        Contract contract = (Contract)this.contracts.remove(delegationStruct.key);
        Core.DEBUG(3, "InvoiceReceived: contract\n\t" + contract);
        Assert.notFalse(contract.agent.equals(delegationStruct.agent));
        Assert.notFalse(contract.owner.equals(string));
        contract.paid = true;
        Core.DEBUG(3, "InvoiceReceived: about to debit");
        Fact fact = resourceDb.debit(contract.cost);
        Core.DEBUG(3, "InvoiceReceived: debit = " + fact);
        Vector<Fact> vector = new Vector<Fact>();
        vector.addElement(fact);
        this.engine.continue_dialogue(contract.key, contract.agent, "inform", "payment", delegationStruct.key, vector);
        msgHandler.removeRule(contract.key);
        Core.DEBUG(2, "AuditTable invoiceReceived - post:\n" + this);
    }

    public synchronized void paymentReceived(DelegationStruct delegationStruct) {
        Core.DEBUG(2, "AuditTable paymentReceived:\n" + delegationStruct);
        Core.DEBUG(2, this);
        ResourceDb resourceDb = this.engine.getAgentContext().ResourceDb();
        String string = this.engine.getAgentContext().whoami();
        Contract contract = (Contract)this.contracts.remove(delegationStruct.key);
        Assert.notFalse(contract.owner.equals(delegationStruct.agent));
        Assert.notFalse(contract.agent.equals(string));
        contract.paid = true;
        Fact fact = (Fact)delegationStruct.goals.elementAt(0);
        resourceDb.add(fact);
        Core.DEBUG(2, "AuditTable paymentReceived - post\n" + this);
    }

    public synchronized int exception(DelegationStruct delegationStruct) {
        Core.DEBUG(2, "AuditTable exception:\n" + delegationStruct);
        return 0;
    }

    public synchronized void cancel(DelegationStruct delegationStruct) {
        Core.DEBUG(2, "AuditTable cancel:\n" + delegationStruct);
    }

    public synchronized void cancel(String string) {
        Core.DEBUG(2, "AuditTable cancel: " + string);
    }

    public synchronized void enact(DelegationStruct delegationStruct) {
        Core.DEBUG(2, "AuditTable enact:\n" + delegationStruct);
    }

    protected synchronized boolean cleanup(Contract contract) {
        return false;
    }

    public Object remove(Object object) {
        return null;
    }

    public String toString() {
        String string;
        String string2 = "Audit Table Entries\n";
        Enumeration enumeration = this.contracts.keys();
        string2 = string2 + "...Contracts...\n";
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            Contract contract = (Contract)this.contracts.get(string);
            string2 = string2 + "Table-key = " + string + "\n" + contract + "\n";
        }
        string2 = string2 + "...Routing...\n";
        enumeration = this.router.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            RoutingRecord routingRecord = (RoutingRecord)this.router.get(string);
            string2 = string2 + "Table-key = " + string + "\n" + routingRecord + "\n";
        }
        string2 = string2 + "\n**************\n";
        return string2;
    }

    public void debug(String string) {
    }
}

