/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors.rtn;

import zeus.actors.AgentContext;
import zeus.actors.rtn.Engine;
import zeus.actors.rtn.Graph;
import zeus.actors.rtn.Node;
import zeus.util.Assert;
import zeus.util.Core;

public class Arc {
    private static int count = 0;
    protected String description = null;
    protected Object output = null;
    protected Object input = null;
    protected AgentContext context = null;
    protected Graph graph = null;

    protected Arc() {
    }

    public Arc(String string) {
        Assert.notNull(string);
        this.description = string + "-" + count++;
        Core.DEBUG(3, "New arc " + this.description + " created");
    }

    public final String getDescription() {
        return this.description;
    }

    public final Graph getGraph() {
        return this.graph;
    }

    void run1(Engine engine, Graph graph, Node node, Object object, String string) {
        this.input = object;
        this.graph = graph;
        this.context = engine.getAgentContext();
        Node node2 = null;
        if (this.exec() && (node2 = graph.newNode(engine, string, node)) != null) {
            node2.setInput(engine, this.output);
            engine.notifyArcMonitors(this, node2, 3);
            engine.add(node2);
        } else {
            Core.DEBUG(3, "Arc " + this.description + " FAILED");
            engine.notifyArcMonitors(this, null, 2);
            node.nextArc(engine);
        }
    }

    protected boolean exec() {
        this.output = this.input;
        return true;
    }

    protected void finalize() throws Throwable {
        if (this.context != null) {
            this.context.Engine().notifyArcMonitors(this, null, 1);
        }
        super.finalize();
    }

    public String toString() {
        return this.getDescription();
    }
}

