/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors.intrays;

import FIPA.FipaMessage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.Vector;
import zeus.actors.AgentContext;
import zeus.actors.InTray;
import zeus.actors.MsgHandler;
import zeus.actors.Server;
import zeus.actors.intrays.FIPA_2000_HTTP_Server;
import zeus.actors.intrays.FIPA_2000_Handler;
import zeus.actors.intrays.FIPA_2000_IIOP_Server;
import zeus.actors.intrays.FIPA_97_Handler;
import zeus.actors.intrays.FIPA_97_Server;
import zeus.actors.intrays.Zeus_ACC_MailBox;
import zeus.actors.outtrays.FIPA_PostMan;
import zeus.concepts.Address;
import zeus.concepts.AddressBook;
import zeus.concepts.FIPAPerformative;
import zeus.concepts.FIPA_AID_Address;
import zeus.concepts.FIPA_AddressBook;
import zeus.concepts.MessageRuleImpl;
import zeus.concepts.Performative;
import zeus.concepts.TransportConfig;
import zeus.concepts.ZeusParser;
import zeus.util.Assert;
import zeus.util.Misc;
import zeus.util.Queue;
import zeus.util.SystemProps;

public class Zeus_ACC_Server
extends Server
implements InTray,
FIPA_97_Handler,
FIPA_2000_Handler {
    public String hostname = SystemProps.getProperty("HAP_Address");
    protected String iiop2000Port = "2000";
    protected String iiop97Port = "1097";
    protected String httpPort = "61000";
    protected AgentContext context = null;
    private Queue msgQ = new Queue("Zeus_ACC_In");
    private ZeusParser parser = new ZeusParser();
    protected String name = "ACC";
    protected FIPA_2000_IIOP_Server twoThousand_Server = null;
    protected FIPA_97_Server ninetySeven_Server = null;
    protected FIPA_2000_HTTP_Server httpServer = null;
    protected String host = null;

    public Zeus_ACC_Server(AgentContext agentContext, Zeus_ACC_MailBox zeus_ACC_MailBox) {
        TransportConfig transportConfig;
        TransportConfig transportConfig2;
        this.mbox = zeus_ACC_MailBox;
        this.timeout = 10L;
        Assert.notNull(agentContext);
        this.context = agentContext;
        TransportConfig transportConfig3 = SystemProps.getTransport("FIPA_IIOP_2000");
        if (transportConfig3 != null) {
            this.debug("setting iiop 2000 port to : " + transportConfig3.getPort());
            this.iiop2000Port = transportConfig3.getPort();
        }
        if ((transportConfig2 = SystemProps.getTransport("FIPA_HTTP_2000")) != null) {
            this.debug("setting http 2000 port to : " + transportConfig2.getPort());
            this.httpPort = transportConfig2.getPort();
        }
        if ((transportConfig = SystemProps.getTransport("FIPA_IIOP_1997")) != null) {
            this.debug("setting iiop 1997 port to : " + transportConfig.getPort());
            this.iiop97Port = transportConfig.getPort();
        }
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            this.host = inetAddress.getHostAddress();
            if (this.hostname == null) {
                this.hostname = this.host;
            }
            this.twoThousand_Server = new FIPA_2000_IIOP_Server(this, this.host, this.iiop2000Port, this.name, "2000Connection");
            this.ninetySeven_Server = new FIPA_97_Server(this, this.host, this.iiop97Port, this.name, "97Connection");
            this.httpServer = new FIPA_2000_HTTP_Server(this, this.host, this.httpPort, this.name, "HTTPConnection");
            this.start();
            this.setName("Zeus_ACC_Server");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("ERROR - probably localhost cannot be looked up!\n WARNING: attempting to continue, but likely fatal");
        }
    }

    public void stopProcessing() {
        this.processing = false;
    }

    public void run() {
        this.processing = true;
        while (this.processing) {
            try {
                String string = this.pop();
                this.debug("popped message off queue");
                if (string instanceof String) {
                    String string2 = string;
                    this.debug("message popped is: " + string2);
                    string2 = Misc.unescape(string2);
                    this.forwardFIPAMessage(string2);
                }
                Zeus_ACC_Server.yield();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("exception in ACC server - attempting to recover");
            }
            catch (Error error) {
                error.printStackTrace();
                System.out.println("error - attempting to recover");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                System.out.println("throwable - attempting to recover");
            }
        }
    }

    public void forwardFIPAMessage(String string) {
        try {
            this.debug("forwarding");
            FIPA_AddressBook fIPA_AddressBook = (FIPA_AddressBook)this.context.getAddressBook();
            FIPAPerformative fIPAPerformative = ZeusParser.fipaPerformative(string);
            FIPA_AID_Address fIPA_AID_Address = fIPAPerformative.getSender_As_FIPA_AID();
            fIPA_AID_Address = fIPA_AddressBook.checkAddress(fIPA_AID_Address);
            if (fIPA_AID_Address.getAlias() == null) {
                this.registerAlias(fIPA_AID_Address);
            }
            Performative performative = fIPAPerformative.performative();
            String string2 = fIPA_AID_Address.getAlias();
            performative.setSender(string2);
            this.debug("setting send address to " + string2);
            performative.setReplyTo(string2);
            fIPA_AddressBook.add(fIPA_AID_Address);
            this.setHandleMessage(fIPA_AID_Address, string2);
            this.debug("Zeus content = " + performative.getContent());
            this.mbox.sendMsg(performative);
        }
        catch (Exception exception) {
            try {
                File file = new File("debug.out");
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                PrintWriter printWriter = new PrintWriter(fileOutputStream);
                exception.printStackTrace(printWriter);
                printWriter.flush();
                printWriter.close();
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
    }

    private void setHandleMessage(FIPA_AID_Address fIPA_AID_Address, String string) {
        if (!fIPA_AID_Address.getForwardingRuleSet()) {
            MsgHandler msgHandler = this.context.getMsgHandler();
            String[] stringArray = new String[]{"receiver", string};
            msgHandler.addRule(new MessageRuleImpl(this.context.newId("Rule"), stringArray, this, "forward"));
            fIPA_AID_Address.setForwardingRuleSet(true);
        }
    }

    public void setFIPAAlias(String string, String string2) {
        FIPA_AddressBook fIPA_AddressBook = (FIPA_AddressBook)this.context.getAddressBook();
        FIPAPerformative fIPAPerformative = ZeusParser.fipaPerformative(string2);
        FIPA_AID_Address fIPA_AID_Address = fIPAPerformative.getSender_As_FIPA_AID();
        if ((fIPA_AID_Address = fIPA_AddressBook.checkAddress(fIPA_AID_Address)).getAlias() == null) {
            fIPA_AID_Address.setAlias(string);
            this.registerAlias(fIPA_AID_Address, string);
            this.setHandleMessage(fIPA_AID_Address, string);
            fIPA_AddressBook.add(fIPA_AID_Address);
        }
    }

    public void setFIPAAlias(String string, FIPA_AID_Address fIPA_AID_Address) {
        FIPA_AddressBook fIPA_AddressBook = (FIPA_AddressBook)this.context.getAddressBook();
        fIPA_AID_Address = fIPA_AddressBook.checkAddress(fIPA_AID_Address);
        if (fIPA_AID_Address.getAlias() == null) {
            fIPA_AID_Address.setAlias(string);
            this.registerAlias(fIPA_AID_Address, string);
            this.setHandleMessage(fIPA_AID_Address, string);
            fIPA_AddressBook.add(fIPA_AID_Address);
        }
    }

    public void forward(Performative performative) {
        if (performative.getSender().startsWith("Nameserver")) {
            return;
        }
        if (performative.getSender().startsWith("Facilitator")) {
            return;
        }
        try {
            FIPAPerformative fIPAPerformative = new FIPAPerformative(performative);
            FIPA_AddressBook fIPA_AddressBook = (FIPA_AddressBook)this.context.getAddressBook();
            String string = performative.getReceiver();
            FIPA_AID_Address fIPA_AID_Address = fIPA_AddressBook.lookupAlias(string);
            Vector<FIPA_AID_Address> vector = new Vector<FIPA_AID_Address>();
            vector.addElement(fIPA_AID_Address);
            fIPAPerformative.setReceivers(vector);
            String string2 = performative.getSender();
            InetAddress inetAddress = InetAddress.getLocalHost();
            String string3 = this.hostname;
            FIPA_AID_Address fIPA_AID_Address2 = new FIPA_AID_Address("(agent-identifier\n:name " + string2 + "@" + string3 + "\n:addresses (sequence " + this.getResponseAddress() + "))");
            fIPAPerformative.setSender(fIPA_AID_Address2);
            FIPA_PostMan fIPA_PostMan = ((Zeus_ACC_MailBox)this.mbox).getFIPA_PostMan();
            fIPA_PostMan.push(fIPAPerformative);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void registerAlias(FIPA_AID_Address fIPA_AID_Address) {
        System.out.println("In register 1");
        String string = fIPA_AID_Address.getName() + fIPA_AID_Address.getHost();
        AddressBook addressBook = this.context.getAddressBook();
        for (int i = 0; i < this.context.nameservers().size(); ++i) {
            String string2 = fIPA_AID_Address.setAlias(string);
            Address address = (Address)this.context.nameservers().elementAt(i);
            addressBook.add(address);
            Performative performative = new Performative("request");
            performative.setReceiver(address.getName());
            performative.setReplyWith(string2);
            performative.setContent("register");
            performative.setSender(string2);
            System.out.println("send message to nameserver");
            this.mbox.sendMsg(performative);
            System.out.println("done message");
        }
    }

    protected void registerAlias(FIPA_AID_Address fIPA_AID_Address, String string) {
        AddressBook addressBook = this.context.getAddressBook();
        for (int i = 0; i < this.context.nameservers().size(); ++i) {
            String string2 = fIPA_AID_Address.setAlias(string);
            Address address = (Address)this.context.nameservers().elementAt(i);
            addressBook.add(address);
            Performative performative = new Performative("request");
            performative.setReceiver(address.getName());
            performative.setReplyWith(string2);
            performative.setContent("register");
            performative.setSender(string2);
            this.mbox.sendMsg(performative);
        }
    }

    protected void registerAlias(String string) {
        AddressBook addressBook = this.context.getAddressBook();
        for (int i = 0; i < this.context.nameservers().size(); ++i) {
            String string2 = string;
            Address address = (Address)this.context.nameservers().elementAt(i);
            addressBook.add(address);
            Performative performative = new Performative("request");
            performative.setReceiver(address.getName());
            performative.setReplyWith(string2);
            performative.setContent("register");
            performative.setSender(string2);
            this.mbox.sendMsg(performative);
        }
    }

    public void registerAgent(FIPA_AID_Address fIPA_AID_Address, String string) {
        this.registerAlias(fIPA_AID_Address, string);
    }

    protected void finalize() {
        try {
            if (this.listenSocket != null) {
                this.listenSocket.close();
            }
            this.timeout = -1L;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Address getAddress() {
        return this.address;
    }

    public String pop() {
        return (String)this.msgQ.dequeue();
    }

    public void push(String string) {
        this.debug("enqueueing message ");
        this.msgQ.enqueue(string);
    }

    public void handle(String string) {
        this.push(string);
    }

    public synchronized void handle(FipaMessage fipaMessage) {
        byte[] byArray = fipaMessage.messageBody;
        String string = new String(byArray);
        this.push(string);
    }

    public String getResponseAddress() {
        String string = this.httpServer.getResponseAddress();
        String string2 = this.twoThousand_Server.getResponseAddress();
        String string3 = this.ninetySeven_Server.getResponseAddress();
        String string4 = this.twoThousand_Server.getIORAddress();
        String string5 = new String(string2 + " " + string);
        return string5;
    }

    public void debug(String string) {
        System.out.println("Zeus ACC server>> " + string);
    }
}

