/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors.intrays;

import FIPA.FipaMessage;
import java.io.File;
import java.io.FileWriter;
import java.util.Hashtable;
import java.util.Properties;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import zeus.actors.AgentContext;
import zeus.actors.InTray;
import zeus.actors.Server;
import zeus.actors.intrays.FIPA_2000_Handler;
import zeus.actors.intrays.FIPA_2000_IIOP_Connection;
import zeus.concepts.ZeusParser;
import zeus.util.Queue;
import zeus.util.SystemProps;

public class FIPA_2000_IIOP_Server
extends Server
implements InTray {
    protected AgentContext context = null;
    private Queue msgQ = new Queue("fipa2000In");
    private ZeusParser parser = new ZeusParser();
    private FIPA_2000_Handler handler = null;
    String fsep = System.getProperty("file.separator");
    private String host = null;
    private String port = null;
    private String name = null;
    private String iorAddr;
    String iorpath = SystemProps.getProperty("ior.dir");
    private String orbIOR = null;

    public FIPA_2000_IIOP_Server(FIPA_2000_Handler fIPA_2000_Handler, String string, String string2, String string3, String string4) {
        this.iorAddr = this.iorpath + string3;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        this.handler = fIPA_2000_Handler;
        this.host = string;
        this.port = string2;
        this.name = string3;
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
        try {
            Properties properties = new Properties();
            properties.put("org.omg.CORBA.ORBInitialPort", string2);
            ORB oRB = ORB.init((String[])new String[0], (Properties)properties);
            FIPA_2000_IIOP_Connection fIPA_2000_IIOP_Connection = new FIPA_2000_IIOP_Connection();
            this.orbIOR = oRB.object_to_string((Object)fIPA_2000_IIOP_Connection);
            File file = new File(this.iorAddr);
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(this.orbIOR);
            fileWriter.flush();
            fileWriter.close();
            Thread thread = new Thread(fIPA_2000_IIOP_Connection);
            thread.setPriority(1);
            thread.start();
            fIPA_2000_IIOP_Connection.register(this.msgQ);
            NamingContext namingContext = NamingContextHelper.narrow((Object)oRB.resolve_initial_references("NameService"));
            NameComponent nameComponent = new NameComponent(string3, "FIPA.MTS");
            NameComponent[] nameComponentArray = new NameComponent[]{nameComponent};
            namingContext.rebind(nameComponentArray, (Object)fIPA_2000_IIOP_Connection);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.start();
        this.setName(string4);
    }

    public void run() {
        this.processing = true;
        System.out.println("Listening for FIPA 2000 IIOP on port " + String.valueOf(this.port));
        while (this.processing) {
            FipaMessage fipaMessage = this.pop();
            try {
                this.handler.handle(fipaMessage);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            FIPA_2000_IIOP_Server.yield();
        }
    }

    public FipaMessage pop() {
        return (FipaMessage)this.msgQ.dequeue();
    }

    public String getResponseAddress() {
        return new String("corbaname:iiop:" + this.host + ":" + this.port + "/" + "NameService/" + this.name);
    }

    public String getIORAddress() {
        return new String(this.orbIOR);
    }
}

