/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors.intrays;

import FIPA.FipaMessage;
import java.io.File;
import java.io.FileWriter;
import java.util.Date;
import zeus.actors.AgentContext;
import zeus.actors.InTray;
import zeus.actors.Server;
import zeus.actors.intrays.FIPA_2000_HTTP_Connection;
import zeus.actors.intrays.FIPA_2000_Handler;
import zeus.concepts.FIPAPerformative;
import zeus.concepts.ZeusParser;
import zeus.util.Queue;
import zeus.util.SystemProps;

public class FIPA_2000_HTTP_Server
extends Server
implements InTray {
    protected AgentContext context = null;
    private Queue msgQ = new Queue("fipaHTTP2000In");
    private ZeusParser parser = new ZeusParser();
    private FIPA_2000_Handler handler = null;
    private String host = null;
    private String port = null;
    private String name = null;
    private File file = null;
    private FileWriter log;

    public FIPA_2000_HTTP_Server(FIPA_2000_Handler fIPA_2000_Handler, String string, String string2, String string3, String string4) {
        this.handler = fIPA_2000_Handler;
        this.host = string;
        this.port = string2;
        this.name = string3;
        try {
            FIPA_2000_HTTP_Connection fIPA_2000_HTTP_Connection = new FIPA_2000_HTTP_Connection(string, string2, string3);
            Thread thread = new Thread(fIPA_2000_HTTP_Connection);
            thread.start();
            fIPA_2000_HTTP_Connection.register(this.msgQ);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.start();
        this.setName(string4);
    }

    public void run() {
        this.processing = true;
        System.out.println("Listening for FIPA 2000 HTTP on port " + String.valueOf(this.port));
        try {
            this.file = new File(SystemProps.getProperty("http_root") + SystemProps.getProperty("in_log"));
            this.log = new FileWriter(this.file, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        while (this.processing) {
            FIPAPerformative fIPAPerformative = this.pop();
            this.file.setLastModified(System.currentTimeMillis());
            try {
                this.debug(fIPAPerformative.getContent());
                FipaMessage fipaMessage = fIPAPerformative.FipaMessage();
                this.handler.handle(fipaMessage);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            FIPA_2000_HTTP_Server.yield();
        }
    }

    public FIPAPerformative pop() {
        FIPAPerformative fIPAPerformative = (FIPAPerformative)this.msgQ.dequeue();
        Date date = new Date();
        int n = date.getYear();
        int n2 = date.getMonth() + 1;
        try {
            this.file.setLastModified(System.currentTimeMillis());
            this.log = new FileWriter(this.file, true);
            this.log.write("Message recieved at : " + date.getDate() + "/" + String.valueOf(n2) + "/" + String.valueOf(n) + " at " + date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds() + "\n\n\n");
            System.out.println("UPDATING FILE TIMESTAMP!!!!!!!");
            this.log.write(fIPAPerformative.toFIPAString());
            this.log.write("\n\n");
            this.log.flush();
            this.file.setLastModified(System.currentTimeMillis());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return fIPAPerformative;
    }

    public String getResponseAddress() {
        return new String("http://" + this.host + ":" + this.port + "/" + this.name);
    }

    public static void main(String[] stringArray) {
        FIPA_2000_HTTP_Server fIPA_2000_HTTP_Server = new FIPA_2000_HTTP_Server(null, "127.0.0.1", "8002", "acc", "test");
    }

    public void debug(String string) {
        System.out.println("HTTP_Server>>" + string);
    }
}

