/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors.graphs;

import java.util.Enumeration;
import java.util.Vector;
import zeus.actors.MsgHandler;
import zeus.actors.ProtocolDb;
import zeus.actors.ProtocolDbResult;
import zeus.actors.rtn.Engine;
import zeus.actors.rtn.Graph;
import zeus.actors.rtn.Node;
import zeus.actors.rtn.util.DStruct;
import zeus.actors.rtn.util.LocalDStruct;
import zeus.concepts.Fact;
import zeus.concepts.Goal;
import zeus.concepts.MessageActionImpl;
import zeus.concepts.MessagePatternImpl;
import zeus.concepts.MessageRuleImpl;
import zeus.util.Core;
import zeus.util.HSet;
import zeus.util.Misc;
import zeus.util.Time;

public class d2
extends Node {
    private String node_desc = "do/find protocols";
    protected static final double DELTA_TIME = 0.25;
    protected Graph[] local_graph = null;
    protected LocalDStruct[] local_dstruct = null;
    protected int reply_needed = 0;

    public final String getDesc() {
        return this.node_desc;
    }

    public final void setDesc(String string) {
        this.node_desc = string;
    }

    public d2() {
        super("d2");
    }

    protected int exec() {
        ProtocolDbResult protocolDbResult;
        Engine engine = this.context.Engine();
        MsgHandler msgHandler = this.context.MsgHandler();
        ProtocolDb protocolDb = this.context.ProtocolDb();
        DStruct dStruct = (DStruct)this.input;
        this.output = this.input;
        Goal goal = (Goal)dStruct.goal.elementAt(0);
        double d = goal.getConfirmTime().getTime();
        this.timeout = d - 0.25;
        if (!Misc.isZero(dStruct.gs.timeout)) {
            this.timeout = Math.min(this.timeout, this.context.now() + dStruct.gs.timeout);
        }
        Time time = new Time(this.timeout);
        for (int i = 0; i < dStruct.goal.size(); ++i) {
            goal = (Goal)dStruct.goal.elementAt(i);
            goal.setReplyTime(time);
        }
        this.msg_wait_key = this.context.newId("ProtocolInitiator");
        Fact fact = goal.getFact();
        Vector vector = protocolDb.getProtocols(fact, Misc.stringArray(dStruct.agents), "Initiator");
        if (vector.isEmpty()) {
            return 2;
        }
        HSet hSet = new HSet();
        for (int i = 0; i < vector.size(); ++i) {
            protocolDbResult = (ProtocolDbResult)vector.elementAt(i);
            hSet.add(protocolDbResult.agent);
        }
        ProtocolDbResult[] protocolDbResultArray = new ProtocolDbResult[hSet.size()];
        Enumeration enumeration = hSet.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            for (int i = 0; i < vector.size(); ++i) {
                protocolDbResult = (ProtocolDbResult)vector.elementAt(i);
                if (!protocolDbResult.agent.equals(string)) continue;
                protocolDbResultArray[n] = protocolDbResult;
                break;
            }
            ++n;
        }
        MessagePatternImpl messagePatternImpl = null;
        MessageActionImpl messageActionImpl = null;
        this.local_graph = new Graph[protocolDbResultArray.length];
        this.local_dstruct = new LocalDStruct[protocolDbResultArray.length];
        for (int i = 0; i < this.local_graph.length; ++i) {
            this.local_graph[i] = this.createGraph(protocolDbResultArray[i].protocol);
            if (this.local_graph[i] != null) {
                this.local_dstruct[i] = new LocalDStruct(protocolDbResultArray[i].agent, dStruct);
                this.local_dstruct[i].any = protocolDbResultArray[i];
                this.local_dstruct[i].key = this.context.newId("local_dstruct");
                messagePatternImpl = new MessagePatternImpl();
                messagePatternImpl.setConstraint("in-reply-to", this.local_dstruct[i].key);
                messageActionImpl = new MessageActionImpl(engine, "continue_dialogue");
                msgHandler.addRule(new MessageRuleImpl(this.local_dstruct[i].key, messagePatternImpl, messageActionImpl));
                this.local_graph[i].run(engine, this, this.local_dstruct[i], this.msg_wait_key);
                ++this.reply_needed;
                continue;
            }
            this.local_dstruct[i] = null;
        }
        return this.reply_needed > 0 ? 3 : 2;
    }

    protected int continue_exec() {
        Core.DEBUG(3, this.getDescription() + " continue_exec");
        DStruct dStruct = (DStruct)this.input;
        this.output = this.input;
        int n = 0;
        block4: for (int i = 0; i < this.local_graph.length; ++i) {
            if (this.local_graph[i] == null) continue;
            switch (this.local_graph[i].getState()) {
                case 2: {
                    if (!dStruct.results.contains(this.local_dstruct[i].result)) {
                        dStruct.results.addElement(this.local_dstruct[i].result);
                    }
                    ++n;
                    continue block4;
                }
                case 3: {
                    ++n;
                }
            }
        }
        Core.DEBUG(3, this.getDescription() + " No Needed: " + this.reply_needed + "  completed: " + n);
        if (this.reply_needed - n == 0) {
            return 1;
        }
        if (this.timeout > this.context.now()) {
            return 3;
        }
        return 1;
    }

    protected void reset() {
        DStruct dStruct = (DStruct)this.input;
        dStruct.results.removeAllElements();
    }
}

