/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors.graphs;

import java.util.Enumeration;
import java.util.Hashtable;
import zeus.actors.MailBox;
import zeus.actors.OrganisationDb;
import zeus.actors.rtn.Node;
import zeus.actors.rtn.util.DStruct;
import zeus.concepts.AbilitySpec;
import zeus.concepts.Goal;
import zeus.concepts.MessageRuleImpl;
import zeus.concepts.OntologyDb;
import zeus.concepts.Performative;
import zeus.util.Assert;
import zeus.util.Core;
import zeus.util.KeyValue;
import zeus.util.Time;

public class d1
extends Node {
    protected static final int NOT_FOUND = 0;
    protected static final int SEARCHING = 1;
    protected static final int NOT_SOUGHT = 2;
    private String node_desc = "do/find sellers; do/find service";

    public final String getDesc() {
        return this.node_desc;
    }

    public final void setDesc(String string) {
        this.node_desc = string;
    }

    public d1() {
        super("d1");
    }

    protected int abilitySought(String string) {
        KeyValue keyValue;
        double d = this.context.now();
        Hashtable hashtable = this.context.queryTable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            keyValue = (KeyValue)hashtable.get(string2);
            if (!(keyValue.value - d >= this.context.getFacilitatorRefresh())) continue;
            hashtable.remove(string2);
            this.context.MsgHandler().removeRule(keyValue.key);
        }
        keyValue = (KeyValue)hashtable.get(string);
        if (keyValue == null) {
            return 2;
        }
        if (keyValue.value < this.context.now()) {
            return 0;
        }
        return 1;
    }

    protected String findAgents(AbilitySpec abilitySpec) {
        if (this.context.facilitators().isEmpty()) {
            return null;
        }
        Hashtable hashtable = this.context.queryTable();
        String string = abilitySpec.getType();
        switch (this.abilitySought(string)) {
            case 0: {
                return null;
            }
            case 1: {
                KeyValue keyValue = (KeyValue)hashtable.get(string);
                return keyValue.key;
            }
            case 2: {
                OntologyDb ontologyDb = this.context.OntologyDb();
                AbilitySpec abilitySpec2 = new AbilitySpec(ontologyDb.getFact(true, string), 0, 0.0);
                MailBox mailBox = this.context.MailBox();
                String string2 = this.context.newId();
                String[] stringArray = new String[]{"type", "inform", "in-reply-to", string2};
                this.context.MsgHandler().addRule(new MessageRuleImpl(string2, stringArray, 0, this.context.Engine(), "agentWithAbilityFound"));
                for (int i = 0; i < this.context.facilitators().size(); ++i) {
                    Performative performative = new Performative("query-ref");
                    performative.setReceiver((String)this.context.facilitators().elementAt(i));
                    performative.setContent("has_ability " + abilitySpec2);
                    performative.setReplyWith(string2);
                    mailBox.sendMsg(performative);
                }
                double d = this.context.now();
                if (!this.context.facilitators().isEmpty()) {
                    d += this.context.getFacilitatorTimeout();
                }
                hashtable.put(string, new KeyValue(string2, d));
                return string2;
            }
        }
        Assert.notNull(null);
        return null;
    }

    protected int exec() {
        OrganisationDb organisationDb = this.context.OrganisationDb();
        DStruct dStruct = (DStruct)this.input;
        Goal goal = (Goal)dStruct.goal.elementAt(0);
        dStruct.agents = organisationDb.anyAgent(goal, dStruct.ignore);
        Core.DEBUG(2, this.getDescription() + " anyAgent: " + dStruct.agents);
        if (dStruct.agents.isEmpty()) {
            this.timeout = this.context.now() + this.context.getFacilitatorTimeout();
            Time time = goal.getConfirmTime();
            if (time != null) {
                this.timeout = Math.min(this.timeout, time.getTime());
            }
            if ((time = goal.getReplyTime()) != null) {
                this.timeout = Math.min(this.timeout, time.getTime());
            }
            this.msg_wait_key = this.findAgents(goal.getAbility());
            Core.DEBUG(2, this.getDescription() + " msg_wait_key: " + this.msg_wait_key);
            return this.msg_wait_key != null ? 3 : 2;
        }
        this.output = dStruct;
        return dStruct.agents.isEmpty() ? 2 : 1;
    }

    protected int continue_exec() {
        OrganisationDb organisationDb = this.context.OrganisationDb();
        DStruct dStruct = (DStruct)this.input;
        Goal goal = (Goal)dStruct.goal.elementAt(0);
        dStruct.agents = organisationDb.anyAgent(goal, dStruct.ignore);
        Core.DEBUG(2, this.getDescription() + " continue anyAgent: " + dStruct.agents);
        this.output = dStruct;
        return dStruct.agents.isEmpty() ? 2 : 1;
    }

    protected void reset() {
        DStruct dStruct = (DStruct)this.input;
        dStruct.agents = null;
    }
}

