/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors.graphs;

import java.util.Vector;
import zeus.actors.rtn.Engine;
import zeus.actors.rtn.Node;
import zeus.actors.rtn.util.DStruct;
import zeus.actors.rtn.util.DelegationStruct;
import zeus.actors.rtn.util.GraphStruct;
import zeus.concepts.BindResults;
import zeus.concepts.Bindings;
import zeus.concepts.Fact;
import zeus.concepts.Goal;
import zeus.util.Core;
import zeus.util.Misc;
import zeus.util.Selector;

public class Sv
extends Node {
    private Vector previous_external = null;
    private Vector previous_goals = null;
    private Vector previous_selection = null;

    public Sv() {
        super("Sv");
    }

    protected int exec() {
        int n;
        Engine engine = this.context.Engine();
        Object[] objectArray = (Object[])this.input;
        GraphStruct graphStruct = ((DStruct)objectArray[0]).gs;
        graphStruct.d_results = new Vector();
        for (int i = 0; i < objectArray.length; ++i) {
            for (n = 0; n < ((DStruct)objectArray[i]).results.size(); ++n) {
                graphStruct.d_results.addElement(((DStruct)objectArray[i]).results.elementAt(n));
            }
        }
        Core.DEBUG(2, "Sv Previous gs " + graphStruct);
        this.previous_goals = Misc.copyVector(graphStruct.goal);
        BindResults bindResults = this.bind(graphStruct.goal, graphStruct.d_results);
        Core.DEBUG(2, "Sv BindResults " + bindResults);
        if (!bindResults.ok) {
            for (n = 0; n < graphStruct.d_results.size(); ++n) {
                DelegationStruct delegationStruct = (DelegationStruct)graphStruct.d_results.elementAt(n);
                engine.continue_dialogue(delegationStruct.key, delegationStruct.agent, "reject-proposal", delegationStruct.goals);
            }
            return 2;
        }
        this.previous_external = graphStruct.external;
        this.previous_selection = Misc.copyVector(graphStruct.selection);
        graphStruct.external = bindResults.external;
        graphStruct.selection = Misc.union(graphStruct.selection, bindResults.selection);
        for (n = 0; n < bindResults.rejection.size(); ++n) {
            DelegationStruct delegationStruct = (DelegationStruct)bindResults.rejection.elementAt(n);
            engine.continue_dialogue(delegationStruct.key, delegationStruct.agent, "reject-proposal", delegationStruct.goals);
        }
        Core.DEBUG(2, "Sv Current gs " + graphStruct);
        this.output = graphStruct;
        return 1;
    }

    protected void reset() {
    }

    protected BindResults bind(Vector vector, Vector vector2) {
        int n;
        Goal goal;
        Core.DEBUG(2, "Entering Sv-bind...");
        Object[] objectArray = new Vector[vector.size()];
        Bindings bindings = new Bindings(this.context.whoami());
        BindResults bindResults = new BindResults();
        bindResults.ok = false;
        for (int i = 0; i < vector.size(); ++i) {
            goal = (Goal)vector.elementAt(i);
            objectArray[i] = this.sortFeasible(goal.getId(), vector2);
            if (!((Vector)objectArray[i]).isEmpty()) continue;
            bindResults.unavailable.addElement(goal);
        }
        if (!bindResults.unavailable.isEmpty()) {
            return bindResults;
        }
        DelegationStruct[] delegationStructArray = new DelegationStruct[vector.size()];
        Selector selector = new Selector(objectArray);
        boolean bl = false;
        while (!bindResults.ok && selector.hasMoreElements()) {
            Object[] objectArray2 = (Object[])selector.nextElement();
            bindings.clear();
            bindResults.ok = true;
            for (n = 0; n < objectArray2.length; ++n) {
                delegationStructArray[n] = (DelegationStruct)objectArray2[n];
                Goal goal2 = (Goal)delegationStructArray[n].goals.elementAt(0);
                goal = (Goal)vector.elementAt(n);
                Fact fact = goal.getFact();
                Fact fact2 = goal2.getFact();
                bindResults.ok = fact2.unifiesWith(fact, bindings);
                if (!bindResults.ok) break;
            }
            Core.DEBUG(2, "Sv Current selection ... ");
            Core.DEBUG(2, delegationStructArray);
            if (!bindResults.ok) continue;
            for (n = 0; n < objectArray2.length; ++n) {
                delegationStructArray[n] = (DelegationStruct)objectArray2[n];
                bindResults.selection.addElement(delegationStructArray[n]);
                for (int i = 0; i < ((Vector)objectArray[n]).size(); ++i) {
                    if (((Vector)objectArray[n]).elementAt(i) == delegationStructArray[n]) continue;
                    bindResults.rejection.addElement(((Vector)objectArray[n]).elementAt(i));
                }
            }
        }
        if (!bindResults.ok) {
            for (n = 0; n < vector.size(); ++n) {
                goal = (Goal)vector.elementAt(n);
                bindResults.unavailable.addElement(goal);
            }
        }
        Core.DEBUG(2, "++++++ Sv-Bind goals\n" + vector);
        Core.DEBUG(2, "++++++ Sv-Bind bindings\n" + bindings);
        Core.DEBUG(2, "++++++ Sv-Bind result\n" + bindResults + "\n");
        return bindResults;
    }

    protected Vector sortFeasible(String string, Vector vector) {
        Goal goal;
        DelegationStruct delegationStruct;
        int n;
        Core.DEBUG(2, "Sv-sortFeasible input " + string + "\n" + vector);
        Vector<DelegationStruct> vector2 = new Vector<DelegationStruct>();
        for (n = 0; n < vector.size(); ++n) {
            delegationStruct = (DelegationStruct)vector.elementAt(n);
            goal = (Goal)delegationStruct.goals.elementAt(0);
            if (!string.equals(goal.getId())) continue;
            vector2.addElement(delegationStruct);
        }
        Core.DEBUG(2, "Sv-sortFeasible reduced " + string + "\n" + vector2);
        n = 1;
        while (n != 0) {
            n = 0;
            for (int i = 0; i < vector2.size() - 1; ++i) {
                delegationStruct = (DelegationStruct)vector2.elementAt(i);
                goal = (Goal)delegationStruct.goals.elementAt(0);
                delegationStruct = (DelegationStruct)vector2.elementAt(i + 1);
                Goal goal2 = (Goal)delegationStruct.goals.elementAt(0);
                if (!(goal.getCost() > goal2.getCost())) continue;
                Object e = vector2.elementAt(i);
                vector2.setElementAt((DelegationStruct)vector2.elementAt(i + 1), i);
                vector2.setElementAt((DelegationStruct)e, i + 1);
                n = 1;
            }
        }
        Core.DEBUG(2, "Sv-sortFeasible results " + string + "\n" + vector2);
        return vector2;
    }
}

