/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors.graphs;

import java.util.Vector;
import zeus.actors.ProtocolDbResult;
import zeus.actors.rtn.util.DelegationStruct;
import zeus.actors.rtn.util.StrategyEvaluator;
import zeus.concepts.Goal;
import zeus.util.Core;

public class SimpleRespondentEvaluator
extends StrategyEvaluator {
    protected static final double round_time = 0.1;
    double max;
    double min;
    double noquibble;
    double cost = 0.0;
    double price = 0.0;
    double offer = 0.0;
    double rate;
    double start_time = 0.0;
    double end_time = 0.0;

    public int evaluateFirst(Vector vector, ProtocolDbResult protocolDbResult) {
        Core.DEBUG(3, "SimpleRespondentEvaluator:EvaluateFirst entry\n" + vector + "\n" + protocolDbResult);
        this.goals = vector;
        this.protocolInfo = protocolDbResult;
        this.max = this.getDoubleParam("max.percent", 120.0) / 100.0;
        this.min = this.getDoubleParam("min.percent", 103.0) / 100.0;
        this.noquibble = this.getDoubleParam("noquibble.range", 1.0);
        Goal goal = (Goal)vector.elementAt(0);
        Core.DEBUG(3, "SimpleRespondentEvaluator:EvaluateFirst g = " + goal);
        this.end_time = goal.getReplyTime().getTime() - 0.1;
        this.start_time = this.context.now();
        this.cost = goal.getCost();
        this.max *= this.cost;
        this.min *= this.cost;
        double d = this.getDoubleParam("reservation.price", Double.MIN_VALUE);
        this.min = Math.max(this.min, d);
        this.price = (int)this.max;
        this.rate = Math.log(this.max / this.min) / (this.end_time - this.start_time);
        this.price = Math.max(this.price, 0.0);
        goal.setCost(this.price);
        Core.DEBUG(3, this.context.whoami() + " EvaluateFirst: " + this.start_time + ", " + this.end_time + ", " + this.price);
        return 3;
    }

    public int evaluateNext(DelegationStruct delegationStruct) {
        Core.DEBUG(3, "SimpleRespondentEvaluator:EvaluateNext: " + delegationStruct);
        this.goals = delegationStruct.goals;
        if (delegationStruct.msg_type.equals("accept-proposal")) {
            System.out.println("OK 0");
            return 0;
        }
        if (delegationStruct.msg_type.equals("reject-proposal")) {
            System.out.println("Fail 0");
            return 1;
        }
        Goal goal = (Goal)delegationStruct.goals.elementAt(0);
        this.offer = goal.getCost();
        double d = this.context.now() - this.start_time;
        System.out.println("dt = " + d + " rate = " + this.rate);
        this.price = (int)(this.max * Math.exp(-1.0 * this.rate * d));
        Core.DEBUG(3, this.context.whoami() + " EvaluateNext: " + this.offer + " " + this.price);
        if (this.price < this.min) {
            System.out.println("Fail 1");
            return 1;
        }
        if (this.offer >= this.price) {
            this.price = this.offer + 1.0;
        }
        this.price = Math.max(this.price, 0.0);
        goal.setCost(this.price);
        return 3;
    }
}

