/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors.graphs;

import java.util.Vector;
import zeus.actors.ProtocolDbResult;
import zeus.actors.rtn.util.DelegationStruct;
import zeus.actors.rtn.util.StrategyEvaluator;
import zeus.concepts.Goal;

public class LinearRespondentEvaluator
extends StrategyEvaluator {
    boolean first_response = true;
    double min;
    double max;
    double noquibble;
    double price = 0.0;
    double min_price = 0.0;
    double max_price = 0.0;
    double offer = 0.0;
    double start_time = 0.0;
    double end_time = 0.0;
    double actual_cost = 0.0;
    double reserve_price = 0.0;
    double default_step = 0.0;
    double step = 0.0;
    double dt = 0.0;

    public int evaluateFirst(Vector vector, ProtocolDbResult protocolDbResult) {
        this.goals = vector;
        this.protocolInfo = protocolDbResult;
        this.max = this.getDoubleParam("max.percent", 120.0) / 100.0;
        this.min = this.getDoubleParam("min.percent", 103.0) / 100.0;
        this.noquibble = this.getDoubleParam("noquibble.range", 1.0);
        this.default_step = this.getDoubleParam("step.default", 0.2);
        this.reserve_price = this.getDoubleParam("reservation.price", Double.MIN_VALUE);
        Goal goal = (Goal)vector.elementAt(0);
        this.actual_cost = goal.getCost();
        this.start_time = this.context.now();
        this.end_time = goal.getReplyTime().getTime();
        this.max_price = this.max * Math.max(this.reserve_price, this.actual_cost);
        this.min_price = Math.max(this.min * this.actual_cost, this.reserve_price);
        this.price = this.max_price;
        goal.setCost(this.price);
        return 3;
    }

    public int evaluateNext(DelegationStruct delegationStruct) {
        this.goals = delegationStruct.goals;
        Goal goal = (Goal)delegationStruct.goals.elementAt(0);
        if (delegationStruct.msg_type.equals("accept-proposal")) {
            return 0;
        }
        if (delegationStruct.msg_type.equals("reject-proposal")) {
            return 1;
        }
        this.offer = goal.getCost();
        double d = this.context.now();
        if (this.first_response) {
            this.first_response = false;
            this.dt = d - this.start_time;
            this.end_time -= this.dt;
            this.step = (this.max_price - this.min_price) * this.dt / (this.end_time - this.start_time);
            this.step = Math.max(this.step, this.default_step);
        }
        this.price -= this.step;
        this.price = Math.max(this.price, 0.0);
        if (this.price < this.min_price) {
            this.price = this.min_price;
        }
        if (this.offer >= this.price) {
            this.price = this.offer + this.step;
        }
        goal.setCost(this.price);
        return 3;
    }
}

