/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors.graphs;

import java.util.Vector;
import zeus.actors.ProtocolDbResult;
import zeus.actors.rtn.util.DelegationStruct;
import zeus.actors.rtn.util.StrategyEvaluator;
import zeus.concepts.Goal;

public class LinearInitiatorEvaluator
extends StrategyEvaluator {
    boolean first_response = true;
    double min;
    double max;
    double noquibble;
    double price = 0.0;
    double min_price = 0.0;
    double max_price = 0.0;
    double offer = 0.0;
    double start_time = 0.0;
    double end_time = 0.0;
    double expected_cost = 0.0;
    double reserve_price = 0.0;
    double default_step = 0.0;
    double step = 0.0;
    double dt = 0.0;

    public int evaluateFirst(Vector vector, ProtocolDbResult protocolDbResult) {
        this.goals = vector;
        this.protocolInfo = protocolDbResult;
        this.min = this.getDoubleParam("min.percent", 80.0) / 100.0;
        this.max = this.getDoubleParam("max.percent", 120.0) / 100.0;
        this.noquibble = this.getDoubleParam("noquibble.range", 2.0);
        this.default_step = this.getDoubleParam("step.default", 0.2);
        this.reserve_price = this.getDoubleParam("reservation.price", Double.MAX_VALUE);
        Goal goal = (Goal)vector.elementAt(0);
        this.expected_cost = goal.getCost();
        this.start_time = this.context.now();
        this.end_time = goal.getReplyTime().getTime();
        goal.setCost(0.0);
        return 3;
    }

    public int evaluateNext(DelegationStruct delegationStruct) {
        this.goals = delegationStruct.goals;
        if (!delegationStruct.msg_type.equals("propose")) {
            return 1;
        }
        Goal goal = (Goal)delegationStruct.goals.elementAt(0);
        this.offer = goal.getCost();
        double d = this.context.now();
        if (this.first_response) {
            this.first_response = false;
            this.dt = d - this.start_time;
            this.end_time -= this.dt;
            this.expected_cost = Math.max(this.offer, this.expected_cost);
            this.min_price = this.min * Math.min(this.reserve_price, this.expected_cost);
            this.max_price = Math.min(this.max * this.expected_cost, this.reserve_price);
            this.price = this.min_price;
            this.step = (this.max_price - this.min_price) * this.dt / (this.end_time - this.start_time);
            this.step = Math.max(this.step, this.default_step);
        }
        if (this.offer < this.price + this.noquibble) {
            return 0;
        }
        if (!this.first_response) {
            this.price += this.step;
        }
        if (this.price < this.min_price) {
            return 1;
        }
        if (this.offer < this.price + this.noquibble) {
            return 0;
        }
        if (d + this.dt >= this.end_time) {
            if (this.offer < this.max_price) {
                return 0;
            }
            return 1;
        }
        goal.setCost(this.price);
        return 3;
    }
}

