/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors;

import zeus.actors.AgentContext;
import zeus.concepts.Fact;
import zeus.util.Assert;

public abstract class ZeusTask
extends Thread {
    protected Fact[][] inputArgs = null;
    protected Fact[][] outputArgs = null;
    protected Fact[] expInputArgs = null;
    protected Fact[] expOutputArgs = null;
    protected String[] media = null;
    private boolean isFinished = false;
    private boolean isRunning = false;
    private boolean isAborted = false;
    protected String desired_by;
    protected AgentContext context = null;

    protected ZeusTask() {
        this.setPriority(5);
        this.setName("ZeusTask");
    }

    public void setMedia(String[] stringArray) {
        this.media = stringArray;
    }

    public void run() {
        this.isRunning = true;
        this.exec();
        this.isRunning = false;
        this.isFinished = true;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public boolean isAborted() {
        return this.isAborted;
    }

    public void abort() {
        this.isAborted = true;
    }

    public void setContext(AgentContext agentContext) {
        this.context = agentContext;
    }

    public void setInputArgs(Fact[][] factArray) {
        Assert.notNull(factArray);
        this.inputArgs = factArray;
    }

    public void setExpectedOutputArgs(Fact[] factArray) {
        Assert.notNull(factArray);
        this.expOutputArgs = factArray;
    }

    public void setExpectedInputArgs(Fact[] factArray) {
        this.expInputArgs = factArray;
    }

    public void setOutputArgs(Fact[] factArray) {
        Assert.notNull(factArray);
        if (this.outputArgs == null) {
            this.outputArgs = new Fact[factArray.length][0];
        }
        this.outputArgs[0] = factArray;
    }

    public void setOutputArgs(Fact[][] factArray) {
        Assert.notNull(factArray);
        this.outputArgs = factArray;
    }

    public Fact[][] getInputArgs() {
        return this.inputArgs;
    }

    public Fact[] getExpectedOutputArgs() {
        return this.expOutputArgs;
    }

    public Fact[] getExpectedInputArgs() {
        return this.expInputArgs;
    }

    public Fact[][] getOutputArgs() {
        if (!this.isFinished) {
            return null;
        }
        return this.outputArgs;
    }

    public void setDesiredBy(String string) {
        Assert.notNull(string);
        this.desired_by = string;
    }

    public String getDesiredBy() {
        return this.desired_by;
    }

    protected abstract void exec();

    public String getDescription() {
        return "no description";
    }

    public String getInstanceDetails() {
        return null;
    }
}

