/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors;

import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Vector;
import zeus.actors.AgentContext;
import zeus.actors.ExecutionMonitor;
import zeus.actors.ExternalDb;
import zeus.actors.InTray;
import zeus.actors.MailBox;
import zeus.actors.MsgHandler;
import zeus.actors.OrganisationDb;
import zeus.actors.Planner;
import zeus.actors.ProtocolDb;
import zeus.actors.ResourceDb;
import zeus.actors.TaskDb;
import zeus.actors.factories.IIOP_Z_HTTP_TransportFactory;
import zeus.actors.factories.TransportFactory;
import zeus.actors.rtn.Engine;
import zeus.agents.BasicAgent;
import zeus.agents.BasicAgentUI;
import zeus.agents.ZeusExternal;
import zeus.concepts.Address;
import zeus.concepts.AddressBook;
import zeus.concepts.OntologyDb;
import zeus.rete.ReteEngine;
import zeus.util.Assert;
import zeus.util.Clock;
import zeus.util.GenSym;
import zeus.util.SystemProps;
import zeus.util.Time;

public class ZeusAgentContext
implements AgentContext {
    public boolean share_plan;
    public boolean execute_earliest;
    public double registration_timeout;
    public double facilitator_timeout;
    public double address_timeout;
    public double accept_timeout;
    public double addressbook_refresh;
    public double facilitator_refresh;
    public double replan_period;
    protected Vector nameservers = new Vector();
    protected Vector facilitators = new Vector();
    protected AddressBook addressBook = null;
    protected MailBox mbox = null;
    protected MsgHandler msgHandler = null;
    protected ReteEngine reteEngine = null;
    protected Engine engine = null;
    protected ExecutionMonitor monitor = null;
    protected Planner planner = null;
    protected OrganisationDb organisationDb = null;
    protected TaskDb taskDb = null;
    protected ResourceDb resourceDb = null;
    protected OntologyDb ontologyDb = null;
    protected ExternalDb externalDb = null;
    protected ZeusExternal zeusExternal = null;
    protected BasicAgent agent = null;
    protected BasicAgentUI agentUI = null;
    protected ProtocolDb protocolDb = null;
    protected GenSym genSym = null;
    protected Clock clock = null;
    protected String name = null;
    protected String type = null;
    protected Hashtable queryTable = new Hashtable();

    public ZeusAgentContext(String string, String string2) {
        Assert.notNull(string);
        Assert.notNull(string2);
        this.name = string;
        this.type = string2;
        this.share_plan = SystemProps.getState("share.plan", true);
        this.execute_earliest = SystemProps.getState("execute.earliest", true);
        this.registration_timeout = SystemProps.getDouble("registration.timeout", 3.0);
        this.facilitator_timeout = SystemProps.getDouble("facilitator.timeout", 0.5);
        this.address_timeout = SystemProps.getDouble("address.timeout", 0.5);
        this.accept_timeout = SystemProps.getDouble("accept.timeout", 1.5);
        this.addressbook_refresh = SystemProps.getDouble("addressbook.refresh", 5.0);
        this.facilitator_refresh = SystemProps.getDouble("facilitator.refresh", 5.0);
        this.replan_period = SystemProps.getDouble("replan.period", 2.0);
        this.genSym = new GenSym(string, true);
    }

    public boolean getSharePlan() {
        return this.share_plan;
    }

    public boolean getExecuteEarliest() {
        return this.execute_earliest;
    }

    public double getAddressBookRefresh() {
        return this.addressbook_refresh;
    }

    public double getAddressTimeout() {
        return this.address_timeout;
    }

    public double getReplanPeriod() {
        return this.replan_period;
    }

    public double getRegistrationTimeout() {
        return this.registration_timeout;
    }

    public double getFacilitatorTimeout() {
        return this.facilitator_timeout;
    }

    public double getAcceptTimeout() {
        return this.accept_timeout;
    }

    public double getFacilitatorRefresh() {
        return this.facilitator_refresh;
    }

    public void setSharePlan(boolean bl) {
        this.share_plan = bl;
    }

    public void setExecuteEarliest(boolean bl) {
        this.execute_earliest = bl;
    }

    public void setAddressBookRefresh(double d) {
        this.addressbook_refresh = d;
    }

    public void setAddressTimeout(double d) {
        this.address_timeout = d;
    }

    public void setReplanPeriod(double d) {
        this.replan_period = d;
    }

    public void setRegistrationTimeout(double d) {
        this.registration_timeout = d;
    }

    public void setFacilitatorTimeout(double d) {
        this.facilitator_timeout = d;
    }

    public void setAcceptTimeout(double d) {
        this.accept_timeout = d;
    }

    public void setFacilitatorRefresh(double d) {
        this.facilitator_refresh = d;
    }

    public void setFacilitators(Vector vector) {
        Assert.notNull(vector);
        this.facilitators.removeAllElements();
        for (int i = 0; i < vector.size(); ++i) {
            this.addFacilitator((String)vector.elementAt(i));
        }
    }

    public void addFacilitator(String string) {
        Assert.notNull(string);
        if (!this.facilitators.contains(string)) {
            this.facilitators.addElement(string);
        }
    }

    public void removeFacilitator(String string) {
        Assert.notNull(string);
        this.facilitators.removeElement(string);
    }

    public void setNameservers(Vector vector) {
        Assert.notNull(vector);
        this.nameservers.removeAllElements();
        for (int i = 0; i < vector.size(); ++i) {
            this.addNameserver((Address)vector.elementAt(i));
        }
    }

    public void addNameserver(Address address) {
        Assert.notNull(address);
        if (!this.nameservers.contains(address)) {
            this.nameservers.addElement(address);
        }
    }

    public void removeNameserver(String string) {
        Assert.notNull(string);
        this.nameservers.removeElement(string);
    }

    public void set(AddressBook addressBook) {
        Assert.notNull(addressBook);
        this.addressBook = addressBook;
    }

    public void set(ProtocolDb protocolDb) {
        Assert.notNull(protocolDb);
        this.protocolDb = protocolDb;
    }

    public void set(MailBox mailBox) {
        Assert.notNull(mailBox);
        this.mbox = mailBox;
    }

    public void set(MsgHandler msgHandler) {
        Assert.notNull(msgHandler);
        this.msgHandler = msgHandler;
    }

    public void set(Engine engine) {
        Assert.notNull(engine);
        this.engine = engine;
    }

    public void set(ReteEngine reteEngine) {
        Assert.notNull(reteEngine);
        this.reteEngine = reteEngine;
    }

    public void set(ExecutionMonitor executionMonitor) {
        Assert.notNull(executionMonitor);
        this.monitor = executionMonitor;
    }

    public void set(Planner planner) {
        Assert.notNull(planner);
        this.planner = planner;
    }

    public void set(OrganisationDb organisationDb) {
        Assert.notNull(organisationDb);
        this.organisationDb = organisationDb;
    }

    public void set(TaskDb taskDb) {
        Assert.notNull(taskDb);
        this.taskDb = taskDb;
    }

    public void set(ResourceDb resourceDb) {
        Assert.notNull(resourceDb);
        this.resourceDb = resourceDb;
    }

    public void set(OntologyDb ontologyDb) {
        Assert.notNull(ontologyDb);
        this.ontologyDb = ontologyDb;
    }

    public void set(BasicAgent basicAgent) {
        Assert.notNull(basicAgent);
        this.agent = basicAgent;
    }

    public void set(BasicAgentUI basicAgentUI) {
        Assert.notNull(basicAgentUI);
        this.agentUI = basicAgentUI;
    }

    public void set(ZeusExternal zeusExternal) {
        Assert.notNull(zeusExternal);
        this.zeusExternal = zeusExternal;
    }

    public void set(ExternalDb externalDb) {
        Assert.notNull(externalDb);
        this.externalDb = externalDb;
    }

    public void set(Clock clock) {
        Assert.notNull(clock);
        this.clock = clock;
    }

    public double now() {
        return this.clock != null ? this.clock.currentTime().getTime() : -1.0;
    }

    public Time currentTime() {
        return this.clock != null ? this.clock.currentTime() : null;
    }

    public Time time(long l) {
        return this.clock != null ? this.clock.time(l) : null;
    }

    public long getClockStep() {
        return this.clock != null ? this.clock.getIncrement() : -1L;
    }

    public String newId() {
        return this.genSym.newId();
    }

    public String newId(String string) {
        return this.genSym.newId(string);
    }

    public String whatami() {
        return this.type;
    }

    public String whoami() {
        return this.name;
    }

    public Hashtable queryTable() {
        return this.queryTable;
    }

    public Vector facilitators() {
        return this.facilitators;
    }

    public Vector nameservers() {
        return this.nameservers;
    }

    public AddressBook AddressBook() {
        return this.addressBook;
    }

    public MailBox MailBox() {
        return this.mbox;
    }

    public MsgHandler MsgHandler() {
        return this.msgHandler;
    }

    public ReteEngine ReteEngine() {
        return this.reteEngine;
    }

    public Engine Engine() {
        return this.engine;
    }

    public ExecutionMonitor ExecutionMonitor() {
        return this.monitor;
    }

    public Planner Planner() {
        return this.planner;
    }

    public OrganisationDb OrganisationDb() {
        return this.organisationDb;
    }

    public TaskDb TaskDb() {
        return this.taskDb;
    }

    public ResourceDb ResourceDb() {
        return this.resourceDb;
    }

    public OntologyDb OntologyDb() {
        return this.ontologyDb;
    }

    public ExternalDb ExternalDb() {
        return this.externalDb;
    }

    public ProtocolDb ProtocolDb() {
        return this.protocolDb;
    }

    public ZeusExternal ZeusExternal() {
        return this.zeusExternal;
    }

    public BasicAgentUI AgentUI() {
        return this.agentUI;
    }

    public BasicAgent Agent() {
        return this.agent;
    }

    public GenSym GenSym() {
        return this.genSym;
    }

    public Clock Clock() {
        return this.clock;
    }

    public Hashtable getQueryTable() {
        return this.queryTable;
    }

    public Vector getFacilitators() {
        return this.facilitators;
    }

    public Vector getNameservers() {
        return this.nameservers;
    }

    public AddressBook getAddressBook() {
        return this.addressBook;
    }

    public MailBox getMailBox() {
        return this.mbox;
    }

    public MsgHandler getMsgHandler() {
        return this.msgHandler;
    }

    public ReteEngine getReteEngine() {
        return this.reteEngine;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public ExecutionMonitor getExecutionMonitor() {
        return this.monitor;
    }

    public Planner getPlanner() {
        return this.planner;
    }

    public OrganisationDb getOrganisationDb() {
        return this.organisationDb;
    }

    public TaskDb getTaskDb() {
        return this.taskDb;
    }

    public ResourceDb getResourceDb() {
        return this.resourceDb;
    }

    public OntologyDb getOntologyDb() {
        return this.ontologyDb;
    }

    public ExternalDb getExternalDb() {
        return this.externalDb;
    }

    public ProtocolDb getProtocolDb() {
        return this.protocolDb;
    }

    public ZeusExternal getZeusExternal() {
        return this.zeusExternal;
    }

    public BasicAgentUI getAgentUI() {
        return this.agentUI;
    }

    public BasicAgent getAgent() {
        return this.agent;
    }

    public GenSym getGenSym() {
        return this.genSym;
    }

    public Clock getClock() {
        return this.clock;
    }

    public TransportFactory getTransportFactory() {
        IIOP_Z_HTTP_TransportFactory iIOP_Z_HTTP_TransportFactory = new IIOP_Z_HTTP_TransportFactory();
        iIOP_Z_HTTP_TransportFactory.setContext(this);
        return iIOP_Z_HTTP_TransportFactory;
    }

    public InTray getInTray() {
        return this.mbox.getInTray();
    }

    public String whereAmI() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            String string = inetAddress.getHostAddress();
            return string;
        }
        catch (Exception exception) {
            return new String("host.discovery.failed.here");
        }
    }
}

