/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import zeus.actors.AgentContext;
import zeus.actors.Connection;
import zeus.actors.InTray;
import zeus.actors.MailBox;
import zeus.actors.MsgHandler;
import zeus.concepts.Address;
import zeus.concepts.Performative;
import zeus.concepts.ZeusAddress;
import zeus.util.Assert;
import zeus.util.Core;
import zeus.util.Queue;
import zeus.util.Time;

public class Server
extends Thread
implements InTray {
    public static final int MAX_CONNECTIONS = 1;
    public static final int MAX_QUEUE_LENGTH = 100;
    public static final int DEFAULT_PORT_MIN = 6700;
    public static final int DEFAULT_PORT_MAX = 7800;
    protected ServerSocket listenSocket;
    protected Address address;
    protected int connection_count = 0;
    protected boolean processing;
    private AgentContext context = null;
    protected long timeout = -1L;
    protected Queue inMail;
    protected MailBox mbox;
    protected MsgHandler msgHandler = null;

    public Server() {
    }

    public Server(AgentContext agentContext, MailBox mailBox, Queue queue) {
        Assert.notNull(agentContext);
        this.context = agentContext;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            String string = inetAddress.getHostAddress();
            Core.DEBUG(4, "Ip Address is: " + inetAddress);
            boolean bl = false;
            for (int i = 6700; !bl && i < 7800; ++i) {
                try {
                    this.listenSocket = new ServerSocket(i, 100);
                    bl = true;
                    this.address = new ZeusAddress(agentContext.whoami(), string, i, agentContext.whatami());
                    agentContext.AddressBook().add(this.address);
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!bl) {
                System.err.println("Cannot get a port for listening");
            }
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Cannot get local host IP address");
        }
        catch (IOException iOException) {
            System.err.println("Cannot get a port for listening");
            iOException.printStackTrace();
        }
        this.mbox = mailBox;
        this.setName("Normal server");
        this.start();
    }

    public AgentContext getAgentContext() {
        return this.mbox.getAgentContext();
    }

    public synchronized void updateCount(int n) {
        this.debug("update count");
        this.connection_count += n;
        if (n < 0) {
            this.debug("notifying");
            this.notify();
        }
    }

    public void stopProcessing() {
        this.processing = false;
    }

    public void lowerStatus() {
        this.setPriority(3);
        this.timeout = 1000L;
    }

    public void normalStatus() {
        this.setPriority(5);
        this.timeout = 1000L;
    }

    public void run() {
        this.processing = true;
        while (this.processing) {
            this.debug("alive");
            try {
                Socket socket = null;
                socket = this.listenSocket.accept();
                new Connection(socket, this, this.context.GenSym().newId());
                Server.yield();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Core.DEBUG(3, "Exception listening for connections: " + exception);
            }
            catch (Error error) {
                error.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    protected void finalize() {
        try {
            if (this.listenSocket != null) {
                this.listenSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Address getAddress() {
        return this.address;
    }

    public void newMsg(Performative performative) {
        AgentContext agentContext = this.getAgentContext();
        this.debug("1");
        Time time = agentContext.currentTime();
        if (time != null) {
            performative.setReceiveTime(time);
        }
        this.debug("2");
        Address address = performative.getAddress();
        if (address != null && !address.getType().equalsIgnoreCase("FORWARD")) {
            agentContext.AddressBook().add(address);
        }
        this.debug("3");
        if (this.msgHandler == null) {
            this.msgHandler = agentContext.getMsgHandler();
        }
        Core.DEBUG(3, "putting message from " + performative.getSender() + " on handler queue");
        this.debug("4");
        this.msgHandler.processMessage(performative);
        this.debug("5");
        this.mbox.notifyMonitors(performative, 0);
        this.debug("6");
    }

    public String getResponseAddress() {
        return ((Object)this.address).toString();
    }

    public void debug(String string) {
        System.out.println("Server>> " + string);
    }
}

