/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.actors.AgentContext;
import zeus.actors.DataRec;
import zeus.actors.ExternalDb;
import zeus.actors.PlanRecord;
import zeus.actors.Planner;
import zeus.actors.event.FactEvent;
import zeus.actors.event.FactMonitor;
import zeus.concepts.Bindings;
import zeus.concepts.Fact;
import zeus.concepts.Goal;
import zeus.concepts.OntologyDb;
import zeus.concepts.PrimitiveTask;
import zeus.concepts.ResourceItem;
import zeus.concepts.fn.PrimitiveNumericFn;
import zeus.util.Core;
import zeus.util.GenSym;
import zeus.util.HSet;

public class ResourceDb
extends Hashtable {
    private HSet[] eventMonitor = new HSet[4];
    private static final int ADD = 0;
    private static final int MODIFY = 1;
    private static final int DELETE = 2;
    private static final int ACCESS = 3;
    protected AgentContext context = null;
    protected String name = null;
    protected Planner planner = null;
    protected OntologyDb ontologyDb = null;
    protected GenSym gensym = null;

    public ResourceDb() {
        for (int i = 0; i < this.eventMonitor.length; ++i) {
            this.eventMonitor[i] = new HSet();
        }
    }

    public ResourceDb(AgentContext agentContext) {
        this.context = agentContext;
        this.name = agentContext.whoami();
        this.gensym = agentContext.GenSym();
        this.planner = agentContext.getPlanner();
        this.ontologyDb = agentContext.getOntologyDb();
        agentContext.set(this);
        for (int i = 0; i < this.eventMonitor.length; ++i) {
            this.eventMonitor[i] = new HSet();
        }
    }

    public void setPlanner(Planner planner) {
        this.planner = planner;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setGenSym(GenSym genSym) {
        this.gensym = genSym;
    }

    public void setOntologyDb(OntologyDb ontologyDb) {
        this.ontologyDb = ontologyDb;
    }

    public boolean isNameSet() {
        return this.name != null;
    }

    public boolean isGenSymSet() {
        return this.gensym != null;
    }

    public boolean isPlannerSet() {
        return this.planner != null;
    }

    public boolean isOntologyDbSet() {
        return this.ontologyDb != null;
    }

    public boolean isContextSet() {
        return this.context != null;
    }

    public boolean isSet() {
        if (this.isContextSet()) {
            return true;
        }
        if (!this.isGenSymSet()) {
            System.out.println("gensym not set");
            return false;
        }
        if (!this.isPlannerSet()) {
            System.out.println("planner not set");
            return false;
        }
        if (!this.isOntologyDbSet()) {
            System.out.println("ontologydb not set");
            return false;
        }
        if (!this.isNameSet()) {
            System.out.println("name not set");
            return false;
        }
        return true;
    }

    public AgentContext getAgentContext() {
        return this.context;
    }

    public synchronized ResourceItem add(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.add((Fact)vector.elementAt(i));
        }
        return null;
    }

    public synchronized ResourceItem add(Fact[] factArray) {
        for (int i = 0; i < factArray.length; ++i) {
            this.add(factArray[i]);
        }
        return null;
    }

    public synchronized ResourceItem add(Fact fact) {
        ResourceItem resourceItem;
        String string = fact.getType();
        Vector<ResourceItem> vector = (Vector<ResourceItem>)this.get(string);
        if (vector == null) {
            vector = new Vector<ResourceItem>();
            this.put(string, vector);
        }
        if (string.equals("Money") && !vector.isEmpty()) {
            for (int i = 0; i < vector.size(); ++i) {
                resourceItem = (ResourceItem)vector.elementAt(i);
                this.notifyMonitors(resourceItem, 3);
                if (resourceItem.isReserved()) continue;
                Fact fact2 = resourceItem.getFact();
                fact2.resolve(new Bindings(this.name));
                PrimitiveNumericFn primitiveNumericFn = (PrimitiveNumericFn)((Object)fact2.getFn("amount"));
                double d = primitiveNumericFn.doubleValue();
                fact.resolve(new Bindings(this.name));
                primitiveNumericFn = (PrimitiveNumericFn)((Object)fact.getFn("amount"));
                double d3 = primitiveNumericFn.doubleValue();
                double d4 = d + d3;
                if (d4 == 0.0) {
                    vector.removeElementAt(i--);
                    resourceItem.deleted();
                    this.notifyMonitors(resourceItem, 2);
                    if (vector.isEmpty()) {
                        this.remove(string);
                    }
                    return null;
                }
                vector.removeElementAt(i--);
                resourceItem.deleted();
                this.notifyMonitors(resourceItem, 2);
                fact2.setValue("amount", d4);
                fact2.resolve(new Bindings(this.name));
                vector.addElement(resourceItem);
                this.notifyMonitors(resourceItem, 0);
                return resourceItem;
            }
        }
        resourceItem = new ResourceItem(fact);
        vector.addElement(resourceItem);
        this.notifyMonitors(resourceItem, 0);
        return resourceItem;
    }

    synchronized void replaceOrAdd(Fact fact) {
        ExternalDb externalDb = this.context.ExternalDb();
        if (externalDb == null || !externalDb.put(fact)) {
            this.add(fact);
        }
    }

    public synchronized void del(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.del((Fact)vector.elementAt(i));
        }
    }

    public synchronized void del(Fact[] factArray) {
        for (int i = 0; i < factArray.length; ++i) {
            this.del(factArray[i]);
        }
    }

    public synchronized void del(Fact fact) {
        String string = fact.getType();
        Vector vector = (Vector)this.get(string);
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            ResourceItem resourceItem = (ResourceItem)vector.elementAt(i);
            Fact fact2 = resourceItem.getFact();
            this.notifyMonitors(resourceItem, 3);
            if (!fact2.equals(fact)) continue;
            vector.removeElementAt(i--);
            resourceItem.deleted();
            this.notifyMonitors(resourceItem, 2);
        }
        if (vector.isEmpty()) {
            this.remove(string);
        }
    }

    public synchronized void modify(Fact fact, Fact fact2) {
        this.del(fact);
        this.add(fact2);
    }

    public void free(DataRec dataRec) {
        if (dataRec == null) {
            return;
        }
        Vector vector = dataRec.available();
        ExternalDb externalDb = this.context.ExternalDb();
        for (int i = 0; i < vector.size(); ++i) {
            ResourceItem resourceItem = (ResourceItem)vector.elementAt(i);
            resourceItem.cancelReservation(dataRec);
            Fact fact = resourceItem.getFact();
            if (externalDb == null || resourceItem.isReserved() || !externalDb.put(fact)) continue;
            vector.removeElementAt(i--);
            resourceItem.deleted();
            this.notifyMonitors(resourceItem, 2);
        }
        dataRec.free();
    }

    public void consume(DataRec dataRec) {
        if (dataRec == null) {
            return;
        }
        Vector vector = dataRec.available();
        block5: for (int i = 0; i < vector.size(); ++i) {
            ResourceItem resourceItem = (ResourceItem)vector.elementAt(i);
            Fact fact = resourceItem.getFact();
            this.notifyMonitors(resourceItem, 3);
            this.notifyMonitors(resourceItem, 2);
            Vector vector2 = (Vector)this.get(fact.getType());
            switch (resourceItem.consumed(dataRec)) {
                case 0: {
                    this.notifyMonitors(resourceItem, 0);
                    continue block5;
                }
                case 1: {
                    this.notifyMonitors(resourceItem, 0);
                    continue block5;
                }
                case 2: {
                    vector2.removeElement(resourceItem);
                    if (!vector2.isEmpty()) continue block5;
                    this.remove(resourceItem.getFact().getType());
                }
            }
        }
    }

    public int findAll(PlanRecord planRecord, int n, int n2) {
        Core.ERROR(n2 > 0, 1001, (Object)this);
        DataRec dataRec = planRecord.getDatarec(n);
        int n3 = planRecord.getStartTime();
        return this.reserve(dataRec, planRecord, n3, n2);
    }

    public int reserve(DataRec dataRec, PlanRecord planRecord, int n, int n2) {
        int n3;
        int n4;
        Fact fact;
        ResourceItem resourceItem;
        ExternalDb externalDb = this.context.ExternalDb();
        Fact fact2 = dataRec.getFact();
        boolean bl = !fact2.isReadOnly();
        Vector vector = (Vector)this.get(fact2.getType());
        if (vector == null) {
            vector = new Vector();
        }
        Bindings bindings = new Bindings(this.name);
        for (int i = 0; n2 > 0 && i < vector.size(); ++i) {
            resourceItem = (ResourceItem)vector.elementAt(i);
            fact = resourceItem.getFact();
            this.notifyMonitors(resourceItem, 3);
            Core.DEBUG(2, "Fact before test \n" + fact);
            bindings.clear();
            n4 = resourceItem.unreservedAmount(n, bl);
            if (n4 <= 0 || !fact.unifiesWith(fact2, bindings) || !planRecord.applyConstraints(bindings)) continue;
            n3 = Math.min(n4, n2);
            Core.ERROR(dataRec.add(resourceItem, n, n3), 1002, (Object)this);
            if (bl) {
                planRecord.updateCost((double)n3 * fact.getUnitCost());
            }
            n2 -= n3;
            Core.DEBUG(2, "Required to find Fact:\n" + fact2);
            Core.DEBUG(2, "Fact:\n" + fact + "\nassigned to datarec " + dataRec.getId());
        }
        if (n2 > 0 && externalDb != null) {
            Enumeration enumeration = externalDb.all(fact2);
            while (enumeration != null && enumeration.hasMoreElements() && n2 > 0) {
                fact = (Fact)enumeration.nextElement();
                bindings.clear();
                if (!fact.unifiesWith(fact2, bindings) || !planRecord.applyConstraints(bindings)) continue;
                n4 = fact.getNumber();
                Fact fact3 = externalDb.remove(fact);
                if (fact3 != null) {
                    resourceItem = this.add(fact3);
                    n3 = Math.min(n4, n2);
                    Core.ERROR(dataRec.add(resourceItem, n, n3), 1003, (Object)this);
                    if (bl) {
                        planRecord.updateCost((double)n3 * fact3.getUnitCost());
                    }
                    n2 -= n3;
                    Core.DEBUG(2, "Required to find Fact:\n" + fact2);
                    Core.DEBUG(2, "Fact:\n" + fact3 + "\nassigned to datarec " + dataRec.getId());
                    continue;
                }
                Core.USER_ERROR("Improperly defined externalDb: fact \"" + fact + "\" should be in externaldb, but not found");
            }
        }
        return n2;
    }

    public synchronized int reserve(DataRec dataRec, int n, int n2) {
        int n3;
        int n4;
        Bindings bindings;
        Fact fact;
        ResourceItem resourceItem;
        ExternalDb externalDb = this.context.ExternalDb();
        Fact fact2 = dataRec.getFact();
        boolean bl = !fact2.isReadOnly();
        Vector vector = (Vector)this.get(fact2.getType());
        if (vector == null) {
            vector = new Vector();
        }
        for (int i = 0; n2 > 0 && i < vector.size(); ++i) {
            resourceItem = (ResourceItem)vector.elementAt(i);
            fact = resourceItem.getFact();
            this.notifyMonitors(resourceItem, 3);
            bindings = new Bindings(this.name);
            n4 = resourceItem.unreservedAmount(n, bl);
            if (n4 <= 0 || !fact.unifiesWith(fact2, bindings)) continue;
            n3 = Math.min(n4, n2);
            Core.ERROR(dataRec.add(resourceItem, n, n3), 1005, (Object)this);
            n2 -= n3;
            Core.DEBUG(2, "Required to find Fact:\n" + fact2);
            Core.DEBUG(2, "Fact:\n" + fact + "\nassigned to datarec " + dataRec.getId());
        }
        if (n2 > 0 && externalDb != null) {
            Enumeration enumeration = externalDb.all(fact2);
            while (enumeration.hasMoreElements() && n2 > 0) {
                fact = (Fact)enumeration.nextElement();
                if (!fact.unifiesWith(fact2, bindings = new Bindings(this.name))) continue;
                n4 = fact.getNumber();
                fact = externalDb.remove(fact);
                resourceItem = this.add(fact);
                n3 = Math.min(n4, n2);
                Core.ERROR(dataRec.add(resourceItem, n, n3), 1006, (Object)this);
                n2 -= n3;
                Core.DEBUG(2, "Required to find Fact:\n" + fact2);
                Core.DEBUG(2, "Fact:\n" + fact + "\nassigned to datarec " + dataRec.getId());
            }
        }
        return n2;
    }

    public Vector allocateResources(PlanRecord planRecord) {
        Vector<Goal> vector = new Vector<Goal>();
        PrimitiveTask primitiveTask = planRecord.getTask();
        Fact[][] factArray = primitiveTask.orderPreconditions();
        for (int i = 0; i < factArray.length; ++i) {
            for (int j = 0; j < factArray[i].length; ++j) {
                Goal goal;
                int n;
                int n2;
                if (factArray[i][j].isNegative() || (n2 = planRecord.noRequiredItems(n = primitiveTask.getConsumedPos(factArray[i][j]))) <= 0 || (goal = this.allocateResource(planRecord, n, n2)) == null) continue;
                vector.addElement(goal);
            }
            if (!vector.isEmpty()) break;
        }
        return vector;
    }

    public Goal allocateResource(PlanRecord planRecord, int n, int n2) {
        if ((n2 = this.findAll(planRecord, n, n2)) > 0) {
            if (!this.isPlannerSet()) {
                if (!this.isContextSet()) {
                    try {
                        throw new Exception("Planner and AgentContext not set in ResourceDb.\n Agent is improperly initialised, sorry");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    this.planner = this.context.getPlanner();
                }
            }
            Planner planner = this.planner;
            this.debug("planner = " + planner);
            DataRec dataRec = planRecord.getDatarec(n);
            Fact fact = dataRec.getFact();
            int n3 = planner.anySideEffect(fact, planRecord, n, n2);
            if (n3 != 0) {
                Fact fact2 = new Fact(fact);
                fact2.setNumber(n3);
                return planRecord.createSubgoal(fact2, n);
            }
        }
        return null;
    }

    public synchronized Fact debit(double d) {
        PrimitiveNumericFn primitiveNumericFn;
        Fact fact;
        ResourceItem resourceItem;
        int n;
        Core.DEBUG(3, "About to debit: " + d);
        Core.ERROR(d >= 0.0, 1006, (Object)this);
        OntologyDb ontologyDb = this.ontologyDb;
        Fact fact2 = ontologyDb.getFact(false, "Money");
        fact2.setValue("amount", d);
        Vector vector = (Vector)this.get("Money");
        for (n = 0; vector != null && d > 0.0 && n < vector.size(); ++n) {
            resourceItem = (ResourceItem)vector.elementAt(n);
            this.notifyMonitors(resourceItem, 3);
            if (resourceItem.isReserved()) continue;
            fact = resourceItem.getFact();
            fact.resolve(new Bindings(this.name));
            primitiveNumericFn = (PrimitiveNumericFn)((Object)fact.getFn("amount"));
            double d3 = primitiveNumericFn.doubleValue();
            if (d3 > d) {
                Fact fact3 = fact.duplicate("var", this.gensym);
                fact3.setValue("amount", d3 - d);
                fact3.resolve(new Bindings(this.name));
                vector.removeElementAt(n--);
                resourceItem.deleted();
                this.notifyMonitors(resourceItem, 2);
                fact.setValue("amount", d);
                ResourceItem resourceItem2 = new ResourceItem(fact3);
                vector.addElement(resourceItem2);
                this.notifyMonitors(resourceItem2, 0);
                Core.DEBUG(3, "Debit completed: " + fact2);
                return fact2;
            }
            if (!(d3 >= 0.0)) continue;
            vector.removeElementAt(n--);
            resourceItem.deleted();
            this.notifyMonitors(resourceItem, 2);
            d -= d3;
        }
        if (d > 0.0) {
            n = 0;
            for (int i = 0; vector != null && n == 0 && i < vector.size(); ++i) {
                resourceItem = (ResourceItem)vector.elementAt(i);
                this.notifyMonitors(resourceItem, 3);
                if (resourceItem.isReserved()) continue;
                fact = resourceItem.getFact();
                fact.resolve(new Bindings(this.name));
                primitiveNumericFn = (PrimitiveNumericFn)((Object)fact.getFn("amount"));
                double d4 = primitiveNumericFn.doubleValue();
                vector.removeElementAt(i--);
                resourceItem.deleted();
                this.notifyMonitors(resourceItem, 2);
                fact.setValue("amount", d4 - d);
                fact.resolve(new Bindings(this.name));
                vector.addElement(resourceItem);
                this.notifyMonitors(resourceItem, 0);
                n = 1;
            }
            if (n == 0) {
                fact = ontologyDb.getFact(false, "Money");
                fact.setValue("amount", 0.0 - d);
                fact.resolve(new Bindings(this.name));
                this.add(fact);
            }
        }
        Core.DEBUG(3, "Debit completed: " + fact2);
        return fact2;
    }

    public synchronized Fact evalLocal(Fact fact) {
        Fact[] factArray = this.all(fact);
        if (factArray.length == 0) {
            return null;
        }
        OntologyDb ontologyDb = this.ontologyDb;
        Fact fact2 = new Fact(factArray[0]);
        for (int i = 1; i < factArray.length; ++i) {
            Core.ERROR(fact2.disjoin(factArray[i]), 1008, (Object)this);
        }
        return fact2;
    }

    public synchronized boolean evalNegative(Fact fact) {
        Fact[] factArray = this.all(fact);
        return factArray.length == 0;
    }

    public synchronized Fact[] all(String string) {
        OntologyDb ontologyDb = this.ontologyDb;
        Fact fact = ontologyDb.getFact(true, string);
        return this.all(fact);
    }

    public synchronized Fact[] all(Fact fact) {
        ExternalDb externalDb = this.context.ExternalDb();
        Vector vector = (Vector)this.get(fact.getType());
        if (vector == null) {
            vector = new Vector();
        }
        Vector<Fact> vector2 = new Vector<Fact>();
        Bindings bindings = new Bindings(this.name);
        for (int i = 0; i < vector.size(); ++i) {
            ResourceItem resourceItem = (ResourceItem)vector.elementAt(i);
            Fact fact2 = resourceItem.getFact();
            this.notifyMonitors(resourceItem, 3);
            if (fact2.unifiesWith(fact, bindings)) {
                vector2.addElement(fact2);
            }
            bindings.clear();
        }
        if (externalDb != null) {
            Enumeration enumeration = externalDb.all(fact);
            while (enumeration.hasMoreElements()) {
                vector2.addElement((Fact)enumeration.nextElement());
            }
        }
        Fact[] factArray = new Fact[vector2.size()];
        for (int i = 0; i < vector2.size(); ++i) {
            factArray[i] = (Fact)vector2.elementAt(i);
        }
        return factArray;
    }

    public synchronized void deleteAll(String string) {
        Fact fact;
        ResourceItem resourceItem;
        int n;
        Vector vector = (Vector)this.get(string);
        if (vector == null) {
            return;
        }
        for (n = 0; n < vector.size(); ++n) {
            resourceItem = (ResourceItem)vector.elementAt(n);
            fact = resourceItem.getFact();
            this.notifyMonitors(resourceItem, 3);
            if (resourceItem.isReserved()) continue;
            vector.removeElementAt(n--);
            resourceItem.deleted();
            this.notifyMonitors(resourceItem, 2);
        }
        for (n = 0; n < vector.size(); ++n) {
            resourceItem = (ResourceItem)vector.elementAt(n);
            fact = resourceItem.getFact();
            this.notifyMonitors(resourceItem, 3);
            vector.removeElementAt(n--);
            resourceItem.deleted();
            this.notifyMonitors(resourceItem, 2);
        }
    }

    public synchronized Fact any(String string) {
        OntologyDb ontologyDb = this.ontologyDb;
        Fact fact = ontologyDb.getFact(true, string);
        return this.any(fact);
    }

    public synchronized Fact any(Fact fact) {
        Fact[] factArray = this.all(fact);
        if (factArray == null) {
            return null;
        }
        int n = (int)(Math.random() * (double)factArray.length);
        if (n > factArray.length - 1) {
            return fact;
        }
        return factArray[n];
    }

    public synchronized boolean contains(Fact fact, int n) {
        int n2;
        Fact fact2;
        ExternalDb externalDb = this.context.ExternalDb();
        Vector vector = (Vector)this.get(fact.getType());
        if (vector == null) {
            vector = new Vector();
        }
        Bindings bindings = new Bindings(this.name);
        int n3 = fact.getNumber();
        boolean bl = !fact.isReadOnly();
        for (int i = 0; n3 > 0 && i < vector.size(); ++i) {
            ResourceItem resourceItem = (ResourceItem)vector.elementAt(i);
            fact2 = resourceItem.getFact();
            this.notifyMonitors(resourceItem, 3);
            n2 = resourceItem.unreservedAmount(n, bl);
            if (n2 > 0 && fact2.unifiesWith(fact, bindings)) {
                n3 -= Math.min(n2, n3);
            }
            bindings.clear();
        }
        if (n3 > 0 && externalDb != null) {
            Enumeration enumeration = externalDb.all(fact);
            while (enumeration.hasMoreElements() && n3 > 0) {
                fact2 = (Fact)enumeration.nextElement();
                n2 = fact2.getNumber();
                n3 -= Math.min(n2, n3);
            }
        }
        return n3 <= 0;
    }

    public void addFactMonitor(FactMonitor factMonitor, long l, boolean bl) {
        this.addFactMonitor(factMonitor, l);
        if (!bl) {
            return;
        }
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            for (int i = 0; i < vector.size(); ++i) {
                ResourceItem resourceItem = (ResourceItem)vector.elementAt(i);
                FactEvent factEvent = new FactEvent(this, resourceItem, 8L);
                factMonitor.factAccessedEvent(factEvent);
                factEvent = new FactEvent(this, resourceItem, 1L);
                factMonitor.factAddedEvent(factEvent);
            }
        }
    }

    public void addFactMonitor(FactMonitor factMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.eventMonitor[0].add(factMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[1].add(factMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[2].add(factMonitor);
        }
        if ((l & 8L) != 0L) {
            this.eventMonitor[3].add(factMonitor);
        }
    }

    public void removeFactMonitor(FactMonitor factMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.eventMonitor[0].remove(factMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[1].remove(factMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[2].remove(factMonitor);
        }
        if ((l & 8L) != 0L) {
            this.eventMonitor[3].remove(factMonitor);
        }
    }

    private void notifyMonitors(ResourceItem resourceItem, int n) {
        if (this.eventMonitor[n].isEmpty()) {
            return;
        }
        Enumeration enumeration = this.eventMonitor[n].elements();
        switch (n) {
            case 0: {
                FactEvent factEvent = new FactEvent(this, resourceItem, 1L);
                while (enumeration.hasMoreElements()) {
                    FactMonitor factMonitor = (FactMonitor)enumeration.nextElement();
                    factMonitor.factAddedEvent(factEvent);
                }
                break;
            }
            case 1: {
                FactEvent factEvent = new FactEvent(this, resourceItem, 2L);
                while (enumeration.hasMoreElements()) {
                    FactMonitor factMonitor = (FactMonitor)enumeration.nextElement();
                    factMonitor.factModifiedEvent(factEvent);
                }
                break;
            }
            case 2: {
                FactEvent factEvent = new FactEvent(this, resourceItem, 4L);
                while (enumeration.hasMoreElements()) {
                    FactMonitor factMonitor = (FactMonitor)enumeration.nextElement();
                    factMonitor.factDeletedEvent(factEvent);
                }
                break;
            }
            case 3: {
                FactEvent factEvent = new FactEvent(this, resourceItem, 8L);
                while (enumeration.hasMoreElements()) {
                    FactMonitor factMonitor = (FactMonitor)enumeration.nextElement();
                    factMonitor.factAccessedEvent(factEvent);
                }
                break;
            }
        }
    }

    private void debug(String string) {
    }
}

