/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors;

import java.util.Enumeration;
import java.util.Vector;
import zeus.concepts.StrategyInfo;
import zeus.util.OrderedHashtable;

class ProtocolDbNode {
    private String factType;
    protected OrderedHashtable protocolIndex;

    public ProtocolDbNode() {
    }

    public ProtocolDbNode(String string) {
        this.factType = string;
        this.protocolIndex = new OrderedHashtable();
    }

    public String getFactType() {
        return this.factType;
    }

    public Vector getProtocols() {
        Vector vector = new Vector();
        Enumeration enumeration = this.protocolIndex.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public void addProtocol(String string, StrategyInfo strategyInfo) {
        if (this.protocolIndex.containsKey(string)) {
            Vector vector = (Vector)this.protocolIndex.get(string);
            vector.addElement(strategyInfo);
        } else {
            Vector<StrategyInfo> vector = new Vector<StrategyInfo>();
            vector.addElement(strategyInfo);
            this.protocolIndex.put(string, vector);
        }
    }

    public Vector getStrategy(String string) {
        return (Vector)this.protocolIndex.get(string);
    }

    public boolean hasProtocol(String string) {
        return this.protocolIndex.containsKey(string);
    }

    public void deleteProtocol(String string) {
        this.protocolIndex.remove(string);
    }

    public String toString() {
        String string = "(:fact " + this.factType + " ";
        Enumeration enumeration = this.protocolIndex.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Vector vector = (Vector)this.protocolIndex.get(string2);
            string = string + ":protocol " + string2 + " " + ":strategy " + vector + " ";
        }
        string = string.trim() + ")";
        return string;
    }
}

