/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors;

import java.util.StringTokenizer;
import java.util.Vector;
import zeus.actors.EffectChain;
import zeus.actors.PlanRecord;
import zeus.actors.ResourceDb;
import zeus.actors.rtn.Engine;
import zeus.actors.rtn.util.DelegationStruct;
import zeus.concepts.Bindings;
import zeus.concepts.ConsumerRecord;
import zeus.concepts.Fact;
import zeus.concepts.PlannerQueryStruct;
import zeus.concepts.PrimitiveTask;
import zeus.util.Assert;
import zeus.util.Core;

public class ProducedDb {
    protected Vector[] data = null;
    protected int[] produced = null;
    protected PlanRecord owner = null;

    public ProducedDb() {
    }

    public ProducedDb(PlanRecord planRecord, PrimitiveTask primitiveTask) {
        Assert.notNull(planRecord);
        this.produced = primitiveTask.numPostconditions();
        this.owner = planRecord;
        this.data = new Vector[this.produced.length];
    }

    public synchronized void add(int n, PlanRecord planRecord, int n2, String string, boolean bl) {
        EffectChain effectChain;
        Assert.notFalse(n >= 0 && n < this.data.length);
        if (this.data[n] == null) {
            this.data[n] = new Vector();
        }
        if (planRecord != null) {
            int n3 = planRecord.getConsumedPosition(string);
            int n4 = planRecord.getStartTime();
            Assert.notFalse(this.availableItems(n, n4, bl) >= n2);
            effectChain = new EffectChain(planRecord, n3, n2, n4, bl);
            planRecord.replacePrecondition(string, this.owner, n, n2);
        } else {
            int n5 = this.owner.getEndTime();
            Assert.notFalse(this.availableItems(n, n5, bl) >= n2);
            effectChain = new EffectChain(string, n2, n5, bl);
        }
        this.data[n].addElement(effectChain);
    }

    public synchronized void add(int n, EffectChain effectChain) {
        Assert.notFalse(n >= 0 && n < this.data.length);
        Assert.notFalse(this.availableItems(n, effectChain.start, effectChain.consumed) >= effectChain.amount);
        if (this.data[n] == null) {
            this.data[n] = new Vector();
        }
        this.data[n].addElement(effectChain);
    }

    public int noItemsProduced(int n) {
        return this.produced[n];
    }

    protected synchronized int availableItems(int n, int n2, boolean bl) {
        if (this.data[n] == null) {
            return this.produced[n];
        }
        int n3 = 0;
        for (int i = 0; i < this.data[n].size(); ++i) {
            EffectChain effectChain = (EffectChain)this.data[n].elementAt(i);
            if (bl) {
                if (!effectChain.consumed && effectChain.start <= n2) continue;
                n3 += effectChain.amount;
                continue;
            }
            if (!effectChain.consumed || effectChain.start > n2) continue;
            n3 += effectChain.amount;
        }
        return this.produced[n] - n3;
    }

    public synchronized int anySideEffect(int n, PlanRecord planRecord, Object object, int n2) {
        int n3 = -1;
        String string = null;
        boolean bl = false;
        if (object instanceof String) {
            string = (String)object;
            n3 = planRecord.getConsumedPosition(string);
            bl = true;
        } else {
            n3 = (Integer)object;
        }
        int n4 = planRecord.getStartTime();
        boolean bl2 = planRecord.isPreconditionConsumed(n3);
        int n5 = this.availableItems(n, n4, bl2);
        if (n5 == 0) {
            return n2;
        }
        Core.DEBUG(2, "ProducedDb checking for serendipitous effects");
        if (this.data[n] == null) {
            this.data[n] = new Vector();
        }
        int n6 = n5 >= n2 ? n2 : n5;
        EffectChain effectChain = new EffectChain(planRecord, n3, n6, n4, bl2);
        this.data[n].addElement(effectChain);
        if (bl) {
            planRecord.replacePrecondition(string, this.owner, n, n6);
        } else {
            planRecord.chainPrecondition(this.owner, n, n6, n3);
        }
        return n2 - n6;
    }

    public synchronized void hardChain(int n, int n2, PlanRecord planRecord, int n3) {
        Core.DEBUG(2, "ProducedDb hardChain effects ...1");
        Core.DEBUG(2, this.owner.toString() + "::" + n);
        Core.DEBUG(2, " ==");
        Core.DEBUG(2, planRecord.toString() + "::" + n3);
        int n4 = planRecord.getStartTime();
        boolean bl = planRecord.isPreconditionConsumed(n3);
        int n5 = this.availableItems(n, n4, bl);
        if (n5 == 0) {
            System.err.println("ProducedDb hardChain effects: available == 0");
            return;
        }
        if (this.data[n] == null) {
            this.data[n] = new Vector();
        }
        int n6 = n5 >= n2 ? n2 : n5;
        EffectChain effectChain = new EffectChain(planRecord, n3, n6, n4, bl);
        this.data[n].addElement(effectChain);
        planRecord.chainPrecondition(this.owner, n, n6, n3);
    }

    public synchronized void hardChain(int n, String string, int n2, int n3, boolean bl) {
        Core.DEBUG(2, "ProducedDb hardChain effects ...2");
        Core.DEBUG(2, "effect_position: " + n);
        Core.DEBUG(2, "key: " + string);
        Core.DEBUG(2, "amount: " + n2);
        Core.DEBUG(2, "start: " + n3);
        Core.DEBUG(2, "consumed: " + bl);
        Assert.notFalse(n >= 0 && n < this.data.length);
        if (this.data[n] == null) {
            this.data[n] = new Vector();
        }
        Core.DEBUG(2, "Current chains...");
        Core.DEBUG(2, this.data[n]);
        Assert.notFalse(this.availableItems(n, n3, bl) >= n2);
        EffectChain effectChain = new EffectChain(string, n2, n3, bl);
        this.data[n].addElement(effectChain);
    }

    public void allocatePostconditions(Fact[][] factArray) {
        this.debug(factArray.toString());
        for (int i = 0; i < factArray.length; ++i) {
            this.debug(factArray[i].toString());
            this.allocatePostcondition(i, factArray[i]);
        }
    }

    protected void allocatePostcondition(int n, Fact[] factArray) {
        Fact fact;
        EffectChain effectChain;
        int n2;
        Fact fact2 = factArray[0];
        this.debug("in producedDB " + String.valueOf(n));
        this.debug("in producedDB " + fact2.toString());
        int n3 = fact2.getNumber();
        if (n3 == 0) {
            Core.USER_ERROR("Warning: integer expected in .fact.no field.\nEnsure 'number' constraints are defined in all task specifications");
            return;
        }
        if (n3 < this.produced[n]) {
            Core.USER_ERROR("\nWarning: fewer items produced: " + n3 + " than expected " + this.produced[n]);
            Core.USER_ERROR(fact2.pprint());
        }
        ResourceDb resourceDb = this.owner.getAgentContext().ResourceDb();
        if (this.data[n] == null) {
            resourceDb.replaceOrAdd(fact2);
            return;
        }
        Engine engine = this.owner.getAgentContext().Engine();
        for (n2 = 0; n3 > 0 && n2 < this.data[n].size(); ++n2) {
            effectChain = (EffectChain)this.data[n].elementAt(n2);
            if (!effectChain.isExternal() || n3 < effectChain.amount) continue;
            if (effectChain.consumed) {
                n3 -= effectChain.amount;
            }
            fact = new Fact(false, fact2);
            fact.setNumber(effectChain.amount);
            DelegationStruct delegationStruct = new DelegationStruct(this.owner.getAgentContext().whoami(), "result", effectChain.key, fact);
            this.debug(delegationStruct.toString());
            engine.add(delegationStruct);
        }
        if (n3 > 0) {
            fact2.setNumber(n3);
            resourceDb.replaceOrAdd(fact2);
        }
        for (n2 = 0; n2 < this.data[n].size(); ++n2) {
            effectChain = (EffectChain)this.data[n].elementAt(n2);
            if (effectChain.isExternal()) continue;
            fact = new Fact(true, fact2);
            fact.setNumber(effectChain.amount);
            effectChain.record.preconditionExists(this.owner, n, effectChain.amount, effectChain.position);
        }
    }

    public boolean constrain(Bindings bindings) {
        boolean bl = true;
        for (int i = 0; bl && i < this.data.length; ++i) {
            Vector vector = this.data[i];
            for (int j = 0; bl && vector != null && j < vector.size(); ++j) {
                EffectChain effectChain = (EffectChain)vector.elementAt(j);
                if (effectChain.isExternal()) continue;
                bl &= effectChain.record.applyConstraints(bindings);
            }
        }
        return bl;
    }

    public PlanRecord getOwner() {
        return this.owner;
    }

    public synchronized void share(ProducedDb producedDb, PlanRecord planRecord, String string, PlanRecord planRecord2, String string2) {
        for (int i = 0; i < this.produced.length; ++i) {
            int n = producedDb.noItemsProduced(i);
            for (int j = 0; n > 0 && j < this.data[i].size(); ++j) {
                EffectChain effectChain = (EffectChain)this.data[i].elementAt(j);
                if (effectChain.amount <= n) {
                    this.data[i].removeElementAt(j--);
                    n -= effectChain.amount;
                } else {
                    effectChain.amount -= n;
                    effectChain = new EffectChain(effectChain);
                    effectChain.amount = n;
                    n = 0;
                }
                if (effectChain.isExternal()) {
                    if (effectChain.key.equals(string2)) {
                        effectChain.key = string;
                    }
                } else if (effectChain.record == planRecord2) {
                    effectChain.record = planRecord;
                }
                producedDb.add(i, effectChain);
            }
        }
    }

    public synchronized boolean update(PlanRecord planRecord, PlanRecord planRecord2) {
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; this.data[i] != null && j < this.data[i].size(); ++j) {
                EffectChain effectChain = (EffectChain)this.data[i].elementAt(j);
                if (effectChain.isExternal() || effectChain.record != planRecord2) continue;
                effectChain.record = planRecord;
                return true;
            }
        }
        return false;
    }

    public synchronized boolean update(String string, String string2) {
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; this.data[i] != null && j < this.data[i].size(); ++j) {
                EffectChain effectChain = (EffectChain)this.data[i].elementAt(j);
                if (!effectChain.isExternal() || !effectChain.key.equals(string2)) continue;
                effectChain.key = string;
                return true;
            }
        }
        return false;
    }

    public synchronized boolean replaceOrAdd(String string, String string2, int n, int n2, boolean bl) {
        EffectChain effectChain;
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; this.data[i] != null && j < this.data[i].size(); ++j) {
                effectChain = (EffectChain)this.data[i].elementAt(j);
                if (!effectChain.isExternal() || !effectChain.key.equals(string)) continue;
                Core.DEBUG(2, effectChain);
                if (effectChain.start == n && effectChain.amount == n2 && effectChain.consumed == bl) {
                    effectChain.key = string2;
                    return true;
                }
                if (effectChain.start <= n && effectChain.amount == n2 && effectChain.consumed && bl) {
                    effectChain.key = string2;
                    effectChain.start = n;
                    return true;
                }
                effectChain = new EffectChain(string2, n2, n, bl);
                this.add(i, effectChain);
                return true;
            }
        }
        effectChain = new EffectChain(string2, n2, n, bl);
        this.add(this.owner.getTask().getActiveEffectPos(), effectChain);
        return true;
    }

    public synchronized boolean hasAtMostOneParent(PlanRecord planRecord, String string) {
        Vector<PlanRecord> vector = new Vector<PlanRecord>();
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; this.data[i] != null && j < this.data[i].size(); ++j) {
                EffectChain effectChain = (EffectChain)this.data[i].elementAt(j);
                if (effectChain.isExternal()) {
                    if (vector2.contains(effectChain.key)) continue;
                    vector2.addElement(effectChain.key);
                    continue;
                }
                if (vector.contains(effectChain.record)) continue;
                vector.addElement(effectChain.record);
            }
        }
        Core.DEBUG(3, "ProducedDb hasAtMostOneParent: parent = " + planRecord + " key = " + string);
        Core.DEBUG(3, "ProducedDb hasAtMostOneParent: records = " + vector);
        Core.DEBUG(3, "ProducedDb hasAtMostOneParent: keys = " + vector2);
        if (planRecord != null) {
            return vector2.isEmpty() && vector.size() == 1 && vector.contains(planRecord);
        }
        return vector.isEmpty() && vector2.size() == 1 && (vector2.contains(string) || vector2.contains(this.owner.getGoal().getId()));
    }

    public synchronized void remove(int n, PlanRecord planRecord, int n2, int n3) {
        for (int i = 0; i < this.data[n].size(); ++i) {
            EffectChain effectChain = (EffectChain)this.data[n].elementAt(i);
            if (effectChain.record != planRecord || effectChain.position != n2 || effectChain.amount != n3) continue;
            this.data[n].removeElementAt(i--);
            return;
        }
        Assert.notNull(null);
    }

    public synchronized boolean references(PlanRecord planRecord) {
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; this.data[i] != null && j < this.data[i].size(); ++j) {
                EffectChain effectChain = (EffectChain)this.data[i].elementAt(j);
                if (effectChain.isExternal() || effectChain.record != planRecord) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized PlanRecord firstParent() {
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; this.data[i] != null && j < this.data[i].size(); ++j) {
                EffectChain effectChain = (EffectChain)this.data[i].elementAt(j);
                if (effectChain.isExternal()) continue;
                return effectChain.record;
            }
        }
        return null;
    }

    public synchronized String firstKey() {
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; this.data[i] != null && j < this.data[i].size(); ++j) {
                EffectChain effectChain = (EffectChain)this.data[i].elementAt(j);
                if (!effectChain.isExternal()) continue;
                return effectChain.key;
            }
        }
        return null;
    }

    public synchronized int firstPosition(PlanRecord planRecord) {
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; this.data[i] != null && j < this.data[i].size(); ++j) {
                EffectChain effectChain = (EffectChain)this.data[i].elementAt(j);
                if (effectChain.isExternal() || effectChain.record != planRecord) continue;
                return i;
            }
        }
        Assert.notNull(null);
        return -1;
    }

    public synchronized Vector getAllParents() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; this.data[i] != null && j < this.data[i].size(); ++j) {
                EffectChain effectChain = (EffectChain)this.data[i].elementAt(j);
                if (!effectChain.isExternal()) {
                    vector.addElement(effectChain.record.getGoal().getId());
                    continue;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(effectChain.key, "/");
                vector.addElement(stringTokenizer.nextToken());
            }
        }
        return vector;
    }

    public synchronized void notifyFailed(Vector vector, Vector vector2) {
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; this.data[i] != null && j < this.data[i].size(); ++j) {
                EffectChain effectChain = (EffectChain)this.data[i].elementAt(j);
                this.data[i].removeElementAt(j--);
                if (effectChain.isExternal()) {
                    this.owner.raiseException(i, effectChain.key, effectChain.amount);
                    continue;
                }
                if (effectChain.record == this.owner.getParent()) {
                    effectChain.record.reallocateResource(effectChain.position, this.owner, i, effectChain.amount, vector, vector2);
                    continue;
                }
                effectChain.record.reallocateResource(effectChain.position, this.owner, i, effectChain.amount, null, null);
            }
        }
    }

    public synchronized void softNotifyFailed(Vector vector, Vector vector2, PlannerQueryStruct plannerQueryStruct, int n) {
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; this.data[i] != null && j < this.data[i].size(); ++j) {
                EffectChain effectChain = (EffectChain)this.data[i].elementAt(j);
                this.data[i].removeElementAt(j--);
                if (effectChain.isExternal()) {
                    this.owner.softRaiseException(i, effectChain.key, effectChain.amount, plannerQueryStruct, n);
                    continue;
                }
                if (effectChain.record == this.owner.getParent()) {
                    effectChain.record.softReallocateResource(effectChain.position, this.owner, i, effectChain.amount, vector, vector2, plannerQueryStruct, n);
                    continue;
                }
                effectChain.record.softReallocateResource(effectChain.position, this.owner, i, effectChain.amount, null, null, plannerQueryStruct, n);
            }
        }
    }

    public String toString() {
        String string = "ProducedDb(\n" + this.owner + "\n";
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == null) continue;
            string = string + "data[" + i + "]: " + this.data[i] + "\n";
        }
        string = string + ")";
        return string;
    }

    public synchronized boolean setConsumers(String string, Vector vector) {
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; this.data[i] != null && j < this.data[i].size(); ++j) {
                EffectChain effectChain = (EffectChain)this.data[i].elementAt(j);
                if (!effectChain.isExternal() || !effectChain.key.equals(string)) continue;
                if (!this.checkConsumers(effectChain.start, effectChain.amount, effectChain.consumed, vector)) {
                    return false;
                }
                this.data[i].removeElementAt(j--);
                for (int k = 0; k < vector.size(); ++k) {
                    ConsumerRecord consumerRecord = (ConsumerRecord)vector.elementAt(k);
                    effectChain = new EffectChain(consumerRecord.consumer_id, consumerRecord.amount, consumerRecord.start, consumerRecord.consumed);
                    this.data[i].addElement(effectChain);
                }
                return true;
            }
        }
        return false;
    }

    protected synchronized boolean checkConsumers(int n, int n2, boolean bl, Vector vector) {
        Vector<ConsumerRecord> vector2 = new Vector<ConsumerRecord>();
        for (int i = 0; i < vector.size(); ++i) {
            ConsumerRecord consumerRecord = (ConsumerRecord)vector.elementAt(i);
            if (consumerRecord.start < n || !this.checkCurrent(n2, vector2, consumerRecord.start, consumerRecord.consumed, consumerRecord.amount)) {
                return false;
            }
            vector2.addElement(consumerRecord);
        }
        vector2 = null;
        return true;
    }

    protected synchronized boolean checkCurrent(int n, Vector vector, int n2, boolean bl, int n3) {
        int n4 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            ConsumerRecord consumerRecord = (ConsumerRecord)vector.elementAt(i);
            if (bl) {
                if (!consumerRecord.consumed && consumerRecord.start <= n2) continue;
                n4 += consumerRecord.amount;
                continue;
            }
            if (!consumerRecord.consumed || consumerRecord.start > n2) continue;
            n4 += consumerRecord.amount;
        }
        return n - n4 >= n3;
    }

    public void debug(String string) {
    }
}

