/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors;

import zeus.actors.PlanRecord;
import zeus.util.Assert;

public class PreconditionChain {
    public PlanRecord record = null;
    public int position = -1;
    public int amount = -1;
    public String key = null;

    public PreconditionChain() {
    }

    public PreconditionChain(PlanRecord planRecord, int n, int n2) {
        Assert.notNull(planRecord);
        Assert.notFalse(n > -1);
        Assert.notFalse(n2 > 0);
        this.record = planRecord;
        this.position = n;
        this.amount = n2;
    }

    public PreconditionChain(String string, int n) {
        Assert.notNull(string);
        Assert.notFalse(n > 0);
        this.key = string;
        this.amount = n;
    }

    public PreconditionChain(PreconditionChain preconditionChain) {
        if (preconditionChain.isExternal()) {
            this.key = preconditionChain.key;
            this.amount = preconditionChain.amount;
        } else {
            this.record = preconditionChain.record;
            this.position = preconditionChain.position;
            this.amount = preconditionChain.amount;
        }
    }

    public boolean isExternal() {
        return this.key != null;
    }

    public String toString() {
        String string = "PreconditionChain(";
        string = this.isExternal() ? string + this.key + "," + this.amount : string + this.record + "," + this.position + "," + this.amount;
        string = string + ")";
        return string;
    }
}

