/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.actors.MailBox;
import zeus.concepts.Address;
import zeus.concepts.Performative;
import zeus.concepts.ZeusAddress;
import zeus.util.Core;
import zeus.util.Queue;
import zeus.util.Time;

public class PostMan
extends Thread {
    protected final int MAX_RETRY = 10;
    protected Queue outMail = null;
    protected Queue ccMail = null;
    protected MailBox mbox = null;
    protected Address myAddress = null;
    protected boolean dispatching;
    protected Hashtable waitQueue = new Hashtable();
    private static int id = 0;
    private boolean fastAgent = false;
    int queueLength = 5;
    int sleepTime = 100;

    public PostMan() {
    }

    public PostMan(MailBox mailBox, Queue queue, Address address) {
        this(mailBox, queue, null, address);
    }

    public PostMan(MailBox mailBox, Queue queue, Queue queue2, Address address) {
        this.mbox = mailBox;
        this.outMail = queue;
        this.ccMail = queue2;
        this.myAddress = address;
        this.setName("Normal postman" + id);
        ++id;
        this.start();
    }

    public void stopDispatching() {
        this.dispatching = false;
    }

    public void lowerStatus() {
        this.setPriority(3);
    }

    public void run() {
        this.dispatching = true;
        while (this.dispatching) {
            this.doPost();
        }
    }

    public void doPost() {
        Performative performative = (Performative)this.outMail.dequeue();
        System.out.println("Zeus native msg = " + performative.toString());
        Enumeration enumeration = performative.getReceivers();
        if (enumeration == null) {
            this.mbox.postErrorMsg(performative, "No reveivers specified");
        } else {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Address address = this.mbox.lookup(string);
                if (address != null) {
                    System.out.println("send to addr = " + ((Object)address).toString());
                    if (this.postMsg(performative, address)) {
                        if (this.ccMail == null) continue;
                        this.mbox.informVisualisers(performative);
                        continue;
                    }
                    this.mbox.postErrorMsg(performative, "Cannot contact reciever");
                    this.mbox.del(address);
                    continue;
                }
                String string2 = this.mbox.addressSought(string);
                if (string2 == null) {
                    this.mbox.postErrorMsg(performative, "Cannot find address of receiver");
                    continue;
                }
                Vector<Performative> vector = (Vector<Performative>)this.waitQueue.get(string2);
                if (vector == null) {
                    vector = new Vector<Performative>(20);
                    this.waitQueue.put(string2, vector);
                }
                vector.addElement(performative);
            }
        }
        PostMan.yield();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addressReceived(String string) {
        Hashtable hashtable = this.waitQueue;
        synchronized (hashtable) {
            Vector vector = (Vector)this.waitQueue.remove(string);
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                this.outMail.enqueue(vector.elementAt(i));
            }
            vector = null;
        }
    }

    public void setFastAgent() {
        this.fastAgent = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean postMsg(Performative performative, Address address) {
        PrintWriter printWriter = null;
        boolean bl = false;
        int n = 0;
        if (performative.getSender() == null) {
            performative.setSender(this.myAddress.getName());
        } else if (performative.getSender().equals("") || performative.getSender().equals("null")) {
            performative.setSender(this.myAddress.getName());
        }
        ZeusAddress zeusAddress = new ZeusAddress(this.myAddress);
        if (!performative.getSender().equals(zeusAddress.getName())) {
            zeusAddress.setName(performative.getSender());
            if (this.myAddress.getType().equalsIgnoreCase("facilitator")) {
                zeusAddress.setType("FORWARD");
            }
        }
        performative.setAddress(zeusAddress);
        while (!bl && n++ < 10) {
            try {
                System.out.println("HOST = " + address.getHost() + " PORT = " + address.getPort());
                Socket socket = new Socket(address.getHost(), address.getPort());
                printWriter = new PrintWriter(socket.getOutputStream(), true);
                Time time = this.mbox.getAgentContext().currentTime();
                if (time != null) {
                    performative.setSendTime(time);
                }
                printWriter.println(performative);
                printWriter.flush();
                bl = true;
                time = this.mbox.getAgentContext().currentTime();
                if (time != null) {
                    performative.setReceiveTime(time);
                }
                this.mbox.notifyMonitors(performative, 2);
                System.out.println("MESSAGE SENT");
            }
            catch (IOException iOException) {
                Core.DEBUG(3, "IOException: " + iOException);
                PostMan.yield();
            }
            finally {
                if (printWriter == null) continue;
                printWriter.close();
            }
        }
        return bl;
    }

    public void push(Performative performative) {
        while (this.outMail.size() > this.queueLength) {
            this.doPost();
        }
        this.outMail.enqueue(performative);
    }
}

