/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.actors.AgentContext;
import zeus.actors.ConsumedDb;
import zeus.actors.Decomposition;
import zeus.actors.ExecutionMonitor;
import zeus.actors.PlanDb;
import zeus.actors.PlanRecord;
import zeus.actors.ProducedDb;
import zeus.actors.ResourceDb;
import zeus.actors.TaskDb;
import zeus.actors.event.PlanStepEvent;
import zeus.actors.event.PlanStepMonitor;
import zeus.actors.event.PlanningEvent;
import zeus.actors.event.PlanningMonitor;
import zeus.actors.rtn.util.DelegationStruct;
import zeus.concepts.BindResults;
import zeus.concepts.Bindings;
import zeus.concepts.ConsumerRecord;
import zeus.concepts.Fact;
import zeus.concepts.Goal;
import zeus.concepts.PlannerEnactStruct;
import zeus.concepts.PlannerQueryStruct;
import zeus.concepts.PrimitiveTask;
import zeus.concepts.ProducerRecord;
import zeus.concepts.SummaryTask;
import zeus.concepts.SuppliedDb;
import zeus.concepts.Task;
import zeus.util.Assert;
import zeus.util.Core;
import zeus.util.HSet;
import zeus.util.Misc;
import zeus.util.Selector;
import zeus.util.Time;

public class Planner
extends PlanDb {
    private HSet[] eventMonitor = new HSet[6];
    public static final int START = 0;
    public static final int FAIL = 1;
    public static final int SUCCEED = 2;
    public static final int CREATE = 3;
    public static final int DISPOSE = 4;
    public static final int STATE_CHANGE = 5;
    public static final boolean EXPAND = true;
    public static final int REPLAN = 0;
    public static final int PLAN = 1;
    protected PlanRecord[][] table;
    protected int plannerWidth;
    protected int plannerLength;
    protected int now;
    protected Hashtable BindTable;
    protected boolean user_responded = false;
    protected long USER_TIME_OUT = 0L;
    protected AgentContext context = null;

    public Planner() {
        for (int i = 0; i < this.eventMonitor.length; ++i) {
            this.eventMonitor[i] = new HSet();
        }
    }

    public Planner(AgentContext agentContext, int n, int n2) {
        Assert.notNull(agentContext);
        this.context = agentContext;
        agentContext.set(this);
        Core.ERROR(n2 > 0 && n > 0, 1005, (Object)this);
        this.table = new PlanRecord[n][n2];
        this.plannerLength = n2;
        this.plannerWidth = n;
        this.now = (int)this.now();
        this.BindTable = new Hashtable();
        for (int i = 0; i < this.eventMonitor.length; ++i) {
            this.eventMonitor[i] = new HSet();
        }
        this.USER_TIME_OUT = (long)(0.5 * (double)agentContext.getClockStep());
    }

    public AgentContext getAgentContext() {
        return this.context;
    }

    public int getPlannerWidth() {
        return this.plannerWidth;
    }

    public int getPlannerLength() {
        return this.plannerLength;
    }

    int anySideEffect(Fact fact, PlanRecord planRecord, int n, int n2) {
        return this.anySideEffect(fact, planRecord, new Integer(n), n2);
    }

    int anySideEffect(Fact fact, PlanRecord planRecord, Object object, int n) {
        if (!this.context.getSharePlan()) {
            return n;
        }
        Core.DEBUG(2, "checking for serendipitous side-effects for " + fact);
        int n2 = fact.getNumber();
        int n3 = planRecord.getStartTime();
        if (fact.isa("Entity")) {
            fact.setNumber(fact.newVar());
        }
        Enumeration enumeration = this.elements();
        while (n > 0 && enumeration.hasMoreElements()) {
            PlanRecord planRecord2 = (PlanRecord)enumeration.nextElement();
            if (planRecord2 == planRecord || planRecord2.getEndTime() > n3) continue;
            n = planRecord2.anySideEffect(fact, planRecord, object, n);
        }
        fact.setNumber(n2);
        return n;
    }

    public PlannerQueryStruct canAchieve(Vector vector, String string) {
        Goal goal;
        Core.DEBUG(3, "\nCanAchieve:\n" + vector + "\n");
        PlannerQueryStruct plannerQueryStruct = new PlannerQueryStruct(vector);
        for (int i = 0; i < vector.size(); ++i) {
            goal = (Goal)vector.elementAt(i);
            this.notifyMonitors(goal, 0, 0);
        }
        plannerQueryStruct.timeout = this.context.getAcceptTimeout();
        if (this.loopFound(vector)) {
            Core.DEBUG(0, "CanAchieve loop found = " + plannerQueryStruct);
            this.index(plannerQueryStruct);
            return plannerQueryStruct;
        }
        double d = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        for (int i = 0; i < vector.size(); ++i) {
            goal = (Goal)vector.elementAt(i);
            d = Math.min(d, goal.getConfirmTime().getTime());
            if (goal.getReplyTime() == null) continue;
            d3 = Math.min(d3, goal.getReplyTime().getTime());
        }
        double d4 = this.now();
        if (d4 >= Math.min(d, d3)) {
            Core.DEBUG(0, "CanAchieve rt/ct problem: " + d4 + "\n" + plannerQueryStruct);
            this.index(plannerQueryStruct);
            return plannerQueryStruct;
        }
        plannerQueryStruct.internal = this.schedule(string, null, new Vector(), vector, plannerQueryStruct, true);
        if (plannerQueryStruct.internal.isEmpty()) {
            Core.DEBUG(0, "CanAchieve = " + plannerQueryStruct);
            this.index(plannerQueryStruct);
            return plannerQueryStruct;
        }
        double d5 = this.latestConfirmTime(vector);
        if (d5 < d) {
            Core.DEBUG(0, "CanAchieve lct < ct " + d4 + "\n" + plannerQueryStruct);
            this.reject(plannerQueryStruct.goals, plannerQueryStruct.internal);
            plannerQueryStruct.internal = new Vector();
            this.index(plannerQueryStruct);
            return plannerQueryStruct;
        }
        if (!plannerQueryStruct.internal.isEmpty() && !plannerQueryStruct.external.isEmpty()) {
            double d6 = Math.min(d, d3);
            d6 -= this.now();
            plannerQueryStruct.timeout = d6 = d6 / 2.0 * (double)plannerQueryStruct.external.size();
        }
        this.index(plannerQueryStruct);
        Core.DEBUG(0, "canAchieve = " + plannerQueryStruct);
        return plannerQueryStruct;
    }

    protected boolean loopFound(Vector vector) {
        Enumeration enumeration = this.BindTable.elements();
        Bindings bindings = new Bindings(this.context.whoami());
        while (enumeration.hasMoreElements()) {
            PlannerQueryStruct plannerQueryStruct = (PlannerQueryStruct)enumeration.nextElement();
            Vector vector2 = plannerQueryStruct.goals;
            for (int i = 0; i < vector.size(); ++i) {
                Goal goal = (Goal)vector.elementAt(i);
                Fact fact = goal.getFact();
                String string = goal.getRootId();
                for (int j = 0; j < vector2.size(); ++j) {
                    Goal goal2 = (Goal)vector2.elementAt(j);
                    if (goal2.getDesiredBy().equals(this.context.whoami())) {
                        Fact fact2 = goal2.getFact();
                        String string2 = goal2.getRootId();
                        if (string.equals(string2) && fact.unifiesWith(fact2, bindings)) {
                            Core.DEBUG(0, "Loop found: " + goal + "\n" + goal2);
                            return true;
                        }
                    }
                    bindings.clear();
                }
            }
        }
        return false;
    }

    public PlannerQueryStruct clear_bind(Vector vector) {
        if (vector.isEmpty()) {
            return null;
        }
        Core.DEBUG(3, "Entering Clear Bind goals\n" + vector + "\n");
        String string = this.makeIndex(vector);
        return (PlannerQueryStruct)this.BindTable.remove(string);
    }

    public void reset_bind(Vector vector, PlannerQueryStruct plannerQueryStruct) {
        Core.DEBUG(3, "Entering Reset Bind goals\n" + vector + "\n");
        String string = this.makeIndex(vector);
        Core.ERROR(this.BindTable.put(string, plannerQueryStruct) == null, 1009, (Object)this);
    }

    public Vector bind(Vector vector) {
        PlanRecord planRecord;
        Core.DEBUG(3, "Entering Final Bind goals\n" + vector + "\n");
        String string = this.makeIndex(vector);
        PlannerQueryStruct plannerQueryStruct = (PlannerQueryStruct)this.BindTable.get(string);
        Core.DEBUG(3, "Final Bind checking record");
        for (int i = 0; i < plannerQueryStruct.internal.size(); ++i) {
            planRecord = (PlanRecord)plannerQueryStruct.internal.elementAt(i);
            Bindings bindings = planRecord.getBindings();
            Core.ERROR(plannerQueryStruct.bindings.add(bindings), 1010, (Object)this);
        }
        Vector<Goal> vector2 = new Vector<Goal>();
        Core.DEBUG(3, "Final Bind checking costs");
        for (int i = 0; i < vector.size(); ++i) {
            Goal goal = new Goal((Goal)vector.elementAt(i));
            goal.constrain(plannerQueryStruct.bindings);
            planRecord = this.lookUp(goal);
            goal.setCost(planRecord.getCost());
            vector2.addElement(goal);
        }
        Core.DEBUG(3, "Exiting Final Bind goals\n" + vector2 + "\n");
        return vector2;
    }

    public synchronized void userResponded() {
        this.user_responded = true;
    }

    public BindResults bind(Vector vector, Vector vector2, int n) {
        Goal goal;
        PlanRecord planRecord;
        Goal goal2;
        int n2;
        Core.DEBUG(3, "Entering bind...");
        String string = this.makeIndex(vector);
        PlannerQueryStruct plannerQueryStruct = (PlannerQueryStruct)this.BindTable.get(string);
        Object[] objectArray = new Vector[plannerQueryStruct.external.size()];
        Bindings bindings = new Bindings(this.context.whoami());
        BindResults bindResults = new BindResults();
        boolean bl = false;
        Vector<Goal> vector3 = new Vector<Goal>();
        Vector<Goal> vector4 = new Vector<Goal>();
        for (n2 = 0; n2 < plannerQueryStruct.external.size(); ++n2) {
            goal2 = (Goal)plannerQueryStruct.external.elementAt(n2);
            objectArray[n2] = this.sortFeasible(goal2.getId(), vector2);
            if (objectArray[n2].isEmpty()) {
                vector3.addElement(goal2);
                continue;
            }
            vector4.addElement(goal2);
        }
        if (!vector3.isEmpty()) {
            Core.DEBUG(3, "From bind...");
            Core.DEBUG(3, "PlannerQueryStruct = " + plannerQueryStruct);
            Core.DEBUG(3, "absent = " + vector3);
            for (n2 = 0; n2 < plannerQueryStruct.internal.size(); ++n2) {
                planRecord = (PlanRecord)plannerQueryStruct.internal.elementAt(n2);
                Core.DEBUG(3, planRecord.getConsumedDb());
            }
            this.softFailParentOf(vector3, plannerQueryStruct, n);
            for (n2 = 0; n2 < vector4.size(); ++n2) {
                goal = (Goal)vector4.elementAt(n2);
                bl = false;
                for (int i = 0; !bl && i < plannerQueryStruct.external.size(); ++i) {
                    goal2 = (Goal)plannerQueryStruct.external.elementAt(i);
                    boolean bl2 = bl = bl || goal2.getId().equals(goal.getId());
                    if (!bl) continue;
                    plannerQueryStruct.external.removeElementAt(i--);
                }
                if (bl) continue;
                vector4.removeElementAt(n2--);
            }
        }
        Core.DEBUG(3, "Present = " + vector4);
        Core.DEBUG(3, "Struct = " + plannerQueryStruct);
        if (vector4.isEmpty()) {
            bindResults.rejection = vector2;
            bindResults.ok = !plannerQueryStruct.internal.isEmpty() || !plannerQueryStruct.decompositions.isEmpty();
            bindResults.external = Misc.copyVector(plannerQueryStruct.external);
            return bindResults;
        }
        if (vector4.size() != objectArray.length) {
            objectArray = new Vector[vector4.size()];
            for (n2 = 0; n2 < vector4.size(); ++n2) {
                goal2 = (Goal)vector4.elementAt(n2);
                objectArray[n2] = this.sortFeasible(goal2.getId(), vector2);
            }
        }
        DelegationStruct[] delegationStructArray = new DelegationStruct[vector4.size()];
        Selector selector = new Selector(objectArray);
        bindResults.ok = false;
        while (!bindResults.ok && selector.hasMoreElements()) {
            int n3;
            Object[] objectArray2 = (Object[])selector.nextElement();
            bindings.clear();
            bindResults.ok = true;
            for (n3 = 0; n3 < objectArray2.length; ++n3) {
                delegationStructArray[n3] = (DelegationStruct)objectArray2[n3];
                goal = (Goal)delegationStructArray[n3].goals.elementAt(0);
                goal2 = (Goal)vector4.elementAt(n3);
                Fact fact = goal2.getFact();
                Fact fact2 = goal.getFact();
                bindResults.ok = fact2.unifiesWith(fact, bindings);
                if (!bindResults.ok) break;
            }
            Core.DEBUG(3, "Current selection ... ");
            Core.DEBUG(3, delegationStructArray);
            boolean bl3 = bindResults.ok = bindResults.ok && bindings.add(plannerQueryStruct.bindings);
            if (!bindResults.ok) continue;
            for (n3 = 0; n3 < plannerQueryStruct.internal.size(); ++n3) {
                planRecord = (PlanRecord)plannerQueryStruct.internal.elementAt(n3);
                Core.ERROR(planRecord.applyConstraints(bindings), 1011, (Object)this);
            }
            plannerQueryStruct.bindings = bindings;
            for (n3 = 0; n3 < objectArray2.length; ++n3) {
                delegationStructArray[n3] = (DelegationStruct)objectArray2[n3];
                bindResults.selection.addElement(delegationStructArray[n3]);
            }
        }
        if (bindResults.ok) {
            bindResults.rejection = Misc.difference(vector2, bindResults.selection);
            this.resume_planning(delegationStructArray, plannerQueryStruct);
        } else {
            bindResults.rejection = vector2;
            this.softFailParentOf(plannerQueryStruct.external, plannerQueryStruct, n);
            bindResults.ok = !plannerQueryStruct.internal.isEmpty() || !plannerQueryStruct.decompositions.isEmpty();
        }
        bindResults.external = Misc.copyVector(plannerQueryStruct.external);
        Core.DEBUG(3, " Bind struct\n" + plannerQueryStruct);
        Core.DEBUG(3, " Bind goals\n" + vector);
        Core.DEBUG(3, " Bind bindings\n" + plannerQueryStruct.bindings);
        Core.DEBUG(3, " Bind result\n" + bindResults + "\n");
        return bindResults;
    }

    protected Vector sortFeasible(String string, Vector vector) {
        Goal goal;
        DelegationStruct delegationStruct;
        int n;
        Core.DEBUG(3, "sortFeasible input " + string + "\n" + vector);
        Vector<DelegationStruct> vector2 = new Vector<DelegationStruct>();
        for (n = 0; n < vector.size(); ++n) {
            delegationStruct = (DelegationStruct)vector.elementAt(n);
            goal = (Goal)delegationStruct.goals.elementAt(0);
            if (!string.equals(goal.getId())) continue;
            vector2.addElement(delegationStruct);
        }
        Core.DEBUG(3, "sortFeasible reduced " + string + "\n" + vector2);
        n = 1;
        while (n != 0) {
            n = 0;
            for (int i = 0; i < vector2.size() - 1; ++i) {
                delegationStruct = (DelegationStruct)vector2.elementAt(i);
                goal = (Goal)delegationStruct.goals.elementAt(0);
                delegationStruct = (DelegationStruct)vector2.elementAt(i + 1);
                Goal goal2 = (Goal)delegationStruct.goals.elementAt(0);
                if (!(goal.getCost() > goal2.getCost())) continue;
                Object e = vector2.elementAt(i);
                vector2.setElementAt((DelegationStruct)vector2.elementAt(i + 1), i);
                vector2.setElementAt((DelegationStruct)e, i + 1);
                n = 1;
            }
        }
        Core.DEBUG(3, "sortFeasible results " + string + "\n" + vector2);
        return vector2;
    }

    public PlannerEnactStruct enact(Goal goal, Goal goal2) {
        PlannerEnactStruct plannerEnactStruct = new PlannerEnactStruct();
        this.notifyMonitors(goal, 0, 1);
        PlanRecord planRecord = this.lookUp(goal2);
        if (planRecord == null) {
            plannerEnactStruct.ok = false;
            this.notifyMonitors(goal, 1, 1);
            Core.DEBUG(3, "PlannerEnactStruct no sla found for\n" + goal2);
            return plannerEnactStruct;
        }
        planRecord.enact(plannerEnactStruct, goal, null, goal.getId(), new Hashtable());
        if (plannerEnactStruct.ok) {
            for (int i = 0; i < plannerEnactStruct.images.size(); ++i) {
                PlanRecord planRecord2 = (PlanRecord)plannerEnactStruct.images.elementAt(i);
                planRecord2.setState(3);
            }
            if (!planRecord.hasMoreEnactments()) {
                planRecord.dispose();
            }
            this.notifyMonitors(goal, 2, 1);
        } else {
            this.notifyMonitors(goal, 1, 1);
        }
        Core.DEBUG(3, "Final PlannerEnactStruct\n" + plannerEnactStruct);
        return plannerEnactStruct;
    }

    int latestConfirmTime(Vector vector) {
        Core.ERROR(vector, 1012, (Object)this);
        Core.ERROR(!vector.isEmpty(), 1013, (Object)this);
        int n = this.now + this.plannerLength;
        for (int i = 0; i < vector.size(); ++i) {
            n = Math.min(n, this.latestConfirmTime((Goal)vector.elementAt(i)));
        }
        return n;
    }

    int latestConfirmTime(Goal goal) {
        PlanRecord planRecord = this.lookUp(goal);
        return planRecord.latestConfirmTime();
    }

    protected String makeIndex(Vector vector) {
        Core.ERROR(vector, 1014, (Object)this);
        if (vector.isEmpty()) {
            return null;
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = ((Goal)vector.elementAt(i)).getId();
        }
        Misc.sort(stringArray);
        String string = new String();
        for (int i = 0; i < stringArray.length - 1; ++i) {
            string = string + stringArray[i] + "/";
        }
        string = string + stringArray[stringArray.length - 1];
        return string;
    }

    protected void index(PlannerQueryStruct plannerQueryStruct) {
        String string = this.makeIndex(plannerQueryStruct.goals);
        Core.ERROR(this.BindTable.put(string, plannerQueryStruct) == null, 1015, (Object)this);
    }

    protected void removeFromIndexTable(Vector vector) {
        Core.DEBUG(3, "Planner removeFromIndexTable");
        String string = this.makeIndex(vector);
        this.BindTable.remove(string);
    }

    public void book(int n, Vector vector, Vector vector2) {
        int n2;
        PlanRecord planRecord;
        Vector<PlanRecord> vector3 = new Vector<PlanRecord>();
        for (int i = 0; i < vector2.size(); ++i) {
            planRecord = ((PlanRecord)vector2.elementAt(i)).getRoot();
            if (vector3.contains(planRecord)) continue;
            vector3.addElement(planRecord);
        }
        for (n2 = 0; n2 < vector.size(); ++n2) {
            Goal goal = (Goal)vector.elementAt(n2);
            this.book(n, goal, vector3);
            if (n != 3) continue;
            this.notifyMonitors(goal, 2, 0);
        }
        for (n2 = 0; n2 < vector3.size(); ++n2) {
            planRecord = (PlanRecord)vector3.elementAt(n2);
            planRecord.setState(n);
        }
    }

    protected void book(int n, Goal goal, Vector vector) {
        PlanRecord planRecord = this.lookUp(goal);
        if (planRecord != null) {
            planRecord.setState(n);
            vector.removeElement(planRecord);
        }
    }

    public void reject(Vector vector, Vector vector2) {
        int n;
        PlanRecord planRecord;
        Core.DEBUG(3, "Planner Reject goals called " + vector);
        this.removeFromIndexTable(vector);
        Vector<PlanRecord> vector3 = new Vector<PlanRecord>();
        for (int i = 0; i < vector2.size(); ++i) {
            planRecord = ((PlanRecord)vector2.elementAt(i)).getRoot();
            if (vector3.contains(planRecord)) continue;
            vector3.addElement(planRecord);
        }
        for (n = 0; n < vector.size(); ++n) {
            Goal goal = (Goal)vector.elementAt(n);
            this.reject(goal, vector3);
            this.notifyMonitors(goal, 1, 0);
        }
        for (n = 0; n < vector3.size(); ++n) {
            planRecord = (PlanRecord)vector3.elementAt(n);
            planRecord.dispose();
        }
    }

    protected void reject(Goal goal, Vector vector) {
        PlanRecord planRecord = this.lookUp(goal);
        if (planRecord != null) {
            planRecord.dispose();
            vector.removeElement(planRecord);
        }
    }

    Vector schedule(String string, PlanRecord planRecord, Vector vector, Vector vector2, PlannerQueryStruct plannerQueryStruct, boolean bl) {
        Core.DEBUG(3, "schedule: 0");
        Vector vector3 = new Vector();
        for (int i = 0; i < vector2.size(); ++i) {
            Goal goal = (Goal)vector2.elementAt(i);
            Vector vector4 = Misc.copyVector(vector);
            Vector vector5 = this.schedule(string, planRecord, vector4, goal, plannerQueryStruct, bl);
            vector3 = Misc.union(vector3, vector5);
        }
        return vector3;
    }

    Vector schedule(String string, PlanRecord planRecord, Vector vector, Goal goal, PlannerQueryStruct plannerQueryStruct, boolean bl) {
        Object object;
        Core.DEBUG(3, "schedule: 1");
        if (planRecord != null) {
            goal = new Goal(goal);
            object = goal.getFact();
            int n = ((Fact)object).getNumber();
            n = this.anySideEffect((Fact)object, planRecord, goal.getId(), n);
            if (n == 0) {
                return new Vector();
            }
            ((Fact)object).setNumber(n);
            goal.setFact((Fact)object);
        }
        if (!this.validTime(goal.getEndTime())) {
            this.addToExternal(plannerQueryStruct.external, goal);
            return new Vector();
        }
        object = this.context.TaskDb().findAll(goal.getFact(), vector);
        Core.DEBUG(3, "Tasks for: " + goal.getFactType());
        Core.DEBUG(3, object);
        return this.schedule(string, planRecord, vector, goal, (Vector)object, plannerQueryStruct, bl);
    }

    protected void addToExternal(Vector vector, Goal goal) {
        Core.DEBUG(3, "Adding to external ... attempt");
        String string = goal.getId();
        for (int i = 0; i < vector.size(); ++i) {
            Goal goal2 = (Goal)vector.elementAt(i);
            if (!string.equals(goal2.getId())) continue;
            return;
        }
        Core.DEBUG(3, "Adding to external ... done");
        vector.addElement(goal);
    }

    Vector schedule(String string, PlanRecord planRecord, Vector vector, Goal goal, Vector vector2, PlannerQueryStruct plannerQueryStruct, boolean bl) {
        Core.DEBUG(3, "schedule: 2");
        Core.DEBUG(3, "schedule: 2 Path0 = " + vector);
        if (vector2 == null) {
            vector2 = this.context.TaskDb().findAll(goal.getFact(), vector);
        }
        Core.DEBUG(3, "schedule: 2 Path1 = " + vector);
        while (!vector2.isEmpty()) {
            Task task = (Task)vector2.firstElement();
            Vector vector3 = task.isPrimitive() ? this.schedule_primitive(string, planRecord, vector, goal, vector2, plannerQueryStruct, bl) : this.schedule_summary(string, planRecord, vector, goal, vector2, plannerQueryStruct, bl);
            if (vector3.isEmpty()) continue;
            return vector3;
        }
        this.addToExternal(plannerQueryStruct.external, goal);
        return new Vector();
    }

    Vector schedule_summary(String string, PlanRecord planRecord, Vector vector, Goal goal, Vector vector2, PlannerQueryStruct plannerQueryStruct, boolean bl) {
        Core.DEBUG(3, "schedule_summary");
        Core.DEBUG(3, "schedule_summary: Path = " + vector);
        SummaryTask summaryTask = (SummaryTask)vector2.firstElement();
        vector2.removeElementAt(0);
        Decomposition decomposition = new Decomposition(this, string, planRecord, vector, goal, summaryTask);
        Vector vector3 = this.expand_summary(decomposition, plannerQueryStruct, bl);
        Core.DEBUG(3, "schedule_summary end:");
        Core.DEBUG(3, plannerQueryStruct);
        return vector3;
    }

    Vector expand_summary(Decomposition decomposition, PlannerQueryStruct plannerQueryStruct, boolean bl) {
        Vector vector;
        String string;
        Vector vector2;
        String string2;
        Core.DEBUG(3, "expand_summary");
        Vector vector3 = new Vector();
        TaskDb taskDb = this.context.TaskDb();
        decomposition.reset();
        while ((string2 = decomposition.nextNode()) != null) {
            Core.DEBUG(3, "expand_summary node ... " + string2);
            if (decomposition.isScheduled(string2) || decomposition.isQueued(string2)) continue;
            Fact[] factArray = decomposition.getPreconditions(string2);
            Fact[] factArray2 = decomposition.getPostconditions(string2);
            vector2 = decomposition.getPath(string2);
            Goal goal = decomposition.getGoal(string2);
            Core.DEBUG(3, "expand_summary: goal = " + goal);
            Vector vector4 = taskDb.findAll(factArray, factArray2, vector2);
            string = decomposition.getKey(string2);
            PlanRecord planRecord = decomposition.getParentRecord(string2);
            vector = this.schedule(string, planRecord, vector2, goal, vector4, plannerQueryStruct, false);
            Core.DEBUG(3, "expand_summary record:");
            Core.DEBUG(3, vector);
            if (!vector.isEmpty()) {
                decomposition.setRecords(string2, vector);
                vector3 = Misc.union(vector3, vector);
                continue;
            }
            plannerQueryStruct.decompositions.put(goal.getId(), decomposition);
            SuppliedDb suppliedDb = decomposition.getSuppliedDb(string2);
            goal.setSuppliedDb(suppliedDb);
            decomposition.setQueued(string2, true);
        }
        if (decomposition.allNodesScheduled()) {
            decomposition.enforceLinks();
            decomposition.reset();
            while ((string2 = decomposition.nextNode()) != null) {
                Core.DEBUG(3, "expand_summary node: " + string2);
                PlanRecord planRecord = decomposition.getRecord(string2);
                Core.DEBUG(3, "expand_summary getRecord: " + planRecord);
                if (planRecord == null) continue;
                string = decomposition.getKey(string2);
                vector2 = decomposition.getPath(string2);
                vector = this.schedule_children(string, planRecord, vector2, plannerQueryStruct, bl);
                vector3 = Misc.union(vector3, vector);
            }
        }
        Core.DEBUG(3, "expand_summary end");
        Core.DEBUG(3, plannerQueryStruct);
        return vector3;
    }

    Vector schedule_primitive(String string, PlanRecord planRecord, Vector vector, Goal goal, Vector vector2, PlannerQueryStruct plannerQueryStruct, boolean bl) {
        int n;
        int n2;
        int n3;
        Core.DEBUG(3, "schedule_primitive");
        PrimitiveTask primitiveTask = (PrimitiveTask)vector2.firstElement();
        vector2.removeElementAt(0);
        Vector vector3 = new Vector();
        ResourceDb resourceDb = this.context.ResourceDb();
        SuppliedDb suppliedDb = goal.getSuppliedDb();
        int n4 = goal.getEndTime();
        int n5 = primitiveTask.getTime();
        if (goal.isContinuous()) {
            int n6 = goal.getStartTime();
            n3 = n6 - n5;
            n2 = n4 - n3;
            if (n2 / n5 < goal.getInvocations()) {
                return vector3;
            }
        } else {
            n3 = n4 - n5;
            n2 = n5;
        }
        if (!this.validTime(n4)) {
            return vector3;
        }
        if (!this.validTime(n3)) {
            return vector3;
        }
        for (n = 0; n < primitiveTask.countPreconditions(); ++n) {
            Fact fact = primitiveTask.getPrecondition(n);
            if (fact.isLocal()) {
                Core.DEBUG(3, "Checking consumed:\n" + fact.pprint());
                Core.DEBUG(3, "IsLocal: true");
                Fact fact2 = null;
                Fact fact3 = null;
                Fact fact4 = null;
                if (suppliedDb != null) {
                    fact2 = suppliedDb.evalLocal(fact);
                    Core.DEBUG(3, "SuppliedDb contains fact:\n" + fact2.pprint());
                }
                fact3 = resourceDb.evalLocal(fact);
                if (fact2 == null && fact3 == null) {
                    return vector3;
                }
                if (fact2 != null && fact3 != null) {
                    Core.ERROR(fact2.disjoin(fact3), 1016, (Object)this);
                    fact4 = fact2;
                } else {
                    fact4 = fact2 == null ? fact3 : fact2;
                }
                Core.DEBUG(3, "Db contains fact:\n" + fact4.pprint());
                Bindings bindings = new Bindings(this.context.whoami());
                fact.unifiesWith(fact4, bindings);
                primitiveTask.resolve(bindings);
                Core.DEBUG(3, "IsLocal bindings: " + bindings);
                continue;
            }
            if (!fact.isNegative()) continue;
            Core.DEBUG(3, "Checking negative:\n" + fact.pprint());
            Core.DEBUG(3, "IsNegative: true");
            if (!resourceDb.evalNegative(fact)) {
                return vector3;
            }
            Core.DEBUG(3, "Db does not contain fact:\n" + fact.pprint());
        }
        int n7 = n4 - 1;
        while (this.validTime(n7 - n2)) {
            for (n = 0; n < this.plannerWidth; ++n) {
                int n8;
                boolean bl2 = true;
                for (n8 = n7; bl2 && n8 > n7 - n2; --n8) {
                    bl2 = this.isFreeCell(n, n8) & bl2;
                }
                if (!bl2) continue;
                PlanRecord planRecord2 = new PlanRecord(this, string, planRecord, goal, primitiveTask, n, n7 - n2 + 1, n7 + 1);
                planRecord2.setPath(Misc.copyVector(vector));
                planRecord2.setAlternativeTasks(vector2);
                for (n8 = n7; n8 > n7 - n2; --n8) {
                    this.assignCell(n, n8, planRecord2);
                }
                plannerQueryStruct.internal.addElement(planRecord2);
                vector3.addElement(planRecord2);
                vector.addElement(goal.getFact());
                Vector vector4 = this.schedule_children(string, planRecord2, vector, plannerQueryStruct, bl);
                vector3 = Misc.union(vector3, vector4);
                return vector3;
            }
            --n7;
        }
        Core.DEBUG(3, "Space not found for: " + goal.getFactType());
        Core.DEBUG(3, "tduration = " + n2);
        Core.DEBUG(3, "tetime = " + n4);
        Core.DEBUG(3, "tlstime = " + n3);
        return vector3;
    }

    protected Vector schedule_children(String string, PlanRecord planRecord, Vector vector, PlannerQueryStruct plannerQueryStruct, boolean bl) {
        Vector vector2 = new Vector();
        ResourceDb resourceDb = this.context.ResourceDb();
        SuppliedDb suppliedDb = planRecord.getSuppliedDb();
        if (bl) {
            Vector vector3;
            Vector vector4 = plannerQueryStruct.external;
            plannerQueryStruct.external = new Vector();
            do {
                if (suppliedDb != null) {
                    suppliedDb.allocateResources(planRecord);
                }
                if ((vector3 = resourceDb.allocateResources(planRecord)).isEmpty()) continue;
                Vector vector5 = Misc.copyVector(vector);
                Vector vector6 = this.schedule(string, planRecord, vector5, vector3, plannerQueryStruct, bl);
                vector2 = Misc.union(vector2, vector6);
            } while (plannerQueryStruct.external.isEmpty() && !vector3.isEmpty());
            plannerQueryStruct.external = Misc.union(plannerQueryStruct.external, vector4);
        }
        return vector2;
    }

    protected void resume_planning(DelegationStruct[] delegationStructArray, PlannerQueryStruct plannerQueryStruct) {
        Decomposition decomposition = null;
        PlanRecord planRecord = null;
        Core.DEBUG(3, "resume_planning ... ds/struct");
        Core.DEBUG(3, delegationStructArray);
        Core.DEBUG(3, plannerQueryStruct);
        plannerQueryStruct.external.removeAllElements();
        for (int i = 0; i < delegationStructArray.length; ++i) {
            Goal goal = (Goal)delegationStructArray[i].goals.elementAt(0);
            decomposition = (Decomposition)plannerQueryStruct.decompositions.remove(goal.getId());
            if (decomposition == null) {
                int n;
                boolean bl = false;
                for (n = 0; !bl && n < plannerQueryStruct.internal.size(); ++n) {
                    planRecord = (PlanRecord)plannerQueryStruct.internal.elementAt(n);
                    bl = planRecord.hasSubgoal(goal.getId());
                }
                Core.ERROR(bl, 1017, (Object)this);
                String string = delegationStructArray[i].agent;
                String string2 = goal.getId();
                String string3 = this.context.whoami();
                String string4 = planRecord.getGoal().getId();
                String string5 = this.context.newId("used");
                int n2 = planRecord.getStartTime();
                n = planRecord.getConsumedPosition(string2);
                boolean bl2 = planRecord.isPreconditionConsumed(n);
                int n3 = planRecord.getAmountUsed(n);
                Core.ERROR(n3 > 0, 1031, (Object)this);
                goal.addConsumer(string, string2, string3, string4, string5, delegationStructArray[i].key, n2, n3, bl2);
                planRecord.getConsumedDb().update(string2 + "/" + string5, string2);
                Vector vector = planRecord.getChildPath();
                String string6 = planRecord.getKey();
                this.schedule_children(string6, planRecord, vector, plannerQueryStruct, true);
                continue;
            }
            String string = decomposition.getNodeWithGoalId(goal.getId());
            Core.DEBUG(3, "getNodeWithGoalId " + goal.getId() + " " + string);
            decomposition.setImage(string, goal, delegationStructArray[i].agent, delegationStructArray[i].key);
            this.expand_summary(decomposition, plannerQueryStruct, true);
        }
    }

    public void goalConfirmed(Vector vector, Vector vector2, Vector vector3) {
        for (int i = 0; i < vector2.size(); ++i) {
            Goal goal;
            DelegationStruct delegationStruct;
            int n;
            boolean bl;
            PlanRecord planRecord;
            int n2;
            Goal goal2 = (Goal)vector2.elementAt(i);
            Vector vector4 = goal2.getProducerRecords();
            for (n2 = 0; vector4 != null && n2 < vector4.size(); ++n2) {
                ProducerRecord producerRecord = (ProducerRecord)vector4.elementAt(n2);
                if (producerRecord.consumer.equals(this.context.whoami())) {
                    planRecord = (PlanRecord)this.get(producerRecord.consumer_id);
                    Core.ERROR(planRecord, 1001, (Object)this);
                    ConsumedDb consumedDb = planRecord.getConsumedDb();
                    bl = consumedDb.update(producerRecord.producer_id + "/" + producerRecord.use_ref, producerRecord.use_ref);
                    Core.ERROR(bl, 1002, (Object)this);
                    continue;
                }
                for (n = 0; n < vector3.size(); ++n) {
                    delegationStruct = (DelegationStruct)vector3.elementAt(n);
                    goal = (Goal)delegationStruct.goals.elementAt(0);
                    SuppliedDb suppliedDb = goal.getSuppliedDb();
                    if (suppliedDb == null || !suppliedDb.isReserved(producerRecord.supply_ref)) continue;
                    goal.addProducer(producerRecord);
                }
            }
            vector4 = goal2.getConsumerRecords();
            for (n2 = 0; vector4 != null && n2 < vector4.size(); ++n2) {
                ConsumerRecord consumerRecord = (ConsumerRecord)vector4.elementAt(n2);
                if (consumerRecord.producer.equals(this.context.whoami())) {
                    planRecord = (PlanRecord)this.get(consumerRecord.producer_id);
                    Core.ERROR(planRecord, 1003, (Object)this);
                    ProducedDb producedDb = planRecord.getProducedDb();
                    Core.DEBUG(3, "CdB replacing " + consumerRecord.producer_id + " with " + consumerRecord.consumer_id + "/" + consumerRecord.use_ref);
                    Core.DEBUG(3, vector4);
                    Core.DEBUG(3, planRecord);
                    bl = producedDb.replaceOrAdd(consumerRecord.producer_id, consumerRecord.consumer_id + "/" + consumerRecord.use_ref, consumerRecord.start, consumerRecord.amount, consumerRecord.consumed);
                    Core.DEBUG(3, "Replacement is " + bl);
                    Core.ERROR(bl, 1004, (Object)this);
                    continue;
                }
                for (n = 0; n < vector3.size(); ++n) {
                    delegationStruct = (DelegationStruct)vector3.elementAt(n);
                    goal = (Goal)delegationStruct.goals.elementAt(0);
                    goal.addConsumer(consumerRecord);
                }
            }
        }
    }

    protected boolean validTime(int n) {
        return this.now + this.plannerLength >= n && n >= this.now;
    }

    protected boolean validProc(int n) {
        return n >= 0 && n < this.plannerWidth;
    }

    protected boolean isFreeCell(int n, int n2) {
        Core.ERROR(n >= 0 && n < this.plannerWidth, 1018, (Object)this);
        Core.ERROR(this.now + this.plannerLength > n2 && n2 >= this.now, 1019, (Object)this);
        return this.table[n][n2 - this.now] == null;
    }

    public void shuffle() {
        this.checkRecords();
        for (int i = 0; i < this.plannerWidth; ++i) {
            for (int j = 0; j < this.plannerLength - 1; ++j) {
                this.assignCell(i, j + this.now, this.table[i][j + 1]);
            }
            this.assignCell(i, this.plannerLength - 1 + this.now, null);
        }
        ++this.now;
    }

    synchronized void executeEarliest() {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            PlanRecord planRecord = (PlanRecord)enumeration.nextElement();
            if (planRecord.getState() != 3 || !planRecord.isDiscrete() || planRecord.getStartTime() <= this.now || !planRecord.hasEnoughResources()) continue;
            this.executeEarliest(planRecord);
        }
    }

    synchronized void executeEarliest(PlanRecord planRecord) {
        int n = planRecord.getEndTime();
        int n2 = planRecord.getStartTime();
        int n3 = n - n2;
        if (!this.validTime(n)) {
            return;
        }
        if (!this.validTime(n2)) {
            return;
        }
        for (int i = this.now + 1; i < n2; ++i) {
            for (int j = 0; j < this.plannerWidth; ++j) {
                int n4;
                boolean bl = true;
                for (n4 = i; n4 < i + n3; ++n4) {
                    boolean bl2 = bl = bl && (this.isFreeCell(j, n4) || planRecord.isOnCell(j, n4));
                    if (!bl) break;
                }
                if (!bl) continue;
                Core.DEBUG(3, "Reassigning rec " + planRecord.getId() + " from [" + n2 + "," + n + "] to [" + i + "," + (i + n3) + "]");
                planRecord.reassign(j, i);
                for (n4 = i; n4 < i + n3; ++n4) {
                    this.assignCell(j, n4, planRecord);
                }
                return;
            }
        }
    }

    synchronized boolean incrementProcessorTime(PlanRecord planRecord, int n) {
        if (!this.validTime(n)) {
            return false;
        }
        if (this.isFreeCell(planRecord.getProc(), n)) {
            planRecord.incrementTime(n);
            this.assignCell(planRecord.getProc(), n, planRecord);
            return true;
        }
        return false;
    }

    public synchronized void checkRecords() {
        ExecutionMonitor executionMonitor = this.context.ExecutionMonitor();
        block8: for (int i = 0; i < this.plannerWidth; ++i) {
            PlanRecord planRecord = this.table[i][0];
            if (planRecord == null) continue;
            switch (planRecord.getState()) {
                case 7: 
                case 8: {
                    continue block8;
                }
                case 1: 
                case 2: {
                    PlanRecord planRecord2 = planRecord.getRoot();
                    planRecord2.dispose();
                    continue block8;
                }
                case 3: {
                    if (!planRecord.exec()) continue block8;
                    continue block8;
                }
                case 4: {
                    if (!planRecord.overRun()) continue block8;
                }
                case 5: {
                    PlanRecord planRecord2 = planRecord.getRoot();
                    planRecord2.dispose();
                    continue block8;
                }
                case 6: {
                    planRecord.dispose();
                }
            }
        }
        if (this.context.getExecuteEarliest()) {
            this.executeEarliest();
        }
    }

    public void notifyReceived(Fact fact, String string, String string2) {
        try {
            Core.DEBUG(3, "NotifyReceived...\n" + fact.pprint());
            PlanRecord planRecord = (PlanRecord)this.get(string);
            Core.ERROR(planRecord, 1020, (Object)this);
            this.context.ResourceDb().add(fact);
            planRecord.preconditionExists(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void assignCell(int n, int n2, PlanRecord planRecord) {
        Core.ERROR(n >= 0 && n < this.plannerWidth, 1021, (Object)this);
        Core.ERROR(this.now + this.plannerLength > n2 && n2 >= this.now, 1022, (Object)this);
        this.table[n][n2 - this.now] = planRecord;
    }

    void freeCell(int n, int n2) {
        Core.ERROR(n >= 0 && n < this.plannerWidth, 1023, (Object)this);
        if (this.now + this.plannerLength > n2 && n2 >= this.now) {
            this.table[n][n2 - this.now] = null;
        }
    }

    void freeCells(int n, int n2, int n3) {
        for (int i = n2; i < n3; ++i) {
            this.freeCell(n, i);
        }
    }

    public Goal recreateSubgoal(Goal goal) {
        String string = goal.getId();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            PlanRecord planRecord = (PlanRecord)enumeration.nextElement();
            if (!planRecord.hasSubgoal(string)) continue;
            return planRecord.recreateSubgoal(goal);
        }
        Goal goal2 = new Goal(goal);
        goal2.setId(this.context.newId("subgoal"));
        goal2.setImage(goal.getId());
        goal2.setConfirmTime(new Time(this.now() + this.context.getReplanPeriod()));
        return goal2;
    }

    public void reconfirmParentOf(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.reconfirmParentOf((Goal)vector.elementAt(i));
        }
    }

    public void reconfirmParentOf(Goal goal) {
        String string = goal.getId();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            PlanRecord planRecord = (PlanRecord)enumeration.nextElement();
            if (planRecord.hasSubgoal(string)) {
                planRecord.reconfirm();
                return;
            }
            if (!planRecord.getGoal().getId().equals(string) || planRecord.getParent() == null) continue;
            planRecord.getParent().reconfirm();
            return;
        }
        Core.DEBUG(3, "reconfirmParentOf error ...  " + goal);
        Core.ERROR(null, 1024, (Object)this);
    }

    public void failParentOf(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.failParentOf((Goal)vector.elementAt(i));
        }
    }

    public void failParentOf(Goal goal) {
        String string = goal.getId();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            PlanRecord planRecord = (PlanRecord)enumeration.nextElement();
            if (!planRecord.hasSubgoal(string)) continue;
            planRecord.setState(5);
            return;
        }
        Core.DEBUG(3, "failParentOf error ...  " + goal);
    }

    void softFailParentOf(Vector vector, PlannerQueryStruct plannerQueryStruct, int n) {
        boolean bl;
        int n2;
        String string;
        int n3;
        Core.DEBUG(3, "softFailParentOf Goal = " + vector);
        Core.DEBUG(3, "softFailParentOf PlannerQueryStruct = " + plannerQueryStruct);
        PlanRecord planRecord = null;
        Goal goal = null;
        for (n3 = 0; n3 < vector.size(); ++n3) {
            Decomposition decomposition;
            Goal goal2 = (Goal)vector.elementAt(n3);
            string = goal2.getId();
            for (n2 = 0; n2 < plannerQueryStruct.external.size(); ++n2) {
                goal = (Goal)plannerQueryStruct.external.elementAt(n2);
                if (!string.equals(goal.getId())) continue;
                plannerQueryStruct.external.removeElementAt(n2--);
                break;
            }
            if ((decomposition = (Decomposition)plannerQueryStruct.decompositions.remove(goal2.getId())) != null) continue;
            bl = false;
            for (n2 = 0; !bl && n2 < plannerQueryStruct.internal.size(); ++n2) {
                planRecord = (PlanRecord)plannerQueryStruct.internal.elementAt(n2);
                bl = planRecord.hasSubgoal(string);
            }
            if (!bl) continue;
            planRecord.softFail(plannerQueryStruct, n);
        }
        for (n3 = 0; n3 < plannerQueryStruct.internal.size(); ++n3) {
            planRecord = (PlanRecord)plannerQueryStruct.internal.elementAt(n3);
            if (this.containsRecord(planRecord)) continue;
            plannerQueryStruct.internal.removeElementAt(n3--);
        }
        Enumeration enumeration = plannerQueryStruct.decompositions.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            bl = false;
            for (n2 = 0; !bl && n2 < plannerQueryStruct.external.size(); ++n2) {
                goal = (Goal)plannerQueryStruct.external.elementAt(n2);
                bl = string.equals(goal.getId());
            }
            if (bl) continue;
            plannerQueryStruct.decompositions.remove(string);
        }
    }

    public void addPlanningMonitor(PlanningMonitor planningMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.eventMonitor[0].add(planningMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[1].add(planningMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[2].add(planningMonitor);
        }
    }

    public void removePlanningMonitor(PlanningMonitor planningMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.eventMonitor[0].remove(planningMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[1].remove(planningMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[2].remove(planningMonitor);
        }
    }

    public void addPlanStepMonitor(PlanStepMonitor planStepMonitor, long l, boolean bl) {
        this.addPlanStepMonitor(planStepMonitor, l);
        if (!bl) {
            return;
        }
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            PlanRecord planRecord = (PlanRecord)enumeration.nextElement();
            PlanStepEvent planStepEvent = new PlanStepEvent(this, planRecord, 1L);
            planStepMonitor.planStepCreatedEvent(planStepEvent);
        }
    }

    public void addPlanStepMonitor(PlanStepMonitor planStepMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.eventMonitor[3].add(planStepMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[4].add(planStepMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[5].add(planStepMonitor);
        }
    }

    public void removePlanStepMonitor(PlanStepMonitor planStepMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.eventMonitor[3].remove(planStepMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[4].remove(planStepMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[5].remove(planStepMonitor);
        }
    }

    void notifyMonitors(Goal goal, int n, int n2) {
        if (this.eventMonitor[n].isEmpty()) {
            return;
        }
        Enumeration enumeration = this.eventMonitor[n].elements();
        switch (n) {
            case 0: {
                PlanningEvent planningEvent = new PlanningEvent(this, goal, 1L, n2);
                while (enumeration.hasMoreElements()) {
                    PlanningMonitor planningMonitor = (PlanningMonitor)enumeration.nextElement();
                    planningMonitor.planningStartedEvent(planningEvent);
                }
                break;
            }
            case 1: {
                PlanningEvent planningEvent = new PlanningEvent(this, goal, 2L, n2);
                while (enumeration.hasMoreElements()) {
                    PlanningMonitor planningMonitor = (PlanningMonitor)enumeration.nextElement();
                    planningMonitor.planningFailedEvent(planningEvent);
                }
                break;
            }
            case 2: {
                PlanningEvent planningEvent = new PlanningEvent(this, goal, 4L, n2);
                while (enumeration.hasMoreElements()) {
                    PlanningMonitor planningMonitor = (PlanningMonitor)enumeration.nextElement();
                    planningMonitor.planningSucceededEvent(planningEvent);
                }
                break;
            }
        }
    }

    void notifyMonitors(PlanRecord planRecord, int n) {
        if (this.eventMonitor[n].isEmpty()) {
            return;
        }
        Enumeration enumeration = this.eventMonitor[n].elements();
        Core.ERROR(enumeration, 2001, (Object)this);
        switch (n) {
            case 3: {
                PlanStepEvent planStepEvent = new PlanStepEvent(this, planRecord, 1L);
                while (enumeration.hasMoreElements()) {
                    PlanStepMonitor planStepMonitor = (PlanStepMonitor)enumeration.nextElement();
                    planStepMonitor.planStepCreatedEvent(planStepEvent);
                }
                break;
            }
            case 4: {
                PlanStepEvent planStepEvent = new PlanStepEvent(this, planRecord, 2L);
                while (enumeration.hasMoreElements()) {
                    PlanStepMonitor planStepMonitor = (PlanStepMonitor)enumeration.nextElement();
                    planStepMonitor.planStepDisposedEvent(planStepEvent);
                }
                break;
            }
            case 5: {
                PlanStepEvent planStepEvent = new PlanStepEvent(this, planRecord, 4L);
                while (enumeration.hasMoreElements()) {
                    PlanStepMonitor planStepMonitor = (PlanStepMonitor)enumeration.nextElement();
                    planStepMonitor.planStepStateChangedEvent(planStepEvent);
                }
                break;
            }
        }
    }

    protected double now() {
        return this.context.now();
    }
}

