/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.actors.AbilityDb;
import zeus.actors.AgentContext;
import zeus.actors.event.RelationEvent;
import zeus.actors.event.RelationMonitor;
import zeus.concepts.AbilityDbItem;
import zeus.concepts.AbilitySpec;
import zeus.concepts.Goal;
import zeus.concepts.Relationship;
import zeus.util.Core;
import zeus.util.HSet;
import zeus.util.Misc;

public class OrganisationDb
extends AbilityDb {
    protected HSet[] eventMonitor = new HSet[4];
    private static final int ADD = 0;
    private static final int MODIFY = 1;
    private static final int DELETE = 2;
    private static final int ACCESS = 3;
    protected Hashtable relations = new Hashtable();
    protected String agentName = "null";

    public OrganisationDb() {
        for (int i = 0; i < this.eventMonitor.length; ++i) {
            this.eventMonitor[i] = new HSet();
        }
    }

    public OrganisationDb(AgentContext agentContext) {
        super(agentContext);
        this.agentName = agentContext.whoami();
        agentContext.set(this);
        for (int i = 0; i < this.eventMonitor.length; ++i) {
            this.eventMonitor[i] = new HSet();
        }
    }

    public void addRelation(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i++);
            String string2 = (String)vector.elementAt(i);
            this.addRelation(string, string2);
        }
    }

    public void modifyAgentRelation(String string, String string2, String string3) {
        this.removeRelation(string, string2);
        this.addRelation(string, string3);
    }

    public Vector allRelations() {
        String string;
        Vector<Relationship> vector = new Vector<Relationship>();
        Vector vector2 = this.getPeers();
        for (int i = 0; i < vector2.size(); ++i) {
            string = (String)vector2.elementAt(i);
            vector.addElement(new Relationship(string, "peer"));
        }
        Enumeration enumeration = this.relations.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Vector vector3 = (Vector)this.relations.get(string2);
            for (int i = 0; i < vector3.size(); ++i) {
                string = (String)vector3.elementAt(i);
                this.notifyMonitors(string, string2, 3);
                vector.addElement(new Relationship(string, string2));
            }
        }
        return vector;
    }

    public void addRelation(String string, String string2) {
        this.addItem(string, this.knownAgents);
        Vector<String> vector = (Vector<String>)this.relations.get(string2);
        if (vector == null) {
            vector = new Vector<String>();
            this.relations.put(string2, vector);
        }
        if (!vector.contains(string)) {
            vector.addElement(string);
            this.notifyMonitors(string, string2, 0);
        }
    }

    public void removeRelation(String string, String string2) {
        Vector vector = (Vector)this.relations.get(string2);
        if (vector == null) {
            return;
        }
        if (vector.contains(string)) {
            vector.removeElement(string);
            this.notifyMonitors(string, string2, 2);
        }
    }

    public boolean hasRelation(String string, String string2) {
        boolean bl = false;
        if (string2.equals("peer")) {
            Vector vector = this.getPeers();
            bl = vector.contains(string);
            this.notifyMonitors(string, "peer", 3);
        } else {
            Vector vector = (Vector)this.relations.get(string2);
            if (vector == null) {
                return false;
            }
            bl = vector.contains(string);
            this.notifyMonitors(string, "relation", 3);
        }
        return bl;
    }

    public boolean hasRelation(String string) {
        Vector vector;
        Vector vector2;
        boolean bl = false;
        bl = string.equals("peer") ? !(vector2 = this.getPeers()).isEmpty() : (vector = (Vector)this.relations.get(string)) != null && !vector.isEmpty();
        return bl;
    }

    public Vector anyAgent(Goal goal, Vector vector) {
        Core.DEBUG(4, "anyAgent() = " + goal);
        if (vector == null) {
            vector = new Vector();
        }
        Vector vector2 = Misc.difference(this.knownAgents, vector);
        vector2.removeElement(this.agentName);
        return this._anyAgent(vector2, goal);
    }

    private Vector getPeers() {
        Vector vector = new Vector();
        Enumeration enumeration = this.relations.elements();
        while (enumeration.hasMoreElements()) {
            vector = Misc.union(vector, (Vector)enumeration.nextElement());
        }
        Vector vector2 = Misc.difference(this.knownAgents, vector);
        vector2.removeElement(this.agentName);
        return vector2;
    }

    protected Vector _anyAgent(Vector vector, Goal goal) {
        Vector vector2 = null;
        Object var7_4 = null;
        Vector<String> vector3 = new Vector<String>();
        AbilitySpec abilitySpec = goal.getAbility();
        vector2 = this.findAll(abilitySpec);
        if (vector2 != null) {
            Core.DEBUG(4, "anyAgent: " + abilitySpec + "\nwith\n" + vector2);
            for (int i = 0; i < vector2.size(); ++i) {
                AbilityDbItem abilityDbItem = (AbilityDbItem)vector2.elementAt(i);
                String string = abilityDbItem.getAgent();
                Core.DEBUG(4, "anyAgent considering: " + string);
                if (vector.contains(string) && !vector3.contains(string)) {
                    vector3.addElement(string);
                    Core.DEBUG(4, "t" + string + " selected");
                    continue;
                }
                Core.DEBUG(4, "t" + string + " not selected");
            }
        }
        Core.DEBUG(4, "anyAgent result = " + vector3);
        return vector3;
    }

    public void addRelationMonitor(RelationMonitor relationMonitor, long l, boolean bl) {
        RelationEvent relationEvent;
        Relationship relationship;
        String string;
        this.addRelationMonitor(relationMonitor, l);
        if (!bl) {
            return;
        }
        Vector vector = this.getPeers();
        for (int i = 0; i < vector.size(); ++i) {
            string = (String)vector.elementAt(i);
            relationship = new Relationship(string, "peer");
            relationEvent = new RelationEvent(this, relationship, 8L);
            relationMonitor.relationAccessedEvent(relationEvent);
            relationEvent = new RelationEvent(this, relationship, 1L);
            relationMonitor.relationAddedEvent(relationEvent);
        }
        Enumeration enumeration = this.relations.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Vector vector2 = (Vector)this.relations.get(string2);
            for (int i = 0; i < vector2.size(); ++i) {
                string = (String)vector2.elementAt(i);
                relationship = new Relationship(string, string2);
                relationEvent = new RelationEvent(this, relationship, 8L);
                relationMonitor.relationAccessedEvent(relationEvent);
                relationEvent = new RelationEvent(this, relationship, 1L);
                relationMonitor.relationAddedEvent(relationEvent);
            }
        }
    }

    public void addRelationMonitor(RelationMonitor relationMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.eventMonitor[0].add(relationMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[1].add(relationMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[2].add(relationMonitor);
        }
        if ((l & 8L) != 0L) {
            this.eventMonitor[3].add(relationMonitor);
        }
    }

    public void removeRelationMonitor(RelationMonitor relationMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.eventMonitor[0].remove(relationMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[1].remove(relationMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[2].remove(relationMonitor);
        }
        if ((l & 8L) != 0L) {
            this.eventMonitor[3].remove(relationMonitor);
        }
    }

    private void notifyMonitors(String string, String string2, int n) {
        if (this.eventMonitor[n].isEmpty()) {
            return;
        }
        Enumeration enumeration = this.eventMonitor[n].elements();
        Relationship relationship = new Relationship(string, string2);
        switch (n) {
            case 0: {
                RelationEvent relationEvent = new RelationEvent(this, relationship, 1L);
                while (enumeration.hasMoreElements()) {
                    RelationMonitor relationMonitor = (RelationMonitor)enumeration.nextElement();
                    relationMonitor.relationAddedEvent(relationEvent);
                }
                break;
            }
            case 1: {
                RelationEvent relationEvent = new RelationEvent(this, relationship, 2L);
                while (enumeration.hasMoreElements()) {
                    RelationMonitor relationMonitor = (RelationMonitor)enumeration.nextElement();
                    relationMonitor.relationModifiedEvent(relationEvent);
                }
                break;
            }
            case 2: {
                RelationEvent relationEvent = new RelationEvent(this, relationship, 4L);
                while (enumeration.hasMoreElements()) {
                    RelationMonitor relationMonitor = (RelationMonitor)enumeration.nextElement();
                    relationMonitor.relationDeletedEvent(relationEvent);
                }
                break;
            }
            case 3: {
                RelationEvent relationEvent = new RelationEvent(this, relationship, 8L);
                while (enumeration.hasMoreElements()) {
                    RelationMonitor relationMonitor = (RelationMonitor)enumeration.nextElement();
                    relationMonitor.relationAccessedEvent(relationEvent);
                }
                break;
            }
        }
    }
}

