/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors;

import gnu.regexp.RE;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.actors.ActionNode;
import zeus.actors.AgentContext;
import zeus.actors.AttributeNode;
import zeus.actors.MailBox;
import zeus.actors.MsgNode;
import zeus.actors.PlanRecord;
import zeus.actors.RootNode;
import zeus.actors.TaskDb;
import zeus.actors.event.AbilityAdapter;
import zeus.actors.event.AbilityEvent;
import zeus.actors.event.MessageHandlerEvent;
import zeus.actors.event.MessageHandlerMonitor;
import zeus.actors.event.PlanStepAdapter;
import zeus.actors.event.PlanStepEvent;
import zeus.concepts.AbilitySpec;
import zeus.concepts.Address;
import zeus.concepts.Bindings;
import zeus.concepts.Fact;
import zeus.concepts.Goal;
import zeus.concepts.MessagePattern;
import zeus.concepts.MessageRule;
import zeus.concepts.MessageRuleImpl;
import zeus.concepts.Performative;
import zeus.concepts.ReportRec;
import zeus.concepts.Task;
import zeus.concepts.ZeusParser;
import zeus.util.Assert;
import zeus.util.Core;
import zeus.util.HSet;
import zeus.util.Misc;
import zeus.util.MsgContentHandler;
import zeus.util.Queue;

public class MsgHandler
extends Thread {
    protected HSet[] eventMonitor = new HSet[4];
    protected static final int ADD = 0;
    protected static final int FIRE = 1;
    protected static final int DELETE = 2;
    protected static final int FAIL = 3;
    protected Hashtable addressQueryTable = new Hashtable();
    protected Hashtable abilityQueryTable = new Hashtable();
    protected Hashtable reportQueryTable = new Hashtable();
    protected ReportLogger reportLogger = null;
    protected AbilityLogger abilityLogger = null;
    protected boolean processing;
    protected AgentContext context = null;
    protected RootNode MessageRootNode = null;
    Vector attributeNodes = new Vector();
    static int cleanupInterval = 100;
    protected Queue handleQ = null;

    public MsgHandler() {
    }

    public MsgHandler(AgentContext agentContext) {
        this.handleQ = new Queue("msg handler processing Q");
        Assert.notNull(agentContext);
        this.context = agentContext;
        agentContext.set(this);
        for (int i = 0; i < this.eventMonitor.length; ++i) {
            this.eventMonitor[i] = new HSet();
        }
        this.MessageRootNode = new RootNode(this);
        String[][] stringArrayArray = new String[][]{{"type", "request", "content", "\\Aregister\\Z"}, {"type", "request", "content", "\\Aderegister\\Z"}, {"type", "subscribe", "content", "\\Alog_message\\Z"}, {"type", "subscribe", "content", "\\Alog_report\\Z"}, {"type", "subscribe", "content", "\\Alog_address\\Z"}, {"type", "cancel", "content", "\\Alog_message\\Z"}, {"type", "cancel", "content", "\\Alog_report\\Z"}, {"type", "cancel", "content", "\\Alog_address\\Z"}, {"type", "query-ref", "content", "\\Ayour_abilities\\Z"}, {"type", "query-ref", "content", "\\Aaddress_of(\\s+)(\\w)(.*)\\Z"}, {"type", "query-ref", "content", "\\Ayour_relations\\Z"}, {"type", "query-ref", "content", "\\Ahas_ability(\\s+)(.*)\\Z"}, {"type", "inform", "content", "\\Aisa_facilitator(\\s+)(\\w)(.*)\\Z"}, {"type", "request", "content", "\\Akill_yourself\\Z"}, {"type", "subscribe", "content", "\\Ahas_ability(\\s+)(.*)\\Z"}, {"type", "cancel", "content", "\\Ahas_ability(\\s+)(.*)\\Z"}, {"type", "inform", "content", "\\Amy_abilities(\\s+)(.*)\\Z"}, {"type", "inform", "content", "\\Adata(\\s+)(.*)\\Z"}, {"type", "request", "content", "resume_goals\\s*"}, {"type", "request", "content", "cancel_goals\\s*"}, {"type", "request", "content", "db_del\\s*"}, {"type", "request", "content", "optimize\\s"}, {"type", "request", "content", "add_task\\s*"}, {"type", "request", "content", "modify_task\\s*"}, {"type", "request", "content", "delete_task\\s*"}, {"type", "subscribe", "content", "log_goal"}, {"type", "subscribe", "content", "log_task"}, {"type", "subscribe", "content", "log_state"}, {"type", "cancel", "content", "log_goal"}, {"type", "cancel", "content", "log_task"}, {"type", "cancel", "content", "log_state"}};
        this.addRule(new MessageRuleImpl(agentContext.newId("Rule"), stringArrayArray[0], this, "register"));
        this.addRule(new MessageRuleImpl(agentContext.newId("Rule"), stringArrayArray[1], this, "deregister"));
        this.addRule(new MessageRuleImpl(agentContext.newId("Rule"), stringArrayArray[2], this, "log_message"));
        this.addRule(new MessageRuleImpl(agentContext.newId("Rule"), stringArrayArray[3], this, "log_report"));
        this.addRule(new MessageRuleImpl(agentContext.newId("Rule"), stringArrayArray[4], this, "log_address"));
        this.addRule(new MessageRuleImpl(agentContext.newId("Rule"), stringArrayArray[5], this, "cancel_message"));
        this.addRule(new MessageRuleImpl(agentContext.newId("Rule"), stringArrayArray[6], this, "cancel_report"));
        this.addRule(new MessageRuleImpl(agentContext.newId("Rule"), stringArrayArray[7], this, "cancel_address"));
        this.addRule(new MessageRuleImpl(agentContext.newId("Rule"), stringArrayArray[8], this, "your_abilities"));
        this.addRule(new MessageRuleImpl(agentContext.newId("Rule"), stringArrayArray[9], this, "address_of"));
        this.addRule(new MessageRuleImpl(agentContext.newId("Rule"), stringArrayArray[10], this, "your_relations"));
        this.addRule(new MessageRuleImpl(agentContext.newId("Rule"), stringArrayArray[11], this, "has_ability"));
        this.addRule(new MessageRuleImpl(agentContext.newId("Rule"), stringArrayArray[12], this, "isa_facilitator"));
        this.addRule(new MessageRuleImpl(agentContext.newId("Rule"), stringArrayArray[13], this, "kill_yourself"));
        this.addRule(new MessageRuleImpl(agentContext.newId("Rule"), stringArrayArray[14], this, "log_specified_ability"));
        this.addRule(new MessageRuleImpl(agentContext.newId("Rule"), stringArrayArray[15], this, "cancel_specified_ability"));
        this.addRule(new MessageRuleImpl(agentContext.newId("Rule"), stringArrayArray[16], this, "add_agents_abilities"));
        this.addRule(new MessageRuleImpl(agentContext.newId("Rule"), stringArrayArray[17], this, "add_information"));
        this.setName("MsgHandler");
        this.start();
    }

    public AgentContext getAgentContext() {
        return this.context;
    }

    public void lowerStatus() {
    }

    public void stopProcessing() {
        this.processing = false;
    }

    private MailBox waitForSetUp() {
        MailBox mailBox = this.context.MailBox();
        while (mailBox == null) {
            try {
                MsgHandler.sleep(300L);
                mailBox = this.context.MailBox();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return mailBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.processing = true;
            MailBox mailBox = this.waitForSetUp();
            int n = 0;
            while (this.processing) {
                Queue queue = this.handleQ;
                synchronized (queue) {
                    Performative performative = (Performative)this.handleQ.dequeue();
                    this.debug("processing:" + performative.toString());
                    Core.DEBUG(1, "MsgHandler processing msg from ...\n" + performative.getSender());
                    try {
                        this.MessageRootNode.evaluate(null, performative);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                MsgHandler.yield();
                if (++n <= 100) continue;
                System.gc();
                n = 0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void processMessage(Performative performative) {
        this.handleQ.enqueue(performative);
    }

    public Queue getMessageQueue() {
        return this.handleQ;
    }

    public synchronized void addRule(MessageRule messageRule) {
        MsgNode msgNode = null;
        Core.DEBUG(1, "Compiling msg processing rule ...\n\t" + messageRule);
        MessagePattern messagePattern = messageRule.getPattern();
        MsgNode msgNode2 = this.MessageRootNode;
        Core.DEBUG(3, "=r");
        Core.DEBUG(4, "=r[" + msgNode2 + "]");
        ++msgNode2.use_count;
        msgNode = msgNode2;
        RE[] rEArray = messagePattern.listValues();
        String[] stringArray = messagePattern.listAttributes();
        for (int i = 0; i < rEArray.length; ++i) {
            if (rEArray[i] == null) continue;
            msgNode2 = new AttributeNode(this, stringArray[i], rEArray[i]);
            boolean bl = false;
            for (int j = 0; !bl && j < this.attributeNodes.size(); ++j) {
                bl = msgNode2.equals(this.attributeNodes.elementAt(j));
                if (!bl) continue;
                msgNode2 = (MsgNode)this.attributeNodes.elementAt(j);
            }
            if (!bl) {
                this.attributeNodes.addElement(msgNode2);
                Core.DEBUG(3, "+m");
                Core.DEBUG(4, "+m[" + msgNode2 + "]");
            } else {
                Core.DEBUG(3, "=m");
                Core.DEBUG(4, "=m[" + msgNode2 + "]");
            }
            ++msgNode2.use_count;
            msgNode.addSuccessor(messageRule.getName(), msgNode2);
            msgNode = msgNode2;
        }
        ActionNode actionNode = new ActionNode(this, messageRule.getName(), messageRule.getAction());
        ++actionNode.use_count;
        msgNode2.addSuccessor(messageRule.getName(), actionNode);
        Core.DEBUG(3, "+a");
        Core.DEBUG(4, "+a[" + actionNode + "]");
        this.notifyMonitors(0, new MessageHandlerEvent((Object)this, messageRule, 1L));
    }

    public void removeRule(String string) {
        this.MessageRootNode.remove(string);
        this.notifyMonitors(2, new MessageHandlerEvent((Object)this, string, 2L));
    }

    public synchronized Object execRule(String string, Object object, String string2, Performative performative) {
        Class<?> clazz = object.getClass();
        try {
            Class[] classArray = new Class[]{performative.getClass()};
            Object[] objectArray = new Object[]{performative};
            Core.DEBUG(2, "Invoking method " + string2 + " of class " + clazz.getName() + " with parameter " + performative);
            Method method = clazz.getMethod(string2, classArray);
            this.notifyMonitors(1, new MessageHandlerEvent(this, string, object, string2, performative, 4L));
            return method.invoke(object, objectArray);
        }
        catch (Throwable throwable) {
            Core.USER_ERROR("MsgHandler - Error invoking target: [" + string + "::" + object.getClass().getName() + "." + string2 + "()]\nwith args...\n" + performative + "\n" + throwable);
            this.notifyMonitors(3, new MessageHandlerEvent(this, string, object, string2, performative, 8L));
            return null;
        }
    }

    protected void adviseAll(Address address) {
        Enumeration enumeration = this.addressQueryTable.keys();
        MailBox mailBox = this.context.MailBox();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.addressQueryTable.get(string);
            Performative performative = new Performative("inform");
            performative.setReceiver(string);
            performative.setContent(((Object)address).toString());
            performative.setInReplyTo(string2);
            mailBox.sendMsg(performative);
        }
    }

    public void register(Performative performative) {
        try {
            Object object;
            if (this.context.whoami().equalsIgnoreCase("ANServer")) {
                object = new Performative(performative);
                ((Performative)object).setReceiver("ams");
                ((Performative)object).send(this.context);
            }
            if ((object = performative.getReplyWith()) == null) {
                this.refuse(performative, "no reply-with tag");
                return;
            }
            String string = this.context.Clock().initData();
            if (string != null) {
                Performative performative2 = new Performative("inform");
                performative2.setReceiver(performative.getSender());
                performative2.setInReplyTo((String)object);
                performative2.setContent(string + " " + System.currentTimeMillis());
                this.context.MailBox().sendMsg(performative2);
            }
            this.adviseAll(performative.getAddress());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void deregister(Performative performative) {
        String string;
        String string2 = performative.getSender();
        Address address = performative.getAddress();
        if (address != null) {
            this.context.MailBox().del(address);
        }
        if (this.addressQueryTable.containsKey(string2)) {
            this.addressQueryTable.remove(string2);
        }
        if ((string = performative.getReplyWith()) != null) {
            Performative performative2 = new Performative("inform");
            performative2.setReceiver(performative.getSender());
            performative2.setInReplyTo(string);
            performative2.setContent("done deregister");
            this.context.MailBox().sendMsg(performative2);
        }
        this.debug("Deregister message : " + performative.toString());
    }

    public void kill_yourself(Performative performative) {
        this.context.Agent().notifyMonitors(1);
        System.exit(0);
    }

    public void add_task(Performative performative) {
        MsgContentHandler msgContentHandler = new MsgContentHandler(performative.getContent());
        if (this.context.TaskDb() != null) {
            Vector vector = ZeusParser.taskList(this.context.OntologyDb(), msgContentHandler.data());
            this.context.TaskDb().add(vector);
            this.inform(performative, "done add_task");
        } else {
            this.refuse(performative, "no task database");
        }
    }

    public void modify_task(Performative performative) {
        MsgContentHandler msgContentHandler = new MsgContentHandler(performative.getContent());
        if (this.context.TaskDb() != null) {
            Vector vector = ZeusParser.taskList(this.context.OntologyDb(), msgContentHandler.data());
            this.context.TaskDb().add(vector);
            this.inform(performative, "done modify_task");
        } else {
            this.refuse(performative, "no task database");
        }
    }

    public void delete_task(Performative performative) {
        MsgContentHandler msgContentHandler = new MsgContentHandler(performative.getContent());
        if (this.context.TaskDb() != null) {
            this.context.TaskDb().deleteTask(msgContentHandler.data());
            this.inform(performative, "done delete_task");
        } else {
            this.refuse(performative, "no task database");
        }
    }

    public void cancel_message(Performative performative) {
        this.context.MailBox().stopLoggingMessages(performative.getSender());
    }

    public void cancel_report(Performative performative) {
        this.reportQueryTable.remove(performative.getSender());
        if (this.reportQueryTable.isEmpty()) {
            this.reportLogger.stopLogging();
            this.reportLogger = null;
        }
    }

    public void cancel_specified_ability(Performative performative) {
        MsgContentHandler msgContentHandler = new MsgContentHandler(performative.getContent());
        if (msgContentHandler.data() == null) {
            this.refuse(performative, "no key specified");
            return;
        }
        this.abilityQueryTable.remove(msgContentHandler.data());
        if (this.abilityQueryTable.isEmpty()) {
            this.abilityLogger.stopLogging();
            this.abilityLogger = null;
        }
    }

    public void cancel_address(Performative performative) {
        this.addressQueryTable.remove(performative.getSender());
    }

    public void log_message(Performative performative) {
        String string = performative.getReplyWith();
        if (string == null) {
            this.refuse(performative, "no reply-with key");
            return;
        }
        this.context.MailBox().logMessages(performative.getSender(), string);
    }

    public void log_report(Performative performative) {
        String string = performative.getReplyWith();
        if (string == null) {
            this.refuse(performative, "no reply-with key");
            return;
        }
        if (this.context.Planner() == null) {
            this.refuse(performative, "no planner");
            return;
        }
        this.reportQueryTable.put(performative.getSender(), string);
        if (this.reportLogger == null) {
            this.reportLogger = new ReportLogger();
        }
    }

    public void log_address(Performative performative) {
        String string = performative.getReplyWith();
        if (string == null) {
            this.refuse(performative, "no reply-with key");
            return;
        }
        this.addressQueryTable.put(performative.getSender(), string);
        Vector vector = this.context.MailBox().listAddresses();
        if (!vector.isEmpty()) {
            Performative performative2 = new Performative("inform");
            performative2.setReceiver(performative.getSender());
            performative2.setInReplyTo(string);
            performative2.setContent(Misc.concat(vector));
            this.context.MailBox().sendMsg(performative2);
        }
    }

    public void log_specified_ability(Performative performative) {
        Object object;
        String string = performative.getReplyWith();
        if (string == null) {
            this.refuse(performative, "no reply-with key");
            return;
        }
        MsgContentHandler msgContentHandler = new MsgContentHandler(performative.getContent());
        if (msgContentHandler.data() == null) {
            this.refuse(performative, "no ability specified");
            return;
        }
        if (this.context.OrganisationDb() == null) {
            this.refuse(performative, "no organization database");
            return;
        }
        AbilitySpec abilitySpec = ZeusParser.abilitySpec(this.context.OntologyDb(), msgContentHandler.data());
        if (abilitySpec == null) {
            this.refuse(performative, "no ability specified");
            return;
        }
        Vector vector = this.context.OrganisationDb().findAll(abilitySpec);
        if (!vector.isEmpty()) {
            object = new Performative("inform");
            ((Performative)object).setContent(Misc.concat(vector));
            ((Performative)object).setReceiver(performative.getSender());
            ((Performative)object).setInReplyTo(string);
            this.context.MailBox().sendMsg((Performative)object);
        }
        object = new Object[]{performative.getSender(), abilitySpec};
        this.abilityQueryTable.put(string, object);
        if (this.abilityLogger == null) {
            this.abilityLogger = new AbilityLogger();
        }
    }

    public void address_of(Performative performative) {
        Address address;
        String string = performative.getContent();
        String string2 = performative.getReplyWith();
        if (string2 == null) {
            this.refuse(performative, "no reply-with key");
            return;
        }
        if (string == null) {
            this.failure(performative, "no content");
            return;
        }
        MsgContentHandler msgContentHandler = new MsgContentHandler(string);
        if (msgContentHandler.data() != null && (address = this.context.MailBox().lookup(msgContentHandler.data())) != null) {
            Performative performative2 = new Performative("inform");
            performative2.setReceiver(performative.getSender());
            performative2.setInReplyTo(string2);
            performative2.setContent(((Object)address).toString());
            this.context.MailBox().sendMsg(performative2);
        } else {
            this.failure(performative, "address not known");
        }
    }

    public void your_abilities(Performative performative) {
        try {
            String string = performative.getContent();
            String string2 = performative.getReplyWith();
            if (string2 == null) {
                this.refuse(performative, "no reply-with key");
                return;
            }
            if (this.context.OrganisationDb() == null) {
                this.refuse(performative, "no organization database");
                return;
            }
            Vector vector = this.context.OrganisationDb().abilitiesOf(this.context.whoami());
            if (vector.isEmpty()) {
                this.failure(performative, "no abilities");
                return;
            }
            Performative performative2 = new Performative("inform");
            performative2.setContent(Misc.concat(vector));
            performative2.setReceiver(performative.getSender());
            performative2.setInReplyTo(string2);
            this.context.MailBox().sendMsg(performative2);
            this.sendServiceDescriptions(performative.getSender(), performative.getReplyWith());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void sendServiceDescriptions(String string, String string2) {
        try {
            TaskDb taskDb = this.context.getTaskDb();
            Enumeration enumeration = taskDb.keys();
            while (enumeration.hasMoreElements()) {
                Hashtable hashtable = (Hashtable)taskDb.get(enumeration.nextElement());
                Enumeration enumeration2 = hashtable.elements();
                while (enumeration2.hasMoreElements()) {
                    Task task = (Task)enumeration2.nextElement();
                    this.sendProfile(task, this.context, string, string2);
                    this.sendInstance(task, this.context, string, string2);
                    this.sendInstanceRange(task, this.context, string, string2);
                    this.sendProcess(task, this.context, string, string2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void sendProfile(Task task, AgentContext agentContext, String string, String string2) {
        String string3 = task.getServiceDesc(agentContext);
        if (string3 != null && string3.length() > 0) {
            Performative performative = new Performative("inform");
            performative.setReceiver(string);
            performative.setInReplyTo(string2);
            performative.setContent("( :serviceProfile (\"" + string3 + "\"))");
            performative.send(agentContext);
        }
    }

    private void sendInstance(Task task, AgentContext agentContext, String string, String string2) {
        String string3 = task.getInstanceDetails(agentContext);
        if (string3 != null && string3.length() > 0) {
            Performative performative = new Performative("inform");
            performative.setReceiver(string);
            performative.setInReplyTo(string2);
            performative.setContent("( :serviceInstance (\"" + string3 + "\"))");
            performative.send(agentContext);
        }
    }

    private void sendInstanceRange(Task task, AgentContext agentContext, String string, String string2) {
        String string3 = task.getInstanceRange(agentContext);
        if (string3 != null && string3.length() > 0) {
            Performative performative = new Performative("inform");
            performative.setReceiver(string);
            performative.setInReplyTo(string2);
            performative.setContent("( :serviceRange (:task " + task.getName() + " :content \"" + string3 + "\"))");
            performative.send(agentContext);
        }
    }

    private void sendProcess(Task task, AgentContext agentContext, String string, String string2) {
        String string3 = task.getProcessModel(agentContext);
        if (string3 != null && string3.length() > 0) {
            Performative performative = new Performative("inform");
            performative.setReceiver(string);
            performative.setInReplyTo(string2);
            performative.setContent("( :processModel (\"" + string3 + "\"))");
            performative.send(agentContext);
        }
    }

    public void your_relations(Performative performative) {
        String string = performative.getContent();
        String string2 = performative.getReplyWith();
        if (string2 == null) {
            this.refuse(performative, "no reply-with key");
            return;
        }
        if (this.context.OrganisationDb() == null) {
            this.refuse(performative, "no organization database");
            return;
        }
        Vector vector = this.context.OrganisationDb().allRelations();
        if (vector.isEmpty()) {
            this.failure(performative, "no relations");
            return;
        }
        Performative performative2 = new Performative("inform");
        performative2.setContent(Misc.concat(vector));
        performative2.setReceiver(performative.getSender());
        performative2.setInReplyTo(string2);
        this.context.MailBox().sendMsg(performative2);
    }

    public void has_ability(Performative performative) {
        String string = performative.getContent();
        String string2 = performative.getReplyWith();
        if (string2 == null) {
            this.refuse(performative, "no reply-with key");
            return;
        }
        MsgContentHandler msgContentHandler = new MsgContentHandler(string);
        if (msgContentHandler.data() == null) {
            this.refuse(performative, "no ability specified");
            return;
        }
        if (this.context.OrganisationDb() == null) {
            this.refuse(performative, "no organization database");
            return;
        }
        AbilitySpec abilitySpec = ZeusParser.abilitySpec(this.context.OntologyDb(), msgContentHandler.data());
        if (abilitySpec == null) {
            this.refuse(performative, "no ability specified");
            return;
        }
        Vector vector = this.context.OrganisationDb().findAll(abilitySpec);
        if (vector.isEmpty()) {
            this.failure(performative, "no abilities known");
            return;
        }
        Performative performative2 = new Performative("inform");
        performative2.setContent(Misc.concat(vector));
        performative2.setReceiver(performative.getSender());
        performative2.setInReplyTo(string2);
        this.context.MailBox().sendMsg(performative2);
    }

    public void isa_facilitator(Performative performative) {
        MsgContentHandler msgContentHandler = new MsgContentHandler(performative.getContent());
        this.context.addFacilitator(msgContentHandler.data());
    }

    public void add_agents_abilities(Performative performative) {
        MsgContentHandler msgContentHandler = new MsgContentHandler(performative.getContent());
        Vector vector = ZeusParser.abilitySpecList(this.context.OntologyDb(), msgContentHandler.data());
        String string = performative.getSender();
        this.context.OrganisationDb().add(string, vector);
    }

    public void add_information(Performative performative) {
        try {
            MsgContentHandler msgContentHandler = new MsgContentHandler(performative.getContent());
            Vector vector = ZeusParser.factList(this.context.OntologyDb(), msgContentHandler.data());
            this.context.ResourceDb().add(this.dereference(vector));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void refuse(Performative performative, String string) {
        Performative performative2 = new Performative("refuse");
        performative2.setReceiver(performative.getSender());
        performative2.setContent(string);
        String string2 = performative.getReplyWith();
        if (string2 != null) {
            performative2.setInReplyTo(string2);
        }
        this.context.MailBox().sendMsg(performative2);
    }

    protected void failure(Performative performative, String string) {
        Performative performative2 = new Performative("failure");
        performative2.setReceiver(performative.getSender());
        performative2.setContent(string);
        String string2 = performative.getReplyWith();
        if (string2 != null) {
            performative2.setInReplyTo(string2);
        }
        this.context.MailBox().sendMsg(performative2);
    }

    protected void not_understood(Performative performative, String string) {
        Performative performative2 = new Performative("failure");
        performative2.setReceiver(performative.getSender());
        performative2.setContent(string);
        String string2 = performative.getReplyWith();
        if (string2 != null) {
            performative2.setInReplyTo(string2);
        }
        this.context.MailBox().sendMsg(performative2);
    }

    protected void inform(Performative performative, String string) {
        Performative performative2 = new Performative("inform");
        performative2.setReceiver(performative.getSender());
        performative2.setContent(string);
        String string2 = performative.getReplyWith();
        if (string2 != null) {
            performative2.setInReplyTo(string2);
        }
        this.context.MailBox().sendMsg(performative2);
    }

    public void addMessageHandlerMonitor(MessageHandlerMonitor messageHandlerMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.eventMonitor[0].add(messageHandlerMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[1].add(messageHandlerMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[2].add(messageHandlerMonitor);
        }
        if ((l & 8L) != 0L) {
            this.eventMonitor[3].add(messageHandlerMonitor);
        }
    }

    public void removeMessageHandlerMonitor(MessageHandlerMonitor messageHandlerMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.eventMonitor[0].remove(messageHandlerMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[1].remove(messageHandlerMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[2].remove(messageHandlerMonitor);
        }
        if ((l & 8L) != 0L) {
            this.eventMonitor[3].remove(messageHandlerMonitor);
        }
    }

    protected void notifyMonitors(int n, MessageHandlerEvent messageHandlerEvent) {
        if (this.eventMonitor[n].isEmpty()) {
            return;
        }
        Enumeration enumeration = this.eventMonitor[n].elements();
        switch (n) {
            case 0: {
                while (enumeration.hasMoreElements()) {
                    MessageHandlerMonitor messageHandlerMonitor = (MessageHandlerMonitor)enumeration.nextElement();
                    messageHandlerMonitor.messageRuleAddedEvent(messageHandlerEvent);
                }
                break;
            }
            case 1: {
                while (enumeration.hasMoreElements()) {
                    MessageHandlerMonitor messageHandlerMonitor = (MessageHandlerMonitor)enumeration.nextElement();
                    messageHandlerMonitor.messageRuleFiredEvent(messageHandlerEvent);
                }
                break;
            }
            case 2: {
                while (enumeration.hasMoreElements()) {
                    MessageHandlerMonitor messageHandlerMonitor = (MessageHandlerMonitor)enumeration.nextElement();
                    messageHandlerMonitor.messageRuleDeletedEvent(messageHandlerEvent);
                }
                break;
            }
            case 3: {
                while (enumeration.hasMoreElements()) {
                    MessageHandlerMonitor messageHandlerMonitor = (MessageHandlerMonitor)enumeration.nextElement();
                    messageHandlerMonitor.messageRuleFailedEvent(messageHandlerEvent);
                }
                break;
            }
        }
    }

    protected final Vector dereference(Vector vector) {
        Vector<Object> vector2 = new Vector<Object>();
        try {
            Object e = vector.elementAt(0);
            if (e instanceof Fact) {
                for (int i = 0; i < vector.size(); ++i) {
                    Fact fact = (Fact)vector.elementAt(i);
                    fact = fact.duplicate("var", this.context.GenSym());
                    vector2.addElement(fact);
                }
            } else {
                for (int i = 0; i < vector.size(); ++i) {
                    Goal goal = (Goal)vector.elementAt(i);
                    goal = goal.duplicate("var", this.context.GenSym());
                    vector2.addElement(goal);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector2;
    }

    private void debug(String string) {
    }

    class AbilityLogger
    extends AbilityAdapter {
        public AbilityLogger() {
            MsgHandler.this.context.OrganisationDb().addAbilityMonitor(this, 1L);
        }

        public void stopLogging() {
            MsgHandler.this.context.OrganisationDb().removeAbilityMonitor(this, 1L);
        }

        public void abilityAddedEvent(AbilityEvent abilityEvent) {
            if (MsgHandler.this.abilityQueryTable.isEmpty()) {
                return;
            }
            Enumeration enumeration = MsgHandler.this.abilityQueryTable.keys();
            AbilitySpec abilitySpec = abilityEvent.getAbility();
            Fact fact = abilitySpec.getFact();
            int n = abilitySpec.getTime();
            double d = abilitySpec.getCost();
            Bindings bindings = new Bindings(MsgHandler.this.context.whoami());
            while (enumeration.hasMoreElements()) {
                bindings.clear();
                String string = (String)enumeration.nextElement();
                Object[] objectArray = (Object[])MsgHandler.this.abilityQueryTable.get(string);
                AbilitySpec abilitySpec2 = (AbilitySpec)objectArray[1];
                Fact fact2 = abilitySpec2.getFact();
                int n2 = abilitySpec2.getTime();
                double d3 = abilitySpec2.getCost();
                if (n != 0 && n2 > n || d != 0.0 && !(d3 <= d) || !fact2.unifiesWith(fact, bindings)) continue;
                Performative performative = new Performative("inform");
                performative.setContent(abilityEvent.getAbilityDbItem().toString());
                performative.setReceiver((String)objectArray[0]);
                performative.setInReplyTo(string);
                MsgHandler.this.context.MailBox().sendMsg(performative);
            }
        }
    }

    protected class ReportLogger
    extends PlanStepAdapter {
        public ReportLogger() {
            MsgHandler.this.context.Planner().addPlanStepMonitor(this, 4L);
        }

        public void stopLogging() {
            MsgHandler.this.context.Planner().addPlanStepMonitor(this, 4L);
        }

        public void planStepStateChangedEvent(PlanStepEvent planStepEvent) {
            if (MsgHandler.this.reportQueryTable.isEmpty()) {
                return;
            }
            PlanRecord planRecord = planStepEvent.getPlanRecord();
            switch (planRecord.getState()) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    ReportRec reportRec = planRecord.report();
                    Enumeration enumeration = MsgHandler.this.reportQueryTable.keys();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        String string2 = (String)MsgHandler.this.reportQueryTable.get(string);
                        Performative performative = new Performative("inform");
                        performative.setContent(reportRec.toString());
                        performative.setReceiver(string);
                        performative.setInReplyTo(string2);
                        MsgHandler.this.context.MailBox().sendMsg(performative);
                    }
                    break;
                }
            }
        }
    }
}

