/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import zeus.actors.AgentContext;
import zeus.actors.InTray;
import zeus.actors.PostMan;
import zeus.actors.Server;
import zeus.actors.event.MessageEvent;
import zeus.actors.event.MessageMonitor;
import zeus.concepts.Address;
import zeus.concepts.AddressBook;
import zeus.concepts.MessageRuleImpl;
import zeus.concepts.Performative;
import zeus.concepts.ZeusAddress;
import zeus.concepts.ZeusParser;
import zeus.util.Assert;
import zeus.util.Clock;
import zeus.util.HSet;
import zeus.util.KeyValue;
import zeus.util.Queue;
import zeus.util.Time;

public class MailBox {
    protected HSet[] eventMonitor = new HSet[4];
    public static final int RECEIVE = 0;
    public static final int QUEUE = 1;
    public static final int DISPATCH = 2;
    public static final int NOT_DISPATCH = 3;
    protected Queue inMail = new Queue("Zeus inMail");
    protected Queue outMail = new Queue("Zeus outMail");
    protected Queue ccMail = new Queue("Zeus ccMail");
    protected Hashtable asTable = new Hashtable();
    protected Hashtable visualisers = new Hashtable();
    protected Server server;
    protected PostMan[] postman;
    protected Address myAddress;
    protected AgentContext context;

    public MailBox() {
    }

    public MailBox(AgentContext agentContext) {
        Assert.notNull(agentContext);
        this.context = agentContext;
        agentContext.set(this);
        for (int i = 0; i < this.eventMonitor.length; ++i) {
            this.eventMonitor[i] = new HSet();
        }
        agentContext.set(new AddressBook());
        this.server = new Server(agentContext, this, this.inMail);
        this.myAddress = this.server.getAddress();
        this.postman = new PostMan[2];
        this.postman[0] = new PostMan(this, this.outMail, this.ccMail, this.myAddress);
        this.postman[1] = new PostMan(this, this.ccMail, this.myAddress);
        String string = agentContext.newId();
        String[] stringArray = new String[]{"type", "inform", "in-reply-to", string};
        agentContext.MsgHandler().addRule(new MessageRuleImpl(agentContext.newId("Rule"), stringArray, 0, this, "register"));
        for (int i = 0; i < agentContext.nameservers().size(); ++i) {
            Address address = (Address)agentContext.nameservers().elementAt(i);
            agentContext.AddressBook().add(address);
            Performative performative = new Performative("request");
            performative.setReceiver(address.getName());
            performative.setReplyWith(string);
            performative.setContent("register");
            this.sendMsg(performative);
        }
    }

    public void register(Performative performative) {
        String string = performative.getContent();
        if (this.context.Clock() == null && string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            long l = 160L;
            long l2 = Long.parseLong(stringTokenizer.nextToken());
            long l3 = Long.parseLong(stringTokenizer.nextToken());
            long l4 = Long.parseLong(stringTokenizer.nextToken());
            long l5 = System.currentTimeMillis();
            long l6 = l5 - (l4 + l);
            this.context.set(new Clock(l2 + l6, l3));
        }
    }

    public AgentContext getAgentContext() {
        return this.context;
    }

    public void del(Address address) {
        Assert.notNull(address);
        this.context.AddressBook().del(address);
        KeyValue keyValue = (KeyValue)this.asTable.remove(address.getName());
        if (keyValue != null) {
            for (int i = 0; i < this.postman.length; ++i) {
                this.postman[i].addressReceived(keyValue.key);
            }
        }
    }

    public void del(Vector vector) {
        Assert.notNull(vector);
        for (int i = 0; i < vector.size(); ++i) {
            this.context.AddressBook().del((Address)vector.elementAt(i));
        }
    }

    public void add(Address address) {
        Assert.notNull(address);
        this.context.AddressBook().add(address);
    }

    public void add(Vector vector) {
        Assert.notNull(vector);
        for (int i = 0; i < vector.size(); ++i) {
            this.context.AddressBook().add((Address)vector.elementAt(i));
        }
    }

    public Address lookup(String string) {
        Assert.notNull(string);
        return this.context.AddressBook().lookup(string);
    }

    public void stopDispatching() {
        for (int i = 0; i < this.postman.length; ++i) {
            this.postman[i].stopDispatching();
        }
    }

    public void stopProcessing() {
        this.server.stopProcessing();
    }

    public void lowerStatus() {
        for (int i = 0; i < this.postman.length; ++i) {
            this.postman[i].lowerStatus();
        }
        this.server.lowerStatus();
    }

    public String addressSought(String string) {
        KeyValue keyValue;
        double d = this.context.now();
        Enumeration enumeration = this.asTable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            keyValue = (KeyValue)this.asTable.get(string2);
            if (!(d - keyValue.value >= this.context.getAddressBookRefresh())) continue;
            this.asTable.remove(string2);
            this.context.MsgHandler().removeRule(keyValue.key);
        }
        keyValue = (KeyValue)this.asTable.get(string);
        if (keyValue == null) {
            String string3 = this.context.newId();
            String[] stringArray = new String[]{"type", "inform", "in-reply-to", string3};
            this.context.MsgHandler().addRule(new MessageRuleImpl(string3, stringArray, 0, this, "addressReceived"));
            for (int i = 0; i < this.context.nameservers().size(); ++i) {
                Address address = (Address)this.context.nameservers().elementAt(i);
                Performative performative = new Performative("query-ref");
                performative.setReceiver(address.getName());
                performative.setReplyWith(string3);
                performative.setContent("address_of " + string);
                this.sendMsg(performative);
            }
            d = this.context.now();
            if (!this.context.nameservers().isEmpty()) {
                this.asTable.put(string, new KeyValue(string3, d += this.context.getAddressTimeout()));
                return string3;
            }
            return null;
        }
        if (keyValue.value > this.context.now()) {
            return keyValue.key;
        }
        return null;
    }

    public void addressReceived(Performative performative) {
        String string = performative.getInReplyTo();
        Address address = ZeusParser.address(performative.getContent());
        this.add(address);
        this.asTable.remove(address.getName());
        for (int i = 0; i < this.postman.length; ++i) {
            this.postman[i].addressReceived(string);
        }
    }

    public void logMessages(String string, String string2) {
        Assert.notNull(string);
        Assert.notNull(string2);
        this.visualisers.put(string, string2);
    }

    public void stopLoggingMessages(String string) {
        Assert.notNull(string);
        this.visualisers.remove(string);
    }

    public void informVisualisers(Performative performative) {
        Enumeration enumeration = this.visualisers.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.visualisers.get(string);
            Performative performative2 = new Performative("inform");
            performative2.setReceiver(string);
            performative2.setInReplyTo(string2);
            performative2.setContent(performative.toString().trim());
            this.ccMail.enqueue(performative2);
            this.notifyMonitors(performative2, 1);
        }
    }

    public Address getAddress() {
        return this.myAddress;
    }

    public void shutdown() {
        for (int i = 0; i < this.context.nameservers().size(); ++i) {
            Address address = (Address)this.context.nameservers().elementAt(i);
            Performative performative = new Performative("request");
            performative.setContent("deregister");
            performative.setReceiver(address.getName());
            this.sendMsg(performative);
        }
    }

    public void postErrorMsg(Performative performative, String string) {
        this.notifyMonitors(performative, 3);
        Performative performative2 = new Performative("failure");
        performative2.setSender(this.myAddress.getName());
        performative2.setReceiver(this.myAddress.getName());
        performative2.setAddress(this.myAddress);
        String string2 = performative.getReplyWith();
        if (string2 != null) {
            performative2.setInReplyTo(string2);
        }
        performative2.setContent(string + " " + performative);
        Time time = this.context.currentTime();
        if (time != null) {
            performative2.setSendTime(time);
        }
        this.server.newMsg(performative2);
    }

    public void sendMsg(Performative performative) {
        this.postman[0].push(performative);
        this.notifyMonitors(performative, 1);
    }

    public Performative nextMsg() {
        Object object = this.inMail.dequeue();
        try {
            Performative performative = (Performative)object;
            return performative;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new Performative(object.toString());
        }
    }

    public Vector listAddresses() {
        Vector<ZeusAddress> vector = new Vector<ZeusAddress>(10);
        Enumeration enumeration = this.context.AddressBook().elements();
        while (enumeration.hasMoreElements()) {
            Address address = (Address)enumeration.nextElement();
            vector.addElement(new ZeusAddress(address));
        }
        return vector;
    }

    public void addMessageMonitor(MessageMonitor messageMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.eventMonitor[0].add(messageMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[1].add(messageMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[2].add(messageMonitor);
        }
        if ((l & 8L) != 0L) {
            this.eventMonitor[3].add(messageMonitor);
        }
    }

    public void removeMessageMonitor(MessageMonitor messageMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.eventMonitor[0].remove(messageMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[1].remove(messageMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[2].remove(messageMonitor);
        }
        if ((l & 8L) != 0L) {
            this.eventMonitor[3].remove(messageMonitor);
        }
    }

    public void notifyMonitors(Performative performative, int n) {
        if (this.eventMonitor[n].isEmpty()) {
            return;
        }
        Enumeration enumeration = this.eventMonitor[n].elements();
        switch (n) {
            case 0: {
                MessageEvent messageEvent = new MessageEvent(this, performative, 1L);
                while (enumeration.hasMoreElements()) {
                    MessageMonitor messageMonitor = (MessageMonitor)enumeration.nextElement();
                    messageMonitor.messageReceivedEvent(messageEvent);
                }
                break;
            }
            case 1: {
                MessageEvent messageEvent = new MessageEvent(this, performative, 2L);
                while (enumeration.hasMoreElements()) {
                    MessageMonitor messageMonitor = (MessageMonitor)enumeration.nextElement();
                    messageMonitor.messageQueuedEvent(messageEvent);
                }
                break;
            }
            case 2: {
                MessageEvent messageEvent = new MessageEvent(this, performative, 4L);
                while (enumeration.hasMoreElements()) {
                    MessageMonitor messageMonitor = (MessageMonitor)enumeration.nextElement();
                    messageMonitor.messageDispatchedEvent(messageEvent);
                }
                break;
            }
            case 3: {
                MessageEvent messageEvent = new MessageEvent(this, performative, 8L);
                while (enumeration.hasMoreElements()) {
                    MessageMonitor messageMonitor = (MessageMonitor)enumeration.nextElement();
                    messageMonitor.messageNotDispatchedEvent(messageEvent);
                }
                break;
            }
        }
    }

    public InTray getInTray() {
        return this.server;
    }
}

