/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors;

import java.util.Enumeration;
import zeus.actors.AgentContext;
import zeus.actors.Planner;
import zeus.actors.event.ClockEvent;
import zeus.actors.event.ClockMonitor;
import zeus.actors.rtn.Engine;
import zeus.util.Assert;
import zeus.util.HSet;

public class ExecutionMonitor
extends Thread {
    public static final int TICK = 0;
    public static final double UPDATE_FRACTION = 0.25;
    private HSet[] eventMonitor = new HSet[1];
    protected boolean monitoring;
    protected AgentContext context = null;

    public ExecutionMonitor() {
    }

    public ExecutionMonitor(AgentContext agentContext) {
        Assert.notNull(agentContext);
        this.context = agentContext;
        agentContext.set(this);
        for (int i = 0; i < this.eventMonitor.length; ++i) {
            this.eventMonitor[i] = new HSet();
        }
        this.setName("ExecutionMonitor");
        this.start();
    }

    public AgentContext getAgentContext() {
        return this.context;
    }

    public void stopMonitoring() {
        this.monitoring = false;
    }

    public void run() {
        long l = this.context.getClockStep();
        int n = (int)this.context.now();
        this.monitoring = true;
        this.setPriority(5);
        while (this.monitoring) {
            Engine engine;
            long l2;
            Planner planner = this.context.Planner();
            double d = this.context.now();
            long l3 = l2 = d < (double)(n + 1) && d + 0.25 > (double)(n + 1) ? (long)(((double)(n + 1) - d) * (double)l) : (long)(0.25 * (double)l);
            if ((int)d == n + 1) {
                n = (int)d;
                this.notifyMonitors(n, 0);
                engine = this.context.getEngine();
                if (planner != null) {
                    engine.callShuffle();
                }
            }
            if (planner != null) {
                engine = this.context.getEngine();
                engine.callCheckRecords();
            }
            try {
                if (l2 < 100L) {
                    l2 = 10L;
                }
                ExecutionMonitor.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            ExecutionMonitor.yield();
        }
    }

    public void addClockMonitor(ClockMonitor clockMonitor, long l) {
        Assert.notNull(clockMonitor);
        if ((l & 1L) != 0L) {
            this.eventMonitor[0].add(clockMonitor);
        }
    }

    public void removeClockMonitor(ClockMonitor clockMonitor, long l) {
        Assert.notNull(clockMonitor);
        if ((l & 1L) != 0L) {
            this.eventMonitor[0].remove(clockMonitor);
        }
    }

    protected void notifyMonitors(int n, int n2) {
        if (this.eventMonitor[n2].isEmpty()) {
            return;
        }
        Enumeration enumeration = this.eventMonitor[n2].elements();
        switch (n2) {
            case 0: {
                ClockEvent clockEvent = new ClockEvent(this, n, 1L);
                while (enumeration.hasMoreElements()) {
                    ClockMonitor clockMonitor = (ClockMonitor)enumeration.nextElement();
                    clockMonitor.clockTickEvent(clockEvent);
                }
                break;
            }
        }
    }
}

