/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors;

import zeus.actors.PlanRecord;
import zeus.util.Assert;

public class EffectChain {
    public PlanRecord record = null;
    public int position = -1;
    public int amount = -1;
    public int start = -1;
    public boolean consumed = true;
    public String key = null;

    public EffectChain() {
    }

    public EffectChain(PlanRecord planRecord, int n, int n2, int n3, boolean bl) {
        Assert.notNull(planRecord);
        Assert.notFalse(n > -1);
        Assert.notFalse(n2 > 0);
        Assert.notFalse(n3 > 0);
        this.record = planRecord;
        this.position = n;
        this.amount = n2;
        this.start = n3;
        this.consumed = bl;
    }

    public EffectChain(String string, int n, int n2, boolean bl) {
        Assert.notNull(string);
        Assert.notFalse(n > 0);
        Assert.notFalse(n2 > 0);
        this.key = string;
        this.amount = n;
        this.start = n2;
        this.consumed = bl;
    }

    public EffectChain(EffectChain effectChain) {
        if (effectChain.isExternal()) {
            this.key = effectChain.key;
            this.amount = effectChain.amount;
        } else {
            this.record = effectChain.record;
            this.position = effectChain.position;
            this.amount = effectChain.amount;
        }
        this.start = effectChain.start;
        this.consumed = effectChain.consumed;
    }

    public boolean isExternal() {
        return this.key != null;
    }

    public String toString() {
        String string = "EffectChain(";
        string = this.isExternal() ? string + this.key + "," + this.amount + "," + this.start + "," + this.consumed : string + this.record + "," + this.position + "," + this.amount + "," + this.start + "," + this.consumed;
        string = string + ")";
        return string;
    }
}

