/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.actors.DecompositionStruct;
import zeus.actors.LinkInfo;
import zeus.actors.PlanRecord;
import zeus.actors.Planner;
import zeus.concepts.Bindings;
import zeus.concepts.Fact;
import zeus.concepts.Goal;
import zeus.concepts.PrimitiveTask;
import zeus.concepts.SummaryTask;
import zeus.concepts.SuppliedDb;
import zeus.concepts.SuppliedItem;
import zeus.concepts.Task;
import zeus.concepts.TaskLink;
import zeus.concepts.TaskNode;
import zeus.util.Assert;
import zeus.util.Core;
import zeus.util.KeyValue;
import zeus.util.Misc;

public class Decomposition
extends Hashtable {
    protected Vector constraints;
    protected Vector links;
    protected int node_pointer = -1;
    protected String root = null;
    protected Vector nodeList = new Vector();
    protected Planner planner = null;

    public Decomposition() {
    }

    public Decomposition(Planner planner, String string, PlanRecord planRecord, Vector vector, Goal goal, SummaryTask summaryTask) {
        int n;
        TaskLink taskLink;
        Enumeration<Object> enumeration;
        this.planner = planner;
        this.links = summaryTask.links();
        this.constraints = summaryTask.constraints();
        boolean bl = true;
        Hashtable<String, KeyValue> hashtable = new Hashtable<String, KeyValue>();
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement("end");
        int n2 = 0;
        while (!vector2.isEmpty()) {
            Vector<String> vector3 = new Vector<String>();
            enumeration = this.links.elements();
            while (enumeration.hasMoreElements()) {
                KeyValue keyValue;
                String string2;
                taskLink = (TaskLink)enumeration.nextElement();
                String string3 = taskLink.getRightNode();
                if (!vector2.contains(string3) || (string2 = taskLink.getLeftNode()).equals("begin")) continue;
                if (!vector3.contains(string2)) {
                    vector3.addElement(string2);
                }
                if (!this.containsKey(string2)) {
                    this.add(summaryTask.getNode(string2));
                    keyValue = new KeyValue(string2, n2++);
                    Assert.notFalse(hashtable.put(keyValue.key, keyValue) == null);
                } else {
                    keyValue = (KeyValue)hashtable.get(string2);
                    keyValue.value = n2++;
                }
                this.addParentNode(string2, string3);
            }
            if (bl) {
                this.determineRoot(string, planRecord, vector, goal, vector3);
                bl = false;
            }
            vector2 = vector3;
        }
        enumeration = this.links.elements();
        while (enumeration.hasMoreElements()) {
            taskLink = (TaskLink)enumeration.nextElement();
            if (!taskLink.referencesNode("begin") && !taskLink.referencesNode("end")) continue;
            this.links.removeElement(taskLink);
        }
        KeyValue keyValue = new KeyValue();
        KeyValue[] keyValueArray = new KeyValue[hashtable.size()];
        enumeration = hashtable.elements();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            keyValueArray[n3] = (KeyValue)enumeration.nextElement();
            ++n3;
        }
        n3 = 1;
        while (n3 != 0) {
            n3 = 0;
            for (n = 0; n < keyValueArray.length - 1; ++n) {
                if (!(keyValueArray[n].value > keyValueArray[n + 1].value)) continue;
                keyValue.set(keyValueArray[n]);
                keyValueArray[n].set(keyValueArray[n + 1]);
                keyValueArray[n + 1].set(keyValue);
                n3 = 1;
            }
        }
        for (n = 0; n < keyValueArray.length; ++n) {
            this.nodeList.addElement(keyValueArray[n].key);
        }
        this.node_pointer = 0;
    }

    protected void determineRoot(String string, PlanRecord planRecord, Vector vector, Goal goal, Vector vector2) {
        Assert.notFalse(vector2.size() == 1);
        Fact fact = goal.getFact();
        Bindings bindings = new Bindings(this.planner.getAgentContext().whoami());
        for (int i = 0; i < vector2.size(); ++i) {
            String string2 = (String)vector2.elementAt(i);
            DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string2);
            Fact[] factArray = decompositionStruct.node.getPostconditions();
            for (int j = 0; j < factArray.length; ++j) {
                if (!factArray[j].isSideEffect() && factArray[j].unifiesWith(fact, bindings)) {
                    decompositionStruct.node.resolve(bindings);
                    this.root = string2;
                    decompositionStruct.key = string;
                    decompositionStruct.goal = new Goal(goal);
                    decompositionStruct.parent_record = planRecord;
                    decompositionStruct.path = vector;
                    return;
                }
                bindings.clear();
            }
        }
    }

    protected void add(TaskNode taskNode) {
        DecompositionStruct decompositionStruct = new DecompositionStruct(this.planner.getAgentContext().whoami(), taskNode);
        Assert.notFalse(this.put(taskNode.getName(), decompositionStruct) == null);
    }

    protected void addParentNode(String string, String string2) {
        if (string2.equals("end")) {
            return;
        }
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        if (!decompositionStruct.parents.contains(string2)) {
            decompositionStruct.parents.addElement(string2);
            this.addChildNode(string2, string);
        }
    }

    protected void addChildNode(String string, String string2) {
        if (string2.equals("begin")) {
            return;
        }
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        if (!decompositionStruct.children.contains(string2)) {
            decompositionStruct.children.addElement(string2);
        }
    }

    public synchronized String nextNode() {
        if (this.node_pointer < this.nodeList.size()) {
            String string = (String)this.nodeList.elementAt(this.node_pointer++);
            Core.DEBUG(2, "nextNode(): id = " + string);
            return this.allParentsScheduled(string) ? string : this.nextNode();
        }
        return null;
    }

    public synchronized void reset() {
        this.node_pointer = 0;
    }

    protected TaskLink findLink(String string, String string2) {
        Enumeration enumeration = this.links.elements();
        while (enumeration.hasMoreElements()) {
            TaskLink taskLink = (TaskLink)enumeration.nextElement();
            if (!taskLink.getLeftNode().equals(string) || !taskLink.getRightNode().equals(string2)) continue;
            return taskLink;
        }
        return null;
    }

    protected boolean allParentsScheduled(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        DecompositionStruct decompositionStruct;
        String string2 = null;
        DecompositionStruct decompositionStruct2 = (DecompositionStruct)this.get(string);
        for (int i = 0; i < decompositionStruct2.parents.size(); ++i) {
            string2 = (String)decompositionStruct2.parents.elementAt(i);
            decompositionStruct = (DecompositionStruct)this.get(string2);
            Core.DEBUG(2, "allParentsScheduled(): nodeId = " + string + " parentId = " + string2 + " parent.scheduled = " + decompositionStruct.scheduled);
            if (decompositionStruct.scheduled) continue;
            return false;
        }
        if (decompositionStruct2.parents.isEmpty() || decompositionStruct2.goal != null) {
            return true;
        }
        decompositionStruct2.current_parent = (String)decompositionStruct2.parents.elementAt(0);
        DecompositionStruct decompositionStruct3 = (DecompositionStruct)this.get(decompositionStruct2.current_parent);
        decompositionStruct2.parent_record = decompositionStruct3.record;
        decompositionStruct2.key = decompositionStruct3.key;
        TaskLink taskLink = this.findLink(string, decompositionStruct2.current_parent);
        decompositionStruct2.parent_link = taskLink.getId();
        Fact fact = null;
        fact = decompositionStruct3.node.getPrecondition(taskLink.getRightGroup(), taskLink.getRightArg());
        if (decompositionStruct3.record == null) {
            decompositionStruct2.goal = new Goal(decompositionStruct3.image.whichType(), this.planner.getAgentContext().newId("subgoal"), fact, this.planner.getAgentContext().whoami());
            if (decompositionStruct3.image.isContinuous()) {
                n4 = decompositionStruct3.image.getStartTime();
                n3 = decompositionStruct3.image.getEndTime();
                int n5 = decompositionStruct3.image.getInvocations();
                n2 = (n3 - n4) / n5;
                decompositionStruct2.goal.setStartTime(n4);
                decompositionStruct2.goal.setEndTime(n3 - n2);
                decompositionStruct2.goal.setInvocations(n5);
            } else {
                decompositionStruct2.goal.setEndTime(this.getStartTime(taskLink, decompositionStruct3));
            }
            decompositionStruct2.goal.setConfirmTime(decompositionStruct3.image.getConfirmTime());
            decompositionStruct2.goal.setPriority(decompositionStruct3.image.getPriority());
            decompositionStruct2.goal.setCost(0.0);
            decompositionStruct2.goal.setRootId(decompositionStruct3.image.getRootId());
        } else {
            PrimitiveTask primitiveTask = decompositionStruct3.record.getTask();
            Fact[] factArray = ((Task)primitiveTask).getPreconditions();
            Bindings bindings = new Bindings(this.planner.getAgentContext().whoami());
            n2 = 0;
            for (n = 0; n2 == 0 && n < factArray.length; ++n) {
                if (fact.unifiesWith(factArray[n], bindings)) {
                    decompositionStruct2.goal = decompositionStruct3.record.createSubgoal(factArray[n], n);
                    n2 = 1;
                }
                bindings.clear();
            }
            Assert.notFalse(n2 != 0);
        }
        n4 = decompositionStruct2.goal.getStartTime();
        n3 = decompositionStruct2.goal.getEndTime();
        for (n2 = 0; n2 < decompositionStruct2.parents.size(); ++n2) {
            string2 = (String)decompositionStruct2.parents.elementAt(n2);
            decompositionStruct = (DecompositionStruct)this.get(string2);
            TaskLink taskLink2 = this.findLink(string, string2);
            if (decompositionStruct.record == null) {
                if (decompositionStruct.image.isContinuous()) {
                    n = decompositionStruct.image.getStartTime();
                    int n6 = decompositionStruct.image.getEndTime();
                    int n7 = decompositionStruct.image.getInvocations();
                    int n8 = (n6 - n) / n7;
                    n4 = Math.min(n4, n);
                    n3 = Math.min(n3, n6 - n8);
                    continue;
                }
                n3 = Math.min(n3, this.getStartTime(taskLink2, decompositionStruct));
                continue;
            }
            if (decompositionStruct.goal.isContinuous()) {
                n4 = Math.min(n4, decompositionStruct.record.getStartTime());
                n3 = Math.min(n3, decompositionStruct.record.getEndTime() - decompositionStruct.record.getTask().getTime());
                continue;
            }
            n3 = Math.min(n3, decompositionStruct.record.getStartTime());
        }
        decompositionStruct2.goal.setEndTime(n3);
        if (decompositionStruct2.goal.isContinuous()) {
            decompositionStruct2.goal.setStartTime(n4);
        }
        decompositionStruct2.path = Misc.copyVector(decompositionStruct3.path);
        decompositionStruct2.path.addElement(decompositionStruct3.goal.getFact());
        this.links.removeElement(taskLink);
        return true;
    }

    protected int getStartTime(TaskLink taskLink, DecompositionStruct decompositionStruct) {
        String string = (String)decompositionStruct.lookupTable.get(taskLink.getId());
        SuppliedItem suppliedItem = decompositionStruct.given.getSuppliedItem(string);
        return suppliedItem.getEarliestReservationTime();
    }

    protected String[] getReservationId(TaskLink taskLink, DecompositionStruct decompositionStruct) {
        String string = (String)decompositionStruct.lookupTable.get(taskLink.getId());
        SuppliedItem suppliedItem = decompositionStruct.given.getSuppliedItem(string);
        return suppliedItem.getReservationId();
    }

    public Fact[] getPreconditions(String string) {
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        return decompositionStruct.node.getPreconditions();
    }

    public Fact[] getPostconditions(String string) {
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        return decompositionStruct.node.getPostconditions();
    }

    public Vector getPath(String string) {
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        return decompositionStruct.path;
    }

    public Goal getGoal(String string) {
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        return decompositionStruct.goal;
    }

    public String getKey(String string) {
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        return decompositionStruct.key;
    }

    public PlanRecord getParentRecord(String string) {
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        return decompositionStruct.parent_record;
    }

    public void setRecords(String string, Vector vector) {
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        decompositionStruct.records = vector;
        decompositionStruct.record = (PlanRecord)vector.elementAt(0);
        decompositionStruct.scheduled = true;
        if (string.equals(this.root)) {
            return;
        }
        DecompositionStruct decompositionStruct2 = (DecompositionStruct)this.get(decompositionStruct.current_parent);
        if (decompositionStruct2.record == null) {
            String string2 = (String)decompositionStruct2.lookupTable.get(decompositionStruct.parent_link);
            SuppliedItem suppliedItem = decompositionStruct2.given.getSuppliedItem(string2);
            String[] stringArray = suppliedItem.getReservationId();
            String string3 = decompositionStruct.agent;
            String string4 = decompositionStruct.record.getGoal().getId();
            for (int i = 0; i < stringArray.length; ++i) {
                String string5 = suppliedItem.getReservingAgent(stringArray[i]);
                String string6 = suppliedItem.getReservationGoalId(stringArray[i]);
                String string7 = suppliedItem.getReservationCommsKey(stringArray[i]);
                int n = suppliedItem.getReservedAmount(stringArray[i]);
                int n2 = suppliedItem.getReservationTime(stringArray[i]);
                boolean bl = suppliedItem.isReservationConsumed(stringArray[i]);
                Assert.notFalse(n > 0);
                decompositionStruct2.image.addProducer(string2, stringArray[i], string7, string3, string4, string5, string6);
                decompositionStruct.record.getProducedDb().replaceOrAdd(decompositionStruct.goal.getId(), string6 + "/" + stringArray[i], n2, n, bl);
            }
        }
    }

    public boolean allNodesScheduled() {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            DecompositionStruct decompositionStruct = (DecompositionStruct)enumeration.nextElement();
            if (decompositionStruct.scheduled) continue;
            return false;
        }
        return true;
    }

    public void setQueued(String string, boolean bl) {
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        decompositionStruct.queued = bl;
    }

    public boolean isQueued(String string) {
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        return decompositionStruct.queued;
    }

    public boolean isScheduled(String string) {
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        return decompositionStruct.scheduled;
    }

    public PlanRecord getRecord(String string) {
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        return decompositionStruct.record;
    }

    public PlanRecord getRootRecord() {
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(this.root);
        return decompositionStruct.record;
    }

    public String getNodeWithGoalId(String string) {
        Core.DEBUG(3, "getNodeWithId\n" + this);
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            DecompositionStruct decompositionStruct = (DecompositionStruct)enumeration.nextElement();
            if (decompositionStruct.goal == null || !decompositionStruct.goal.getId().equals(string)) continue;
            return decompositionStruct.node.getName();
        }
        return null;
    }

    public void setImage(String string, Goal goal, String string2, String string3) {
        Core.DEBUG(3, "SetImage: node = " + string);
        Core.DEBUG(3, "SetImage: image = " + goal);
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        Core.DEBUG(3, "SetImage: st = " + decompositionStruct);
        SuppliedDb suppliedDb = goal.getSuppliedDb();
        Core.DEBUG(3, "SetImage: db = " + suppliedDb);
        Assert.notFalse(decompositionStruct.given.add(suppliedDb));
        Core.DEBUG(3, "SetImage: After assert");
        decompositionStruct.image = goal;
        decompositionStruct.agent = string2;
        decompositionStruct.scheduled = true;
        decompositionStruct.queued = false;
        DecompositionStruct decompositionStruct2 = (DecompositionStruct)this.get(decompositionStruct.current_parent);
        String string4 = decompositionStruct.agent;
        String string5 = decompositionStruct.image.getId();
        if (decompositionStruct2.record == null) {
            String string6 = (String)decompositionStruct2.lookupTable.get(decompositionStruct.parent_link);
            SuppliedItem suppliedItem = decompositionStruct2.given.getSuppliedItem(string6);
            String[] stringArray = suppliedItem.getReservationId();
            for (int i = 0; i < stringArray.length; ++i) {
                String string7 = suppliedItem.getReservingAgent(stringArray[i]);
                String string8 = suppliedItem.getReservationGoalId(stringArray[i]);
                String string9 = suppliedItem.getReservationCommsKey(stringArray[i]);
                int n = suppliedItem.getReservedAmount(stringArray[i]);
                int n2 = suppliedItem.getReservationTime(stringArray[i]);
                boolean bl = suppliedItem.isReservationConsumed(stringArray[i]);
                Assert.notFalse(n > 0);
                decompositionStruct2.image.addProducer(string6, stringArray[i], string9, string4, string5, string7, string8);
                decompositionStruct.image.addConsumer(string4, string5, string7, string8, stringArray[i], string9, n2, n, bl);
            }
        } else {
            String string10 = this.planner.getAgentContext().newId("used");
            String string11 = this.planner.getAgentContext().whoami();
            String string12 = decompositionStruct2.goal.getId();
            int n = decompositionStruct2.record.getStartTime();
            int n3 = decompositionStruct2.record.getConsumedPosition(string5);
            boolean bl = decompositionStruct2.record.isPreconditionConsumed(n3);
            int n4 = decompositionStruct2.record.getAmountUsed(n3);
            Assert.notFalse(n4 > 0);
            decompositionStruct.image.addConsumer(string4, string5, string11, string12, string10, string3, n, n4, bl);
            decompositionStruct2.record.getConsumedDb().update(string5 + "/" + string10, string5);
        }
        decompositionStruct.key = string3;
    }

    public void enforceLinks() {
        Enumeration enumeration = this.links.elements();
        while (enumeration.hasMoreElements()) {
            boolean bl;
            int n;
            int n2;
            String string;
            String string2;
            String string3;
            int n3;
            String string4;
            String string5;
            String[] stringArray;
            SuppliedItem suppliedItem;
            String string6;
            TaskLink taskLink = (TaskLink)enumeration.nextElement();
            Core.DEBUG(2, "About to hardChain " + taskLink.getId());
            LinkInfo linkInfo = this.getLinkInfo(taskLink);
            if (linkInfo.child.record != null) {
                if (linkInfo.parent.record != null) {
                    linkInfo.child.record.getProducedDb().hardChain(linkInfo.effect_position, linkInfo.amount, linkInfo.parent.record, linkInfo.precond_position);
                    continue;
                }
                string6 = (String)linkInfo.parent.lookupTable.get(taskLink.getId());
                suppliedItem = linkInfo.parent.given.getSuppliedItem(string6);
                stringArray = suppliedItem.getReservationId();
                string5 = this.planner.getAgentContext().whoami();
                string4 = linkInfo.child.goal.getId();
                for (n3 = 0; n3 < stringArray.length; ++n3) {
                    string3 = suppliedItem.getReservingAgent(stringArray[n3]);
                    string2 = suppliedItem.getReservationGoalId(stringArray[n3]);
                    string = suppliedItem.getReservationCommsKey(stringArray[n3]);
                    linkInfo.parent.image.addProducer(string6, stringArray[n3], string, string5, string4, string3, string2);
                    n2 = suppliedItem.getReservedAmount(stringArray[n3]);
                    n = suppliedItem.getReservationTime(stringArray[n3]);
                    bl = suppliedItem.isReservationConsumed(stringArray[n3]);
                    Assert.notFalse(n2 > 0);
                    linkInfo.child.record.getProducedDb().hardChain(linkInfo.effect_position, string2 + "/" + stringArray[n3], n2, n, bl);
                }
                continue;
            }
            if (linkInfo.parent.record != null) {
                String string7 = this.planner.getAgentContext().newId("used");
                linkInfo.child.image.addConsumer(linkInfo.child.agent, linkInfo.child.goal.getId(), this.planner.getAgentContext().whoami(), linkInfo.parent.goal.getId(), string7, linkInfo.child.key, linkInfo.start, linkInfo.amount, linkInfo.consumed);
                linkInfo.parent.record.getConsumedDb().add(linkInfo.precond_position, linkInfo.child.goal.getId() + "/" + string7, linkInfo.amount);
                continue;
            }
            string6 = (String)linkInfo.parent.lookupTable.get(taskLink.getId());
            suppliedItem = linkInfo.parent.given.getSuppliedItem(string6);
            stringArray = suppliedItem.getReservationId();
            string5 = linkInfo.child.agent;
            string4 = linkInfo.child.goal.getId();
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                string3 = suppliedItem.getReservingAgent(stringArray[n3]);
                string2 = suppliedItem.getReservationGoalId(stringArray[n3]);
                string = suppliedItem.getReservationCommsKey(stringArray[n3]);
                linkInfo.parent.image.addProducer(string6, stringArray[n3], string, string5, string4, string3, string2);
                n2 = suppliedItem.getReservedAmount(stringArray[n3]);
                n = suppliedItem.getReservationTime(stringArray[n3]);
                bl = suppliedItem.isReservationConsumed(stringArray[n3]);
                Assert.notFalse(n2 > 0);
                linkInfo.child.image.addConsumer(linkInfo.child.agent, linkInfo.child.goal.getId(), string3, string2, stringArray[n3], string, n, n2, bl);
            }
        }
        this.links.removeAllElements();
    }

    protected LinkInfo getLinkInfo(TaskLink taskLink) {
        int n;
        Fact[] factArray;
        Fact fact;
        LinkInfo linkInfo = new LinkInfo();
        Bindings bindings = new Bindings(this.planner.getAgentContext().whoami());
        linkInfo.child = (DecompositionStruct)this.get(taskLink.getLeftNode());
        linkInfo.parent = (DecompositionStruct)this.get(taskLink.getRightNode());
        if (linkInfo.child.record != null) {
            fact = linkInfo.child.node.getPostcondition(taskLink.getLeftGroup(), taskLink.getLeftArg());
            factArray = linkInfo.child.record.getTask().getPostconditions();
            for (n = 0; n < factArray.length; ++n) {
                if (fact.unifiesWith(factArray[n], bindings)) {
                    linkInfo.effect_position = n;
                    break;
                }
                bindings.clear();
            }
        }
        if (linkInfo.parent.record != null) {
            fact = linkInfo.parent.node.getPrecondition(taskLink.getRightGroup(), taskLink.getRightArg());
            factArray = linkInfo.parent.record.getTask().getPreconditions();
            for (n = 0; n < factArray.length; ++n) {
                if (fact.unifiesWith(factArray[n], bindings)) {
                    linkInfo.precond_position = n;
                    linkInfo.amount = factArray[n].getNumber();
                    if (linkInfo.amount == 0) {
                        System.err.println("Error: integer expected in task.precond.fact.no field.\nEnsure \"no\" constraints are defined in all task specifications >> " + taskLink.getId());
                        linkInfo.amount = 1;
                    }
                    linkInfo.consumed = !factArray[n].isReadOnly();
                    linkInfo.start = linkInfo.parent.record.getStartTime();
                    break;
                }
                bindings.clear();
            }
        }
        return linkInfo;
    }

    public SuppliedDb getSuppliedDb(String string) {
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        if (decompositionStruct.given != null) {
            return decompositionStruct.given;
        }
        decompositionStruct.given = new SuppliedDb(this.planner.getAgentContext().OntologyDb());
        decompositionStruct.lookupTable = new Hashtable();
        Enumeration enumeration = this.links.elements();
        String string2 = this.planner.getAgentContext().whoami();
        while (enumeration.hasMoreElements()) {
            TaskLink taskLink = (TaskLink)enumeration.nextElement();
            if (!taskLink.getRightNode().equals(string)) continue;
            Fact fact = decompositionStruct.node.getPrecondition(taskLink.getRightGroup(), taskLink.getRightArg());
            String string3 = this.planner.getAgentContext().newId("supplied");
            SuppliedItem suppliedItem = new SuppliedItem(string3, taskLink.getId(), string2, fact);
            decompositionStruct.given.add(suppliedItem);
            decompositionStruct.lookupTable.put(taskLink.getId(), string3);
        }
        return decompositionStruct.given;
    }
}

