/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import zeus.actors.DataRec;
import zeus.actors.PlanRecord;
import zeus.actors.PreconditionChain;
import zeus.actors.ResourceDb;
import zeus.actors.rtn.Engine;
import zeus.concepts.Bindings;
import zeus.concepts.Fact;
import zeus.concepts.Goal;
import zeus.concepts.PrimitiveTask;
import zeus.concepts.SuppliedDb;
import zeus.util.Assert;
import zeus.util.Core;
import zeus.util.Misc;

public class ConsumedDb {
    protected Vector[] data = null;
    protected int[] consumed = null;
    protected DataRec[] records = null;
    protected PlanRecord owner = null;
    protected boolean resources_consumed = false;
    protected boolean resources_released = false;
    protected Vector all_subgoals = new Vector();

    public ConsumedDb() {
    }

    public ConsumedDb(PlanRecord planRecord, PrimitiveTask primitiveTask) {
        this.consumed = primitiveTask.numPreconditions();
        Assert.notNull(planRecord);
        this.owner = planRecord;
        this.data = new Vector[this.consumed.length];
        this.records = new DataRec[this.consumed.length];
        for (int i = 0; i < this.records.length; ++i) {
            this.records[i] = new DataRec(primitiveTask.getPrecondition(i), planRecord, i);
        }
    }

    public DataRec getDatarec(int n) {
        Core.DEBUG(2, "Getting datarec for " + this.owner + " at position " + n);
        return this.records[n];
    }

    public int amountUsed(int n) {
        return this.consumed[n];
    }

    public synchronized void add(int n, PlanRecord planRecord, int n2, int n3) {
        Assert.notFalse(this.requiredItems(n) >= n3);
        if (this.data[n] == null) {
            this.data[n] = new Vector();
        }
        PreconditionChain preconditionChain = new PreconditionChain(planRecord, n2, n3);
        this.data[n].addElement(preconditionChain);
    }

    public synchronized void add(int n, String string, int n2) {
        Assert.notFalse(this.requiredItems(n) >= n2);
        if (this.data[n] == null) {
            this.data[n] = new Vector();
        }
        PreconditionChain preconditionChain = new PreconditionChain(string, n2);
        this.data[n].addElement(preconditionChain);
    }

    public synchronized void add(int n, PreconditionChain preconditionChain) {
        Assert.notFalse(this.requiredItems(n) >= preconditionChain.amount);
        if (this.data[n] == null) {
            this.data[n] = new Vector();
        }
        this.data[n].addElement(preconditionChain);
    }

    public int requiredItems(int n) {
        if (this.records[n] == null) {
            return this.consumed[n];
        }
        int n2 = this.records[n].nAvailable();
        if (this.data[n] != null) {
            for (int i = 0; i < this.data[n].size(); ++i) {
                PreconditionChain preconditionChain = (PreconditionChain)this.data[n].elementAt(i);
                n2 += preconditionChain.amount;
            }
        }
        return this.consumed[n] - n2;
    }

    public boolean hasEnoughResources() {
        boolean bl = true;
        ResourceDb resourceDb = this.owner.getAgentContext().ResourceDb();
        int n = (int)this.owner.getAgentContext().now();
        for (int i = 0; bl && i < this.records.length; bl &= this.records[i].nAvailable() == this.consumed[i] && this.records[i].executeNow(resourceDb, n), ++i) {
        }
        return bl;
    }

    public void newStartTime(int n) {
        for (int i = 0; i < this.records.length; ++i) {
            this.records[i].newStartTime(n);
        }
    }

    public void consumeResources() {
        ResourceDb resourceDb = this.owner.getAgentContext().ResourceDb();
        for (int i = 0; i < this.records.length; ++i) {
            resourceDb.consume(this.records[i]);
        }
        this.resources_consumed = true;
    }

    public int getPosition(String string) {
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; this.data[i] != null && j < this.data[i].size(); ++j) {
                PreconditionChain preconditionChain = (PreconditionChain)this.data[i].elementAt(j);
                if (!preconditionChain.isExternal() || !string.equals(preconditionChain.key)) continue;
                return i;
            }
        }
        Assert.notNull(null);
        return -1;
    }

    public void factExists(int n, PlanRecord planRecord, int n2, int n3) {
        ResourceDb resourceDb = this.owner.getAgentContext().ResourceDb();
        Vector vector = this.data[n];
        for (int i = 0; i < vector.size(); ++i) {
            PreconditionChain preconditionChain = (PreconditionChain)vector.elementAt(i);
            if (preconditionChain.record != planRecord || preconditionChain.position != n2 || preconditionChain.amount != n3) continue;
            vector.removeElementAt(i--);
            Goal goal = resourceDb.allocateResource(this.owner, n, n3);
            if (goal != null) {
                System.err.println("Resource Taken by someone?:\n" + goal);
                try {
                    throw new Exception();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            Core.DEBUG(2, "Calling Constrain: " + this.records[n]);
            this.constrain(this.records[n]);
            return;
        }
        Assert.notNull(null);
    }

    public void factExists(String string) {
        ResourceDb resourceDb = this.owner.getAgentContext().ResourceDb();
        int n = this.getPosition(string);
        Vector vector = this.data[n];
        for (int i = 0; i < vector.size(); ++i) {
            PreconditionChain preconditionChain = (PreconditionChain)vector.elementAt(i);
            if (!preconditionChain.isExternal() || !preconditionChain.key.equals(string)) continue;
            vector.removeElementAt(i--);
            Goal goal = resourceDb.allocateResource(this.owner, n, preconditionChain.amount);
            if (goal != null) {
                System.err.println("Resource Taken by someone?:\n" + goal);
            }
            this.constrain(this.records[n]);
            Core.DEBUG(2, "Calling Constrain: " + this.records[n]);
            return;
        }
        Assert.notNull(null);
    }

    public synchronized void replace(String string, PlanRecord planRecord, int n, int n2) {
        int n3 = this.getPosition(string);
        Vector vector = this.data[n3];
        for (int i = 0; i < vector.size(); ++i) {
            PreconditionChain preconditionChain = (PreconditionChain)vector.elementAt(i);
            if (!preconditionChain.isExternal() || !preconditionChain.key.equals(string)) continue;
            if (preconditionChain.amount == n2) {
                vector.removeElementAt(i--);
            } else {
                preconditionChain.amount -= n2;
            }
            preconditionChain = new PreconditionChain(planRecord, n, n2);
            vector.addElement(preconditionChain);
            return;
        }
        Assert.notNull(null);
    }

    protected boolean constrain(DataRec dataRec) {
        Core.DEBUG(2, "Constrain: " + dataRec);
        Fact fact = dataRec.mostGeneralDescriptor();
        Core.DEBUG(2, "Constrain: mgd " + fact);
        Bindings bindings = new Bindings(this.owner.getAgentContext().whoami());
        Fact fact2 = dataRec.getFact();
        Core.DEBUG(2, "Constrain: getFact " + fact2);
        Assert.notFalse(fact.unifiesWith(fact2, bindings));
        return this.owner.applyConstraints(bindings);
    }

    public Fact[][] getInputData() {
        Fact[][] factArray = new Fact[this.consumed.length][];
        for (int i = 0; i < factArray.length; ++i) {
            factArray[i] = this.records[i].getData();
        }
        return factArray;
    }

    public PlanRecord getOwner() {
        return this.owner;
    }

    public synchronized void share(ConsumedDb consumedDb) {
        for (int i = 0; i < this.consumed.length; ++i) {
            int n = consumedDb.requiredItems(i);
            DataRec dataRec = this.records[i].subtract(consumedDb.getOwner(), i, n);
            Assert.notNull(dataRec);
            Core.DEBUG(2, "Share consumedb of " + this.owner + " at " + i + " require " + (n -= dataRec.nAvailable()));
            for (int j = 0; n > 0 && j < this.data[i].size(); ++j) {
                PreconditionChain preconditionChain = (PreconditionChain)this.data[i].elementAt(j);
                if (preconditionChain.amount <= n) {
                    this.data[i].removeElementAt(j--);
                    n -= preconditionChain.amount;
                } else {
                    preconditionChain.amount -= n;
                    preconditionChain = new PreconditionChain(preconditionChain);
                    preconditionChain.amount = n;
                    n = 0;
                }
                consumedDb.add(i, preconditionChain);
            }
        }
    }

    public synchronized Hashtable getAllChildren() {
        System.out.println("getAllChildren is called");
        Hashtable<Fact, Object> hashtable = new Hashtable<Fact, Object>();
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; this.data[i] != null && j < this.data[i].size(); ++j) {
                PreconditionChain preconditionChain = (PreconditionChain)this.data[i].elementAt(j);
                Fact fact = new Fact(this.records[i].getFact());
                fact.setNumber(preconditionChain.amount);
                if (preconditionChain.isExternal()) {
                    hashtable.put(fact, preconditionChain.key);
                    continue;
                }
                hashtable.put(fact, preconditionChain.record);
            }
        }
        return hashtable;
    }

    public synchronized Vector currentSubgoals() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; this.data[i] != null && j < this.data[i].size(); ++j) {
                PreconditionChain preconditionChain = (PreconditionChain)this.data[i].elementAt(j);
                if (preconditionChain.isExternal()) {
                    StringTokenizer stringTokenizer = new StringTokenizer(preconditionChain.key, "/");
                    vector.addElement(stringTokenizer.nextToken());
                    continue;
                }
                vector.addElement(preconditionChain.record.getGoal().getId());
            }
        }
        return vector;
    }

    public synchronized Vector allSubgoals() {
        Vector vector = this.currentSubgoals();
        this.all_subgoals = Misc.union(this.all_subgoals, vector);
        return this.all_subgoals;
    }

    public synchronized PlanRecord[] getChildren() {
        int n;
        Vector<PlanRecord> vector = new Vector<PlanRecord>();
        for (int i = 0; i < this.data.length; ++i) {
            for (n = 0; this.data[i] != null && n < this.data[i].size(); ++n) {
                PreconditionChain preconditionChain = (PreconditionChain)this.data[i].elementAt(n);
                if (preconditionChain.isExternal() || vector.contains(preconditionChain.record)) continue;
                vector.addElement(preconditionChain.record);
            }
        }
        PlanRecord[] planRecordArray = new PlanRecord[vector.size()];
        for (n = 0; n < planRecordArray.length; ++n) {
            planRecordArray[n] = (PlanRecord)vector.elementAt(n);
        }
        vector = null;
        return planRecordArray;
    }

    public synchronized boolean update(PlanRecord planRecord, PlanRecord planRecord2) {
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; this.data[i] != null && j < this.data[i].size(); ++j) {
                PreconditionChain preconditionChain = (PreconditionChain)this.data[i].elementAt(j);
                if (preconditionChain.isExternal() || preconditionChain.record != planRecord2) continue;
                preconditionChain.record = planRecord;
                return true;
            }
        }
        return false;
    }

    public synchronized boolean update(String string, String string2) {
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; this.data[i] != null && j < this.data[i].size(); ++j) {
                PreconditionChain preconditionChain = (PreconditionChain)this.data[i].elementAt(j);
                if (!preconditionChain.isExternal() || !preconditionChain.key.equals(string2)) continue;
                preconditionChain.key = string;
                return true;
            }
        }
        return false;
    }

    public synchronized void releaseResources(SuppliedDb suppliedDb) {
        if (this.resources_consumed) {
            return;
        }
        if (this.resources_released) {
            return;
        }
        ResourceDb resourceDb = this.owner.getAgentContext().ResourceDb();
        for (int i = 0; i < this.records.length; ++i) {
            resourceDb.free(this.records[i]);
        }
        Engine engine = this.owner.getAgentContext().Engine();
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; this.data[i] != null && j < this.data[i].size(); ++j) {
                PreconditionChain preconditionChain = (PreconditionChain)this.data[i].elementAt(j);
                if (preconditionChain.isExternal()) {
                    if (suppliedDb != null && suppliedDb.cancelReservation(preconditionChain.key)) continue;
                    engine.getAuditTable().cancel(preconditionChain.key);
                    continue;
                }
                preconditionChain.record.breakEffectChain(preconditionChain.position, this.owner, i, preconditionChain.amount);
            }
        }
        this.resources_released = true;
    }

    public synchronized Fact remove(String string) {
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; this.data[i] != null && j < this.data[i].size(); ++j) {
                PreconditionChain preconditionChain = (PreconditionChain)this.data[i].elementAt(j);
                if (!preconditionChain.isExternal() || !string.equals(preconditionChain.key)) continue;
                this.data[i].removeElementAt(j--);
                Fact fact = new Fact(this.records[i].getFact());
                fact.setNumber(preconditionChain.amount);
                return fact;
            }
        }
        Assert.notNull(null);
        return null;
    }

    public synchronized Fact remove(int n, PlanRecord planRecord, int n2, int n3) {
        for (int i = 0; i < this.data[n].size(); ++i) {
            PreconditionChain preconditionChain = (PreconditionChain)this.data[n].elementAt(i);
            if (preconditionChain.record != planRecord || preconditionChain.position != n2 || preconditionChain.amount != n3) continue;
            this.data[n].removeElementAt(i--);
            Fact fact = new Fact(this.records[n].getFact());
            fact.setNumber(preconditionChain.amount);
            return fact;
        }
        Assert.notNull(null);
        return null;
    }

    public String toString() {
        String string = "ConsumedDb(\n" + this.owner + "\n";
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == null) continue;
            string = string + "data[" + i + "]: " + this.data[i] + "\n";
        }
        string = string + ")";
        return string;
    }
}

